/*
 * Decompiled with CFR 0.152.
 */
package net.shirojr.nemuelch.entity.client;

import net.minecraft.class_1297;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4604;
import net.minecraft.class_4608;
import net.minecraft.class_5617;
import net.minecraft.class_761;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_897;
import net.minecraft.class_927;
import net.shirojr.nemuelch.compat.cca.component.AttachableComponent;
import net.shirojr.nemuelch.entity.client.PotLauncherEntityModel;
import net.shirojr.nemuelch.entity.custom.PotLauncherEntity;
import net.shirojr.nemuelch.init.NeMuelchEntityModelLayers;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class PotLauncherEntityRenderer
extends class_897<PotLauncherEntity> {
    private final PotLauncherEntityModel<PotLauncherEntity> baseModel;

    public PotLauncherEntityRenderer(class_5617.class_5618 ctx) {
        super(ctx);
        this.baseModel = new PotLauncherEntityModel(ctx.method_32167(NeMuelchEntityModelLayers.POT_LAUNCHER));
    }

    public class_2960 getTexture(PotLauncherEntity entity) {
        return new class_2960("nemuelch", "textures/entity/pot_launcher_entity.png");
    }

    public boolean shouldRender(PotLauncherEntity entity, class_4604 frustum, double x, double y, double z) {
        return true;
    }

    public void render(PotLauncherEntity entity, float yaw, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light) {
        if (this.field_4676.method_3958()) {
            this.renderInteractionBoxes(entity, matrices, vertexConsumers);
        }
        this.renderDropPotItem(entity, matrices, vertexConsumers, light, tickDelta);
        this.renderLeash(entity, tickDelta, matrices, vertexConsumers);
        this.renderLauncher(entity, matrices, vertexConsumers, light, tickDelta);
        super.method_3936((class_1297)entity, yaw, tickDelta, matrices, vertexConsumers, light);
    }

    private void renderInteractionBoxes(PotLauncherEntity entity, class_4587 matrices, class_4597 vertexConsumers) {
        entity.getInteractionBoxes().forEach((interactionHitBox, box) -> {
            Vector3f color = interactionHitBox.getDebugColor();
            class_761.method_22982((class_4587)matrices, (class_4588)vertexConsumers.getBuffer((class_1921)class_1921.field_21695), (class_238)box, (float)color.x, (float)color.y, (float)color.z, (float)1.0f);
        });
    }

    private void renderDropPotItem(PotLauncherEntity entity, class_4587 matrices, class_4597 vertexConsumers, int light, float tickDelta) {
        float potScale = 3.0f;
        float pivotY = 0.9f;
        float pivotZ = 0.5f;
        matrices.method_22903();
        matrices.method_22904(0.0, 1.25 + (double)pivotY, 0.0);
        matrices.method_22907(class_7833.field_40715.rotationDegrees(entity.getAngles().method_10257()));
        matrices.method_46416(0.0f, 0.0f, pivotZ);
        matrices.method_22907(class_7833.field_40714.rotationDegrees(entity.getAngles().method_10256()));
        matrices.method_22904(0.0, (double)(0.0f - pivotY), (double)(-pivotZ) - 1.3);
        float interpolatedTicks = entity.isActivated() ? (float)entity.getActivationTicks() + tickDelta : 0.0f;
        float normalizedPosition = interpolatedTicks / 20.0f;
        matrices.method_46416(0.0f, 0.0f, class_3532.method_16439((float)(normalizedPosition * normalizedPosition * normalizedPosition), (float)0.0f, (float)1.5f));
        matrices.method_22905(potScale, potScale, potScale);
        class_310.method_1551().method_1480().method_23178(entity.getPotSlot(), class_811.field_4318, light, class_4608.field_21444, matrices, vertexConsumers, (class_1937)class_310.method_1551().field_1687, entity.hashCode());
        matrices.method_22909();
    }

    private void renderLeash(PotLauncherEntity entity, float tickDelta, class_4587 matrices, class_4597 provider) {
        int segmentIndex;
        class_1297 leashHolderEntity = AttachableComponent.get(entity).getAttachedEntity();
        if (leashHolderEntity == null) {
            return;
        }
        matrices.method_22903();
        class_243 holderPos = leashHolderEntity.method_30951(tickDelta);
        double yawInRad = Math.toRadians(entity.getAngles().method_10257()) + 1.5707963267948966;
        class_243 leashOffset = entity.method_29919();
        double relativeXOffset = Math.cos(yawInRad) * leashOffset.field_1350 + Math.sin(yawInRad) * leashOffset.field_1352;
        double relativeZOffset = Math.sin(yawInRad) * leashOffset.field_1350 - Math.cos(yawInRad) * leashOffset.field_1352;
        class_243 attachmentPos = new class_243(entity.method_23317() + relativeXOffset, entity.method_23318() + leashOffset.field_1351, entity.method_23321() + relativeZOffset);
        matrices.method_22904(relativeXOffset, attachmentPos.method_10214() - entity.method_23318(), relativeZOffset);
        class_243 direction = holderPos.method_1020(attachmentPos);
        class_4588 vertexConsumer = provider.getBuffer(class_1921.method_23587());
        Matrix4f transformationMatrices = matrices.method_23760().method_23761();
        int entityLight = this.method_24087(entity, entity.method_24515());
        int holderLight = this.field_4676.method_3953(leashHolderEntity).method_24087(leashHolderEntity, class_2338.method_49638((class_2374)leashHolderEntity.method_5836(tickDelta)));
        int entitySkyLight = entity.method_37908().method_8314(class_1944.field_9284, entity.method_24515());
        int holderSkyLight = entity.method_37908().method_8314(class_1944.field_9284, leashHolderEntity.method_24515());
        int segments = 24;
        float segmentThickness = 0.125f;
        float normalizedLength = (float)(class_3532.method_15345((double)(direction.field_1352 * direction.field_1352 + direction.field_1350 * direction.field_1350)) * (double)0.025f / 2.0);
        float offsetXThickness = (float)((double)normalizedLength * direction.field_1350);
        float offsetZThickness = (float)((double)normalizedLength * direction.field_1352);
        for (segmentIndex = 0; segmentIndex < segments; ++segmentIndex) {
            class_927.method_23187((class_4588)vertexConsumer, (Matrix4f)transformationMatrices, (float)((float)direction.field_1352), (float)((float)direction.field_1351), (float)((float)direction.field_1350), (int)entityLight, (int)holderLight, (int)entitySkyLight, (int)holderSkyLight, (float)segmentThickness, (float)segmentThickness, (float)offsetXThickness, (float)offsetZThickness, (int)segmentIndex, (boolean)false);
        }
        for (segmentIndex = segments; segmentIndex >= 0; --segmentIndex) {
            class_927.method_23187((class_4588)vertexConsumer, (Matrix4f)transformationMatrices, (float)((float)direction.field_1352), (float)((float)direction.field_1351), (float)((float)direction.field_1350), (int)entityLight, (int)holderLight, (int)entitySkyLight, (int)holderSkyLight, (float)segmentThickness, (float)segmentThickness, (float)offsetXThickness, (float)offsetZThickness, (int)segmentIndex, (boolean)true);
        }
        matrices.method_22909();
    }

    private void renderLauncher(PotLauncherEntity entity, class_4587 matrices, class_4597 vertexConsumers, int light, float tickDelta) {
        float baseScale = 1.6f;
        matrices.method_22903();
        matrices.method_22904(0.0, (double)2.4f, 0.0);
        matrices.method_22907(class_7833.field_40718.rotationDegrees(180.0f));
        matrices.method_22905(baseScale, baseScale, baseScale);
        this.baseModel.setAngles(entity, tickDelta);
        class_4588 vertexConsumer = vertexConsumers.getBuffer(this.baseModel.method_23500(this.getTexture(entity)));
        this.baseModel.method_2828(matrices, vertexConsumer, light, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
        matrices.method_22909();
    }
}

