/*
 * Decompiled with CFR 0.152.
 */
package net.shirojr.nemuelch.entity.custom.projectile;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1262;
import net.minecraft.class_1264;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1541;
import net.minecraft.class_1675;
import net.minecraft.class_1676;
import net.minecraft.class_1686;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2530;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3489;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_4537;
import net.minecraft.class_4538;
import net.shirojr.nemuelch.block.entity.custom.DropPotBlockEntity;
import net.shirojr.nemuelch.init.NeMuelchBlocks;
import net.shirojr.nemuelch.init.NeMuelchEntities;
import net.shirojr.nemuelch.init.NeMuelchSounds;
import net.shirojr.nemuelch.init.NeMuelchTags;
import net.shirojr.nemuelch.item.custom.supportItem.DropPotBlockItem;
import net.shirojr.nemuelch.network.util.NetworkIdentifiers;
import net.shirojr.nemuelch.util.helper.SoundInstanceHelper;
import net.shirojr.nemuelch.util.logger.LoggerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DropPotEntity
extends class_1676 {
    public static final int RENDER_DISTANCE = 300;
    public static final int MAX_IDLE_TICKS = 120;
    public static final int TNT_DIMINISHING_AMOUNT_THRESHOLD = 4;
    public static final int TNT_OVERLOAD_DIVIDER = 4;
    @Nullable
    private UUID userUuid;
    private static final class_2940<Integer> COLOR = class_2945.method_12791(DropPotEntity.class, (class_2941)class_2943.field_13327);
    private final class_2371<class_1799> inventory = class_2371.method_10213((int)9, (Object)class_1799.field_8037);
    private int idleTicks = 0;

    public DropPotEntity(class_1299<DropPotEntity> dropPotEntityEntityType, class_1937 world) {
        super(dropPotEntityEntityType, world);
    }

    public DropPotEntity(class_1937 world, class_243 pos, class_243 velocity) {
        this(NeMuelchEntities.DROP_POT, world);
        this.method_33574(pos);
        this.method_18799(velocity);
        this.field_6007 = true;
    }

    public DropPotEntity(class_1937 world, class_243 pos, class_243 velocity, class_2371<class_1799> inventory) {
        this(world, pos, velocity);
        if (inventory == null) {
            return;
        }
        for (int i = 0; i < this.getInventory().size(); ++i) {
            this.getInventory().set(i, (Object)((class_1799)inventory.get(i)));
        }
    }

    public DropPotEntity(class_1937 world, class_243 pos, class_243 velocity, class_1799 dropPotStack) {
        this(world, pos, velocity);
        if (!(dropPotStack.method_7909() instanceof DropPotBlockItem)) {
            throw new IllegalArgumentException("DropPotEntity was initialized with a non-DropPot ItemStack");
        }
        class_2371<class_1799> inventory = DropPotBlockItem.getInventory(dropPotStack);
        if (inventory.size() != this.getInventory().size()) {
            throw new IllegalArgumentException("DropPot Item Inventory size didn't match Entity Inventory");
        }
        for (int i = 0; i < this.getInventory().size(); ++i) {
            this.getInventory().set(i, (Object)((class_1799)inventory.get(i)));
        }
    }

    public DropPotEntity(class_1937 world, @NotNull class_1297 user) {
        this(NeMuelchEntities.DROP_POT, world);
        this.userUuid = user.method_5667();
        class_2338.class_2339 posWalker = user.method_24515().method_25503();
        for (int i = 0; i < 2; ++i) {
            posWalker.method_10098(class_2350.field_11033);
            if (!world.method_8320((class_2338)posWalker).method_26215()) break;
        }
        this.method_33574(class_243.method_24953((class_2382)posWalker));
        this.method_18799(user.method_18798());
        this.method_5875(false);
        this.field_6007 = true;
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            serverWorld.method_8396(null, user.method_24515(), NeMuelchSounds.POT_RELEASE, class_3419.field_15248, 5.0f, 1.0f);
        }
    }

    public DropPotEntity(class_1937 world, @NotNull class_1297 user, List<class_1799> inventory) {
        this(world, user);
        if (inventory != null) {
            for (int i = 0; i < this.getInventory().size(); ++i) {
                this.getInventory().set(i, (Object)inventory.get(i));
            }
        }
    }

    public class_2371<class_1799> getInventory() {
        return this.inventory;
    }

    protected void method_5693() {
        this.field_6011.method_12784(COLOR, (Object)-1);
    }

    public void method_5773() {
        class_3218 serverWorld;
        class_1937 class_19372;
        super.method_5773();
        class_243 potVelocity = this.method_18798();
        class_239 hitResult = class_1675.method_49997((class_1297)this, x$0 -> this.method_26958((class_1297)x$0));
        if (!hitResult.method_17783().equals((Object)class_239.class_240.field_1333)) {
            this.method_7488(hitResult);
            return;
        }
        this.method_18799(potVelocity.method_1021((double)0.99f));
        class_243 bufferVelocity = null;
        if (!this.method_5740()) {
            bufferVelocity = this.method_18798();
            this.method_18799(this.method_18798().method_1031(0.0, (double)(-this.getFallingSpeed()), 0.0));
            this.field_6007 = true;
        }
        this.method_5784(class_1313.field_6308, this.method_18798());
        if (bufferVelocity != null && bufferVelocity.field_1351 == this.method_18798().field_1351 && (class_19372 = this.method_37908()) instanceof class_3218) {
            serverWorld = (class_3218)class_19372;
            this.onLanded(serverWorld, this.method_24515());
        }
        this.method_26962();
        this.idleTicks = potVelocity.method_1027() < 0.01 ? ++this.idleTicks : 0;
        if (this.idleTicks >= 120 && (class_19372 = this.method_37908()) instanceof class_3218) {
            serverWorld = (class_3218)class_19372;
            this.onLanded(serverWorld, this.method_24515());
        }
    }

    private float getFallingSpeed() {
        return this.method_5869() ? 0.005f : 0.04f;
    }

    protected void method_24920(class_3965 blockHitResult) {
        super.method_24920(blockHitResult);
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            LoggerUtil.devLogger(String.valueOf(this.method_18798().method_1033()));
            this.onLanded(serverWorld, blockHitResult.method_17777().method_10093(blockHitResult.method_17780()));
            this.method_18799(class_243.field_1353);
        }
    }

    protected void method_7454(class_3966 entityHitResult) {
        super.method_7454(entityHitResult);
        if (entityHitResult.method_17782().method_5667().equals(this.userUuid) && this.field_6012 < 60) {
            return;
        }
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            LoggerUtil.devLogger(String.valueOf(this.method_18798().method_1033()));
            class_2338.class_2339 posOnGround = entityHitResult.method_17782().method_24515().method_25503();
            int groundClearance = 5;
            for (int i = 0; i < groundClearance && this.method_37908().method_8320(posOnGround.method_10074()).method_26184((class_4538)this.method_37908(), posOnGround.method_10074()); ++i) {
                posOnGround.method_10098(class_2350.field_11033);
                if (i != groundClearance - 1) continue;
                posOnGround = entityHitResult.method_17782().method_24515().method_25503();
            }
            this.onLanded(serverWorld, posOnGround.method_10062());
            class_1297 user = this.getUser(this.method_37908());
            float damageRange = (float)class_3532.method_15350((double)this.method_18798().method_1033(), (double)0.5, (double)2.5);
            float normalizedDamage = (damageRange - 0.5f) / 2.0f;
            entityHitResult.method_17782().method_5643(this.method_37908().method_48963().method_48798(user), (float)class_3532.method_48781((float)normalizedDamage, (int)1, (int)20));
        }
        this.method_18799(class_243.field_1353);
        if (!this.method_37908().method_8608()) {
            this.method_31472();
        }
    }

    private void onLanded(class_3218 world, class_2338 pos) {
        boolean shouldBreak = this.method_18798().method_1033() > 0.4;
        for (class_1799 stack : this.inventory) {
            if (!stack.method_31573(class_3489.field_15544) && !stack.method_31573(class_3489.field_15542)) continue;
            shouldBreak = false;
        }
        if (world.method_8320(pos.method_10074()).method_26164(class_3481.field_15481) || world.method_8320(pos).method_26164(class_3481.field_15479)) {
            shouldBreak = false;
        }
        class_3414 landingSound = shouldBreak ? NeMuelchSounds.POT_HIT : NeMuelchSounds.POT_LAND;
        int particleAmount = shouldBreak ? 20 : 5;
        world.method_8396(null, pos, landingSound, class_3419.field_15245, 3.0f, 1.0f);
        for (int i = 0; i < particleAmount; ++i) {
            world.method_14199((class_2394)class_2398.field_17430, this.method_19538().method_10216() + 0.5 + this.field_5974.method_43058() / 3.0 * (double)(this.field_5974.method_43056() ? 1 : -1), this.method_19538().method_10214() + this.field_5974.method_43058(), this.method_19538().method_10215() + 0.5 + this.field_5974.method_43058() / 3.0 * (double)(this.field_5974.method_43056() ? 1 : -1), 1, 0.0, 0.07, 0.0, 0.2);
        }
        if (shouldBreak) {
            boolean canIgniteTnt = false;
            ArrayList<class_1799> throwablePotionStacks = new ArrayList<class_1799>();
            ArrayList<class_2530> tntBlocks = new ArrayList<class_2530>();
            for (int i = 0; i < this.inventory.size(); ++i) {
                class_1747 blockItem;
                class_1792 class_17922;
                class_1799 stack = (class_1799)this.inventory.get(i);
                if (stack.method_31573(NeMuelchTags.Items.IGNITES_POTS)) {
                    canIgniteTnt = true;
                }
                if (stack.method_7909() instanceof class_4537) {
                    throwablePotionStacks.add(stack.method_7972());
                    this.inventory.set(i, (Object)class_1799.field_8037);
                }
                if (!((class_17922 = stack.method_7909()) instanceof class_1747) || !((class_17922 = (blockItem = (class_1747)class_17922).method_7711()) instanceof class_2530)) continue;
                class_2530 tntBlock = (class_2530)class_17922;
                int amount = stack.method_7947();
                if (amount > 4) {
                    int overThreshold = amount - 4;
                    amount = 4 + overThreshold / 4;
                }
                for (int unused = 0; unused < amount; ++unused) {
                    tntBlocks.add(tntBlock);
                }
                this.inventory.set(i, (Object)class_1799.field_8037);
            }
            for (class_1799 stack : throwablePotionStacks) {
                class_1686 potionEntity;
                class_243 unitDirection = this.method_18798().method_18805(1.0, 0.0, 1.0).method_1029();
                double maxAngle = Math.toRadians(30.0);
                double randomAngle = (world.method_8409().method_43058() * 2.0 - 1.0) * maxAngle;
                double x = unitDirection.field_1352 * Math.cos(randomAngle) - unitDirection.field_1350 * Math.sin(randomAngle);
                double y = Math.abs(this.method_18798().method_10214());
                double z = unitDirection.field_1352 * Math.sin(randomAngle) + unitDirection.field_1350 * Math.cos(randomAngle);
                unitDirection = new class_243(x, y, z).method_1021(0.3);
                class_1297 class_12972 = this.getUser((class_1937)world);
                if (class_12972 instanceof class_1309) {
                    class_1309 attacker = (class_1309)class_12972;
                    potionEntity = new class_1686((class_1937)world, attacker);
                } else {
                    potionEntity = new class_1686((class_1937)world, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260());
                }
                potionEntity.method_16940(stack);
                potionEntity.method_18799(unitDirection.method_1021(this.method_18798().method_1033()));
                potionEntity.method_33574(this.method_19538());
                world.method_8649((class_1297)potionEntity);
            }
            if (canIgniteTnt) {
                for (int i = 0; i < tntBlocks.size(); ++i) {
                    class_1541 tntEntity;
                    class_243 unitDirection = this.method_18798().method_18805(1.0, 0.0, 1.0).method_1029();
                    double maxAngle = Math.toRadians(30.0);
                    double randomAngle = (world.method_8409().method_43058() * 2.0 - 1.0) * maxAngle;
                    double x = unitDirection.field_1352 * Math.cos(randomAngle) - unitDirection.field_1350 * Math.sin(randomAngle);
                    double y = Math.abs(this.method_18798().method_10214());
                    double z = unitDirection.field_1352 * Math.sin(randomAngle) + unitDirection.field_1350 * Math.cos(randomAngle);
                    unitDirection = new class_243(x, y, z).method_1021(0.3);
                    class_1297 class_12973 = this.getUser((class_1937)world);
                    if (class_12973 instanceof class_1309) {
                        class_1309 attacker = (class_1309)class_12973;
                        tntEntity = new class_1541((class_1937)world, this.method_23317(), this.method_23318(), this.method_23321(), attacker);
                    } else {
                        tntEntity = new class_1541(class_1299.field_6063, (class_1937)world);
                    }
                    tntEntity.method_18799(unitDirection.method_1021(this.method_18798().method_1033()));
                    tntEntity.method_33574(this.method_19538());
                    tntEntity.method_6967(80);
                    world.method_8649((class_1297)tntEntity);
                }
            }
            class_1264.method_17349((class_1937)world, (class_2338)pos.method_10084(), this.inventory);
        } else {
            if (world.method_8320(pos).method_26212((class_1922)world, pos)) {
                for (class_2338 next : class_2338.method_25996((class_2338)pos, (int)3, (int)3, (int)3)) {
                    if (next.method_10264() < pos.method_10264() || !NeMuelchBlocks.DROP_POT.method_9564().method_26184((class_4538)world, next)) continue;
                    pos = next;
                }
            }
            world.method_8501(pos, NeMuelchBlocks.DROP_POT.method_9564());
            class_2586 class_25862 = world.method_8321(pos);
            if (class_25862 instanceof DropPotBlockEntity) {
                DropPotBlockEntity blockEntity = (DropPotBlockEntity)class_25862;
                blockEntity.replaceContent(this.inventory);
            }
        }
        this.method_31472();
    }

    public void method_5837(class_3222 player) {
        super.method_5837(player);
        class_2540 buf = PacketByteBufs.create();
        buf.method_10812(SoundInstanceHelper.DROP_POT.getIdentifier());
        buf.method_10804(this.method_5628());
        ServerPlayNetworking.send((class_3222)player, (class_2960)NetworkIdentifiers.START_SOUND_INSTANCE_S2C, (class_2540)buf);
    }

    @Nullable
    public class_1297 getUser(class_1937 world) {
        class_3218 serverWorld;
        block3: {
            block2: {
                if (!(world instanceof class_3218)) break block2;
                serverWorld = (class_3218)world;
                if (this.userUuid != null) break block3;
            }
            return null;
        }
        return serverWorld.method_14190(this.userUuid);
    }

    public class_3419 method_5634() {
        return class_3419.field_15245;
    }

    public boolean method_30948() {
        return true;
    }

    public boolean method_30949(class_1297 other) {
        return super.method_30949(other);
    }

    protected void method_5749(class_2487 nbt) {
        class_2499 motion;
        super.method_5749(nbt);
        if (nbt.method_10545("userUuid")) {
            this.userUuid = nbt.method_25926("userUuid");
        }
        if (nbt.method_10573("motion", 9) && (motion = nbt.method_10554("motion", 6)).size() == 3) {
            class_243 motionVector = new class_243(motion.method_10611(0), motion.method_10611(1), motion.method_10611(2));
            this.method_18799(motionVector);
            this.field_6007 = true;
        }
        class_1262.method_5429((class_2487)nbt, this.inventory);
    }

    protected void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        if (this.userUuid != null) {
            nbt.method_25927("userUuid", this.userUuid);
        }
        class_2499 motion = new class_2499();
        motion.add((Object)class_2489.method_23241((double)this.method_18798().method_10216()));
        motion.add((Object)class_2489.method_23241((double)this.method_18798().method_10214()));
        motion.add((Object)class_2489.method_23241((double)this.method_18798().method_10215()));
        nbt.method_10566("motion", (class_2520)motion);
        class_1262.method_5426((class_2487)nbt, this.inventory);
    }
}

