/*
 * Decompiled with CFR 0.152.
 */
package net.shirojr.nemuelch.item.custom.adminToolItem;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_437;
import net.minecraft.class_7923;
import net.shirojr.nemuelch.item.util.ThirdPersonInvisible;
import org.jetbrains.annotations.Nullable;

public class SoundToolItem
extends class_1792
implements ThirdPersonInvisible {
    public static final String SOUND_NBT_KEY = "SelectedSound";
    public static final String VOLUME_NBT_KEY = "Volume";
    public static final String PITCH_NBT_KEY = "Pitch";
    public static final String POS_NBT_KEY = "Pos";
    public static final String TARGET_NBT_KEY = "Target";

    public SoundToolItem(class_1792.class_1793 settings) {
        super(settings);
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        super.method_7851(stack, world, tooltip, context);
        SoundToolItem.getSound(stack).ifPresent(soundEvent -> tooltip.add((class_2561)class_2561.method_43469((String)"item.nemuelch.sound_tool.tooltip.sound", (Object[])new Object[]{soundEvent.method_14833()})));
        SoundToolItem.getVolume(stack).ifPresent(volume -> tooltip.add((class_2561)class_2561.method_43469((String)"item.nemuelch.sound_tool.tooltip.volume", (Object[])new Object[]{volume})));
        SoundToolItem.getPitch(stack).ifPresent(pitch -> tooltip.add((class_2561)class_2561.method_43469((String)"item.nemuelch.sound_tool.tooltip.pitch", (Object[])new Object[]{pitch})));
        SoundToolItem.getPos(stack).ifPresent(pos -> {
            class_2338 blockPos = class_2338.method_49638((class_2374)pos);
            tooltip.add((class_2561)class_2561.method_43469((String)"item.nemuelch.sound_tool.tooltip.pos", (Object[])new Object[]{blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260()}));
        });
        SoundToolItem.getTargetUuid(stack).ifPresent(uuid -> tooltip.add((class_2561)class_2561.method_43469((String)"item.nemuelch.sound_tool.tooltip.target", (Object[])new Object[]{uuid})));
        SoundToolItem.getSound(stack).ifPresent(soundEvent -> tooltip.add((class_2561)class_2561.method_43473()));
        if (class_437.method_25442()) {
            tooltip.add((class_2561)class_2561.method_43471((String)"item.nemuelch.sound_tool.tooltip"));
        } else {
            tooltip.add((class_2561)class_2561.method_43471((String)"item.nemuelch.tooltip.expand.line2"));
        }
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 stack = user.method_5998(hand);
        if (SoundToolItem.playSoundOrNotify(world, user, hand)) {
            return class_1271.method_22427((Object)stack);
        }
        return class_1271.method_22431((Object)stack);
    }

    public static boolean playSoundOrNotify(class_1937 world, class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        class_3414 sound = SoundToolItem.getSound(stack).orElse(null);
        if (sound == null) {
            player.method_7353((class_2561)class_2561.method_43471((String)"item.nemuelch.sound_tool.error"), true);
            return false;
        }
        class_243 pos = SoundToolItem.getPos(stack).orElse(player.method_19538());
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            pos = SoundToolItem.getTarget(serverWorld, stack).map(class_1297::method_19538).orElse(pos);
            float volume = SoundToolItem.getVolume(stack).orElse(Float.valueOf(1.0f)).floatValue();
            float pitch = SoundToolItem.getPitch(stack).orElse(Float.valueOf(1.0f)).floatValue();
            world.method_43128(null, pos.method_10216(), pos.method_10214(), pos.method_10215(), sound, class_3419.field_15254, volume, pitch);
        }
        return true;
    }

    @Nullable
    public static class_3414 getSound(class_2960 identifier) {
        return (class_3414)class_7923.field_41172.method_10223(identifier);
    }

    public static Optional<class_3414> getSound(class_1799 stack) {
        class_2487 nbt = stack.method_7969();
        if (nbt == null || !nbt.method_10545(SOUND_NBT_KEY)) {
            return Optional.empty();
        }
        return Optional.ofNullable(SoundToolItem.getSound(class_2960.method_12829((String)nbt.method_10558(SOUND_NBT_KEY))));
    }

    public static void setSound(class_1799 stack, @Nullable class_3414 sound) {
        if (sound == null) {
            if (stack.method_7969() != null) {
                stack.method_7969().method_10551(SOUND_NBT_KEY);
            }
            return;
        }
        class_2960 identifier = class_7923.field_41172.method_10221((Object)sound);
        if (identifier == null) {
            return;
        }
        stack.method_7948().method_10582(SOUND_NBT_KEY, identifier.toString());
    }

    public static Optional<Float> getVolume(class_1799 stack) {
        class_2487 nbt = stack.method_7969();
        if (nbt == null || !nbt.method_10545(VOLUME_NBT_KEY)) {
            return Optional.empty();
        }
        return Optional.of(Float.valueOf(nbt.method_10583(VOLUME_NBT_KEY)));
    }

    public static void setVolume(class_1799 stack, @Nullable Float volume) {
        if (volume == null) {
            if (stack.method_7969() != null) {
                stack.method_7969().method_10551(VOLUME_NBT_KEY);
            }
            return;
        }
        stack.method_7948().method_10548(VOLUME_NBT_KEY, volume.floatValue());
    }

    public static Optional<Float> getPitch(class_1799 stack) {
        class_2487 nbt = stack.method_7969();
        if (nbt == null || !nbt.method_10545(PITCH_NBT_KEY)) {
            return Optional.empty();
        }
        return Optional.of(Float.valueOf(nbt.method_10583(PITCH_NBT_KEY)));
    }

    public static void setPitch(class_1799 stack, @Nullable Float pitch) {
        if (pitch == null) {
            if (stack.method_7969() != null) {
                stack.method_7969().method_10551(PITCH_NBT_KEY);
            }
            return;
        }
        stack.method_7948().method_10548(PITCH_NBT_KEY, pitch.floatValue());
    }

    public static Optional<class_243> getPos(class_1799 stack) {
        class_2487 nbt = stack.method_7969();
        if (nbt == null || !nbt.method_10545(POS_NBT_KEY)) {
            return Optional.empty();
        }
        class_2487 posNbt = nbt.method_10562(POS_NBT_KEY);
        class_243 pos = new class_243(posNbt.method_10574("x"), posNbt.method_10574("y"), posNbt.method_10574("z"));
        return Optional.of(pos);
    }

    public static void setPos(class_1799 stack, @Nullable class_243 pos) {
        if (pos == null) {
            if (stack.method_7969() != null) {
                stack.method_7969().method_10551(POS_NBT_KEY);
            }
            return;
        }
        class_2487 posNbt = new class_2487();
        posNbt.method_10549("x", pos.method_10216());
        posNbt.method_10549("y", pos.method_10214());
        posNbt.method_10549("z", pos.method_10215());
        stack.method_7948().method_10566(POS_NBT_KEY, (class_2520)posNbt);
    }

    public static Optional<UUID> getTargetUuid(class_1799 stack) {
        class_2487 nbt = stack.method_7969();
        if (nbt == null || !nbt.method_10545(TARGET_NBT_KEY)) {
            return Optional.empty();
        }
        return Optional.ofNullable(nbt.method_25926(TARGET_NBT_KEY));
    }

    public static Optional<class_1297> getTarget(class_3218 world, class_1799 stack) {
        return SoundToolItem.getTargetUuid(stack).map(arg_0 -> ((class_3218)world).method_14190(arg_0));
    }

    public static void setTarget(class_1799 stack, @Nullable class_1297 entity) {
        if (entity == null) {
            if (stack.method_7969() != null) {
                stack.method_7969().method_10551(TARGET_NBT_KEY);
            }
            return;
        }
        stack.method_7948().method_25927(TARGET_NBT_KEY, entity.method_5667());
    }
}

