/*
 * Decompiled with CFR 0.152.
 */
package net.shirojr.nemuelch.item.custom.supportItem;

import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1738;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_437;
import net.shirojr.nemuelch.init.NeMuelchTags;
import org.jetbrains.annotations.Nullable;

public class SoapItem
extends class_1792 {
    public static final String SOAPED_NBT_KEY = "soaped";
    private final int maxCoatingCharges;

    public SoapItem(class_1792.class_1793 settings, int maxCoatingCharges) {
        super(settings);
        this.maxCoatingCharges = maxCoatingCharges;
    }

    public int getMaxCoatingCharges() {
        return this.maxCoatingCharges;
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        super.method_7851(stack, world, tooltip, context);
        if (class_437.method_25442()) {
            tooltip.add((class_2561)class_2561.method_43471((String)"item.nemuelch.soap.tooltip"));
            if (SoapItem.hasInfiniteCoating(stack)) {
                tooltip.add((class_2561)class_2561.method_43471((String)"item.nemuelch.creative_soap.tooltip"));
            }
        } else {
            tooltip.add((class_2561)class_2561.method_43471((String)"item.nemuelch.tooltip.expand.line2"));
        }
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 soapStack = user.method_5998(class_1268.field_5808);
        class_1799 otherStack = user.method_5998(class_1268.field_5810);
        if (soapStack.method_7909().equals((Object)this) && SoapItem.canBeCoated(otherStack)) {
            if (this.getMaxCoatingCharges() == -1) {
                if (SoapItem.hasInfiniteCoating(otherStack)) {
                    return class_1271.method_22430((Object)soapStack);
                }
                SoapItem.applyInfiniteCoating(otherStack);
            } else {
                if (SoapItem.hasInfiniteCoating(otherStack) || SoapItem.getCoatingCharges(otherStack) == this.getMaxCoatingCharges()) {
                    return class_1271.method_22430((Object)soapStack);
                }
                SoapItem.setCoating(otherStack, this.getMaxCoatingCharges());
                if (!user.method_7337()) {
                    soapStack.method_7934(1);
                }
            }
            if (world instanceof class_3218) {
                class_3218 serverWorld = (class_3218)world;
                serverWorld.method_8396(null, user.method_24515(), class_3417.field_20615, class_3419.field_15254, 1.0f, 1.0f);
            }
            return class_1271.method_22427((Object)soapStack);
        }
        return super.method_7836(world, user, hand);
    }

    public static boolean canBeCoated(class_1799 stack) {
        return stack.method_7909() instanceof class_1738 || stack.method_31573(NeMuelchTags.Items.SOAP_COATABLE);
    }

    public static void setCoating(class_1799 stack, int charges) {
        class_2487 nbt = stack.method_7948();
        if (SoapItem.hasInfiniteCoating(stack) || !SoapItem.canBeCoated(stack)) {
            return;
        }
        if (charges == 0) {
            nbt.method_10551(SOAPED_NBT_KEY);
        } else {
            nbt.method_10569(SOAPED_NBT_KEY, Math.max(charges, 0));
        }
    }

    public static boolean hasCoating(class_1799 stack) {
        return stack.method_7969() != null && stack.method_7969().method_10545(SOAPED_NBT_KEY);
    }

    public static boolean hasCoating(class_1309 entity) {
        return SoapItem.getFirstCoatedStack(entity) != null;
    }

    public static int getCoatingCharges(class_1799 stack) {
        class_2487 nbt = stack.method_7969();
        if (nbt == null || !nbt.method_10545(SOAPED_NBT_KEY)) {
            return 0;
        }
        return nbt.method_10550(SOAPED_NBT_KEY);
    }

    @Nullable
    public static class_1799 getFirstCoatedStack(class_1309 entity) {
        for (class_1799 armorStack : entity.method_5661()) {
            if (!SoapItem.hasCoating(armorStack)) continue;
            return armorStack;
        }
        if (SoapItem.hasCoating(entity.method_6047())) {
            return entity.method_6047();
        }
        if (SoapItem.hasCoating(entity.method_6079())) {
            return entity.method_6079();
        }
        return null;
    }

    public static void decrementCoating(class_1799 stack) {
        class_2487 nbt = stack.method_7969();
        if (nbt == null || !nbt.method_10545(SOAPED_NBT_KEY)) {
            return;
        }
        if (SoapItem.hasInfiniteCoating(stack)) {
            return;
        }
        int currentCoat = nbt.method_10550(SOAPED_NBT_KEY);
        if (currentCoat <= 1) {
            stack.method_7969().method_10551(SOAPED_NBT_KEY);
        } else {
            stack.method_7969().method_10569(SOAPED_NBT_KEY, currentCoat - 1);
        }
    }

    public static void applyInfiniteCoating(class_1799 stack) {
        class_2487 nbt = stack.method_7948();
        nbt.method_10551(SOAPED_NBT_KEY);
        nbt.method_10569(SOAPED_NBT_KEY, -1);
    }

    public static boolean hasInfiniteCoating(class_1799 stack) {
        class_2487 nbt = stack.method_7969();
        if (nbt == null || !nbt.method_10545(SOAPED_NBT_KEY)) {
            return false;
        }
        return nbt.method_10550(SOAPED_NBT_KEY) == -1;
    }
}

