/*
 * Decompiled with CFR 0.152.
 */
package net.shirojr.nemuelch.mixin;

import com.google.common.collect.ImmutableMap;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.mojang.serialization.MapCodec;
import java.util.Set;
import net.minecraft.class_10;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2349;
import net.minecraft.class_2350;
import net.minecraft.class_2363;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2688;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3486;
import net.minecraft.class_3726;
import net.minecraft.class_3922;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5553;
import net.minecraft.class_5819;
import net.shirojr.nemuelch.compat.cca.component.BlightChunkComponent;
import net.shirojr.nemuelch.compat.statement.StatementCompat;
import net.shirojr.nemuelch.datapack.RandomTickSpeedChanceDatapack;
import net.shirojr.nemuelch.init.NeMuelchConfigInit;
import org.spongepowered.asm.mixin.Debug;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Debug(export=true)
@Mixin(value={class_4970.class_4971.class})
public abstract class AbstractBlockStateMixin
extends class_2688<class_2248, class_2680> {
    private AbstractBlockStateMixin(class_2248 owner, ImmutableMap<class_2769<?>, Comparable<?>> entries, MapCodec<class_2680> codec) {
        super((Object)owner, entries, codec);
    }

    @Shadow
    protected abstract class_2680 method_26233();

    @Inject(method={"scheduledTick"}, at={@At(value="HEAD")})
    private void scheduleSandPathTick(class_3218 world, class_2338 pos, class_5819 random, CallbackInfo ci) {
        class_2680 state = world.method_8320(pos);
        if (!state.method_27852(class_2246.field_10102)) {
            return;
        }
        if (StatementCompat.isNotPath((class_4970.class_4971)state)) {
            return;
        }
        if (world.method_8320(pos.method_10084()).method_26215()) {
            return;
        }
        StatementCompat.setToSand(null, state, (class_1937)world, pos);
    }

    @ModifyExpressionValue(method={"<init>"}, at={@At(value="INVOKE", target="Lnet/minecraft/block/Block;hasSidedTransparency(Lnet/minecraft/block/BlockState;)Z")})
    private boolean setSandPathSidedTransparency(boolean original) {
        class_2680 state = this.method_26233();
        if (!state.method_27852(class_2246.field_10102)) {
            return original;
        }
        if (StatementCompat.isNotPath((class_4970.class_4971)state)) {
            return original;
        }
        return true;
    }

    @Inject(method={"getOutlineShape(Lnet/minecraft/world/BlockView;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/ShapeContext;)Lnet/minecraft/util/shape/VoxelShape;"}, at={@At(value="HEAD")}, cancellable=true)
    private void getSandPathOutlineShape(class_1922 world, class_2338 pos, class_3726 context, CallbackInfoReturnable<class_265> cir) {
        class_2680 state = this.method_26233();
        if (!state.method_27852(class_2246.field_10102)) {
            return;
        }
        if (StatementCompat.isNotPath((class_4970.class_4971)state)) {
            return;
        }
        cir.setReturnValue((Object)StatementCompat.getPathShape());
    }

    @Inject(method={"getCullingShape"}, at={@At(value="HEAD")}, cancellable=true)
    private void getSandPathCullingShape(class_1922 world, class_2338 pos, CallbackInfoReturnable<class_265> cir) {
        class_2680 state = this.method_26233();
        if (StatementCompat.isNotPath((class_4970.class_4971)state)) {
            return;
        }
        cir.setReturnValue((Object)StatementCompat.getPathShape());
    }

    @Inject(method={"getStateForNeighborUpdate"}, at={@At(value="HEAD")})
    private void getSandPathStateForNeighborUpdate(class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos, CallbackInfoReturnable<class_2680> cir) {
        class_2680 state = this.method_26233();
        if (!state.method_27852(class_2246.field_10102)) {
            return;
        }
        if (StatementCompat.isNotPath((class_4970.class_4971)state)) {
            return;
        }
        if (direction == class_2350.field_11036 && !state.method_26184((class_4538)world, pos)) {
            world.method_39279(pos, state.method_26204(), 1);
        }
    }

    @Inject(method={"canPlaceAt"}, at={@At(value="HEAD")}, cancellable=true)
    private void canPlaceSandPathAt(class_4538 world, class_2338 pos, CallbackInfoReturnable<Boolean> cir) {
        class_2680 state = this.method_26233();
        if (!state.method_27852(class_2246.field_10102)) {
            return;
        }
        if (StatementCompat.isNotPath((class_4970.class_4971)state)) {
            return;
        }
        class_2680 stateAbove = world.method_8320(pos.method_10084());
        cir.setReturnValue((Object)(!stateAbove.method_51367() || stateAbove.method_26204() instanceof class_2349 ? 1 : 0));
    }

    @Inject(method={"canPathfindThrough"}, at={@At(value="HEAD")}, cancellable=true)
    private void canPathFindThroughSandPath(class_1922 world, class_2338 pos, class_10 type, CallbackInfoReturnable<Boolean> cir) {
        class_2680 state = this.method_26233();
        if (!state.method_27852(class_2246.field_10102)) {
            return;
        }
        if (StatementCompat.isNotPath((class_4970.class_4971)state)) {
            return;
        }
        cir.setReturnValue((Object)false);
    }

    @Inject(method={"randomTick"}, at={@At(value="HEAD")}, cancellable=true)
    private void randomTickWithDatapackChance(class_3218 world, class_2338 pos, class_5819 random, CallbackInfo ci) {
        if (!NeMuelchConfigInit.CONFIG.enableRandomTickChanceLimitFeature) {
            return;
        }
        Float chance = RandomTickSpeedChanceDatapack.BLOCK_CHANCES.get(this.method_26233().method_26204());
        if (chance == null || chance.floatValue() >= 1.0f) {
            return;
        }
        if (chance.floatValue() >= 0.0f && chance.floatValue() > world.method_8409().method_43057()) {
            return;
        }
        ci.cancel();
    }

    @Inject(method={"onBlockAdded"}, at={@At(value="HEAD")})
    private void cleanseBlight(class_1937 world, class_2338 pos, class_2680 state, boolean notify, CallbackInfo ci) {
        if (BlightChunkComponent.NO_BLIGHT.test(state)) {
            return;
        }
        boolean stateCanCleanse = false;
        if (state.method_28498((class_2769)class_2741.field_12548) && ((Boolean)state.method_11654((class_2769)class_2741.field_12548)).booleanValue()) {
            if (state.method_26204() instanceof class_3922) {
                stateCanCleanse = true;
            }
            if (state.method_26204() instanceof class_2363) {
                stateCanCleanse = true;
            }
        }
        if (state.method_26204() instanceof class_5553 || state.method_26227().method_15767(class_3486.field_15518)) {
            stateCanCleanse = true;
        }
        if (!stateCanCleanse) {
            return;
        }
        BlightChunkComponent.maybeGet(world.method_22350(pos)).ifPresent(component -> {
            component.clearPos(pos, Set.of());
            for (class_2350 value : class_2350.values()) {
                component.clearPos(pos.method_10093(value), Set.of());
            }
        });
    }

    @Inject(method={"onStateReplaced"}, at={@At(value="HEAD")})
    private void onStateReplacedForBlight(class_1937 world, class_2338 pos, class_2680 state, boolean moved, CallbackInfo ci) {
        if (!(world instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)world;
        BlightChunkComponent.maybeGet(world.method_22350(pos)).ifPresent(component -> {
            serverWorld.method_16107().method_15396("nemuelch_on_stepped_on_blight");
            component.getBlightsOfPos(pos).forEach(type -> type.getActions().get().onBlockStateChanged(serverWorld, component.getTimeOfFirstInitializedBlight(), pos, this.method_26233(), state));
            serverWorld.method_16107().method_15407();
        });
    }

    @Inject(method={"onEntityCollision"}, at={@At(value="HEAD")})
    private void onEntityCollidingWithBlight(class_1937 world, class_2338 pos, class_1297 entity, CallbackInfo ci) {
        if (!(world instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)world;
        BlightChunkComponent.maybeGet(serverWorld.method_22350(pos)).ifPresent(component -> {
            serverWorld.method_16107().method_15396("nemuelch_on_entity_collision_with_blight");
            component.getBlightsOfPos(pos).forEach(type -> type.getActions().get().onBlockCollision(serverWorld, component.getTimeOfFirstInitializedBlight(), pos, entity));
            serverWorld.method_16107().method_15407();
        });
    }
}

