/*
 * Decompiled with CFR 0.152.
 */
package net.shirojr.nemuelch.network;

import java.util.Optional;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.server.MinecraftServer;
import net.shirojr.nemuelch.compat.cca.component.GeneralMonsterComponent;
import net.shirojr.nemuelch.entity.custom.PotLauncherEntity;
import net.shirojr.nemuelch.init.NeMuelchConfigInit;
import net.shirojr.nemuelch.init.NeMuelchSounds;
import net.shirojr.nemuelch.init.NeMuelchTags;
import net.shirojr.nemuelch.monster.AbstractMonsterType;
import net.shirojr.nemuelch.network.util.NetworkIdentifiers;
import org.jetbrains.annotations.Nullable;

public class NeMuelchC2SNetworking {
    private static void handleMonsterAbilityKey(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 buf, PacketSender responseSender) {
        int key = buf.method_10816();
        server.execute(() -> {
            GeneralMonsterComponent monsterComponent = GeneralMonsterComponent.get((class_1309)player);
            for (AbstractMonsterType entry : monsterComponent.getActiveMonsterTypes()) {
                entry.getAbilities().onKeybindPressed(player, key);
            }
        });
    }

    private static void handleMouseScrolledPacket(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 buf, PacketSender sender) {
        int id = buf.method_10816();
        double delta = buf.readDouble();
        Optional<PotLauncherEntity.InteractionHitBox> selectedBox = PotLauncherEntity.InteractionHitBox.byName(buf.method_19772());
        server.execute(() -> {
            class_1297 patt0$temp = player.method_37908().method_8469(id);
            if (!(patt0$temp instanceof PotLauncherEntity)) {
                return;
            }
            PotLauncherEntity entity = (PotLauncherEntity)patt0$temp;
            if (selectedBox.isEmpty()) {
                return;
            }
            if (!((PotLauncherEntity.InteractionHitBox)((Object)((Object)selectedBox.get()))).isScrollable()) {
                return;
            }
            ((PotLauncherEntity.InteractionHitBox)((Object)((Object)selectedBox.get()))).onHit(entity, delta, 5.0f);
        });
    }

    private static void handleKnockingSoundBroadcastPacket(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 buf, PacketSender sender) {
        class_2338 hitPos = buf.method_10811();
        server.execute(() -> {
            float pitch;
            if (!NeMuelchConfigInit.CONFIG.allowKnocking) {
                player.method_7353((class_2561)class_2561.method_43471((String)"chat.nemuelch.feature_not_enabled"), false);
                return;
            }
            class_3218 world = player.method_51469();
            class_2680 hitState = world.method_8320(hitPos);
            if (!hitState.method_26164(NeMuelchTags.Blocks.KNOCK_SOUND_BLOCKS)) {
                return;
            }
            float minPitch = 0.85f;
            float maxPitch = 1.2f;
            class_2586 patt0$temp = world.method_8321(hitPos);
            if (patt0$temp instanceof class_1263) {
                class_1263 inventory = (class_1263)patt0$temp;
                int occupiedSlots = 0;
                for (int i = 0; i < inventory.method_5439(); ++i) {
                    if (inventory.method_5438(i).method_7960()) continue;
                    ++occupiedSlots;
                }
                pitch = class_3532.method_16439((float)((float)occupiedSlots / (float)inventory.method_5439()), (float)minPitch, (float)maxPitch);
            } else {
                double sqDistanceToBlock = player.method_5707(hitPos.method_46558());
                float normalizedDistance = (float)class_3532.method_15350((double)(sqDistanceToBlock / (double)(NeMuelchConfigInit.CONFIG.knockableBlockRange * NeMuelchConfigInit.CONFIG.knockableBlockRange)), (double)0.0, (double)1.0);
                pitch = (float)class_3532.method_16436((double)Math.pow(normalizedDistance, 2.0), (double)minPitch, (double)maxPitch);
            }
            world.method_8396(null, hitPos, NeMuelchSounds.KNOCKING_01, class_3419.field_15245, NeMuelchConfigInit.CONFIG.knockingVolume, pitch);
        });
    }

    @Nullable
    private static class_2338 getValidBlockPosInRange(class_2338 packetBlockPos, class_1937 world, class_1657 player) {
        class_2338 hitBlockPos = null;
        if (packetBlockPos != null) {
            return packetBlockPos;
        }
        Iterable blockIterable = class_2338.method_25996((class_2338)player.method_24515(), (int)NeMuelchConfigInit.CONFIG.knockableBlockRange, (int)NeMuelchConfigInit.CONFIG.knockableBlockRange, (int)NeMuelchConfigInit.CONFIG.knockableBlockRange);
        for (class_2338 entry : blockIterable) {
            if (!world.method_8320(entry).method_26164(NeMuelchTags.Blocks.KNOCK_SOUND_BLOCKS)) continue;
            hitBlockPos = entry;
            break;
        }
        return hitBlockPos;
    }

    public static void initialize() {
    }

    static {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)NetworkIdentifiers.KNOCKING_RAYCASTED_SOUND_C2S, NeMuelchC2SNetworking::handleKnockingSoundBroadcastPacket);
        ServerPlayNetworking.registerGlobalReceiver((class_2960)NetworkIdentifiers.MOUSE_SCROLLED_C2S, NeMuelchC2SNetworking::handleMouseScrolledPacket);
        ServerPlayNetworking.registerGlobalReceiver((class_2960)NetworkIdentifiers.MONSTER_ABILITY_KEY, NeMuelchC2SNetworking::handleMonsterAbilityKey);
    }
}

