/*
 * Decompiled with CFR 0.152.
 */
package net.shirojr.nemuelch.network;

import java.util.UUID;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_1113;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_634;
import net.minecraft.class_638;
import net.minecraft.class_7923;
import net.shirojr.nemuelch.NeMuelchClient;
import net.shirojr.nemuelch.block.custom.RottenMeatBlock;
import net.shirojr.nemuelch.camera.DisplacementSequence;
import net.shirojr.nemuelch.compat.satin.NeMuelchShaders;
import net.shirojr.nemuelch.entity.custom.PotLauncherEntity;
import net.shirojr.nemuelch.item.util.ThirdPersonInvisible;
import net.shirojr.nemuelch.network.packet.EntitySpawnPacket;
import net.shirojr.nemuelch.network.util.NetworkIdentifiers;
import net.shirojr.nemuelch.network.util.NetworkUtil;
import net.shirojr.nemuelch.render.TalismanChargeRenderer;
import net.shirojr.nemuelch.sound.SoundInstanceHandler;
import net.shirojr.nemuelch.sound.instance.OminousHeartSoundInstance;
import net.shirojr.nemuelch.util.ParticlePacketType;
import net.shirojr.nemuelch.util.logger.LoggerUtil;

public class NemuelchS2CNetworking {
    private static void handleCameraDisplacementSequenceStopAll(class_310 client, class_634 handler, class_2540 buf, PacketSender sender) {
        client.execute(() -> NeMuelchClient.CAMERA_SHAKE_HANDLER.setActiveDisplacementSequence(null));
    }

    private static void handleCameraDisplacementSequenceStop(class_310 client, class_634 handler, class_2540 buf, PacketSender sender) {
        class_2960 identifier = buf.method_10810();
        client.execute(() -> {
            if (client.field_1687 == null) {
                return;
            }
            DisplacementSequence sequence = DisplacementSequence.fromRegistry(identifier, client.field_1687.method_8428());
            NeMuelchClient.CAMERA_SHAKE_HANDLER.setActiveDisplacementSequence(null);
        });
    }

    private static void handleCameraDisplacementSequenceStart(class_310 client, class_634 handler, class_2540 buf, PacketSender sender) {
        class_2960 identifier = buf.method_10810();
        client.execute(() -> {
            if (client.field_1687 == null) {
                return;
            }
            DisplacementSequence sequence = DisplacementSequence.fromRegistry(identifier, client.field_1687.method_8428());
            NeMuelchClient.CAMERA_SHAKE_HANDLER.setActiveDisplacementSequence(sequence);
        });
    }

    private static void handleConstantFade(class_310 client, class_634 handler, class_2540 buf, PacketSender sender) {
        float fadeValue = buf.readFloat();
        client.execute(() -> NeMuelchShaders.FADE.setStaticFadeAmount(fadeValue));
    }

    private static void handleFadeFromBlack(class_310 client, class_634 handler, class_2540 buf, PacketSender sender) {
        int duration = buf.method_10816();
        client.execute(() -> NeMuelchShaders.FADE.fadeFromBlack(duration));
    }

    private static void handleFadeToBlack(class_310 client, class_634 handler, class_2540 buf, PacketSender sender) {
        int duration = buf.method_10816();
        client.execute(() -> NeMuelchShaders.FADE.fadeToBlack(duration));
    }

    private static void cacheItemRenderingGamerule(class_310 client, class_634 handler, class_2540 buf, PacketSender sender) {
        boolean gameruleValue = buf.readBoolean();
        client.execute(() -> ThirdPersonInvisible.GameruleCache.INSTANCE.set(gameruleValue));
    }

    private static void spawnRottenParticles(class_310 client, class_634 handler, class_2540 buf, PacketSender sender) {
        int amount = buf.method_10816();
        int range = buf.method_10816();
        class_2338 blockPos = class_2338.method_10092((long)buf.readLong());
        client.execute(() -> {
            class_638 world = handler.method_2890();
            RottenMeatBlock.spawnClientParticles(amount, range, blockPos, (class_1937)world, world.method_8409());
        });
    }

    private static void handleTalismanChargeData(class_310 client, class_634 handler, class_2540 buf, PacketSender sender) {
        class_243 userPos = NetworkUtil.readVec3d(buf);
        int projectileId = buf.method_10816();
        class_1799 stack = buf.method_10819();
        client.execute(() -> {
            class_1297 patt0$temp;
            class_638 world = client.field_1687;
            if (world == null || !((patt0$temp = world.method_8469(projectileId)) instanceof class_1676)) {
                return;
            }
            class_1676 projectile = (class_1676)patt0$temp;
            TalismanChargeRenderer renderer = TalismanChargeRenderer.getInstance();
            if (renderer.inProgress(projectile)) {
                return;
            }
            renderer.getRenderData().add(new TalismanChargeRenderer.Data(projectile, userPos, stack));
        });
    }

    private static void activatePotLauncher(class_310 client, class_634 handler, class_2540 buf, PacketSender sender) {
        class_1297 entity = handler.method_2890().method_8469(buf.method_10816());
        boolean active = buf.readBoolean();
        client.execute(() -> {
            if (!(entity instanceof PotLauncherEntity)) {
                return;
            }
            PotLauncherEntity potLauncher = (PotLauncherEntity)entity;
            potLauncher.setActive(active);
        });
    }

    private static void handleEntitySpawnPacket(class_310 client, class_634 handler, class_2540 buf, PacketSender sender) {
        class_1299 entityType = (class_1299)class_7923.field_41177.method_10200(buf.method_10816());
        UUID uuid = buf.method_10790();
        int entityId = buf.method_10816();
        class_243 pos = EntitySpawnPacket.PacketBufUtil.readVec3d(buf);
        client.execute(() -> {
            if (class_310.method_1551().field_1687 == null) {
                throw new IllegalStateException("Tried to spawn entity in a null world!");
            }
            class_1297 e = entityType.method_5883((class_1937)class_310.method_1551().field_1687);
            if (e == null) {
                throw new IllegalStateException("Failed to create instance of entity \"" + String.valueOf(class_7923.field_41177.method_10221((Object)entityType)) + "\"!");
            }
            e.method_43391(pos.field_1352, pos.field_1351, pos.field_1350);
            e.method_23327(pos.field_1352, pos.field_1351, pos.field_1350);
            e.method_5838(entityId);
            e.method_5826(uuid);
            class_310.method_1551().field_1687.method_2942(entityId, e);
        });
    }

    private static void handleParticleSpawnPacket(class_310 client, class_634 handler, class_2540 buf, PacketSender sender) {
        class_2338 pos = buf.method_10811();
        ParticlePacketType particleSetting = (ParticlePacketType)buf.method_10818(ParticlePacketType.class);
        client.execute(() -> {
            if (client.field_1687 == null) {
                return;
            }
            switch (particleSetting) {
                case EFFECT_PLAYTHING_OF_THE_UNSEEN_DEITY: {
                    class_310.method_1551().field_1713.method_3056((class_2394)class_2398.field_11251, (double)pos.method_10263(), (double)pos.method_10264() + 1.0, (double)pos.method_10260(), 0.0, 0.0, 0.0);
                    class_310.method_1551().field_1713.method_3056((class_2394)class_2398.field_11215, (double)pos.method_10263(), (double)pos.method_10264() + 1.0, (double)pos.method_10260(), 0.0, 0.0, 0.0);
                    break;
                }
                case ITEM_CALLOFAGONY_KNOCKBACK: {
                    for (int i = 0; i < 10; ++i) {
                        double x = client.field_1687.method_8409().method_43059() * 2.0 * (double)pos.method_10263();
                        double y = client.field_1687.method_8409().method_43059() * 2.0 * ((double)pos.method_10264() + 1.0);
                        double z = client.field_1687.method_8409().method_43059() * 2.0 * (double)pos.method_10260();
                        class_310.method_1551().field_1713.method_3056((class_2394)class_2398.field_11215, x, y, z, 0.0, 0.0, 0.0);
                    }
                    break;
                }
            }
        });
    }

    private static void handleSoundPacket(class_310 client, class_634 handler, class_2540 buf, PacketSender sender) {
        class_2338 target = buf.method_10811();
        client.execute(() -> {
            if (class_310.method_1551().field_1687 != null && class_310.method_1551().field_1724 != null) {
                client.method_1483().method_4873((class_1113)new OminousHeartSoundInstance((class_1657)client.field_1724));
            }
        });
    }

    private static void handleWateringCanParticlePacket(class_310 client, class_634 clientPlayNetworkHandler, class_2540 buf, PacketSender packetSender) {
        class_2338 target = buf.method_10811();
        client.execute(() -> LoggerUtil.devLogger("S2C network packet received"));
    }

    private static void handleCancelSleepEventPacket(class_310 client, class_634 clientPlayNetworkHandler, class_2540 clientBuf, PacketSender packetSender) {
        client.execute(NeMuelchClient.CLIENT_COUNTDOWN_HANDLER::stopAndResetTicking);
    }

    private static void handleSoundInstancePacket(class_310 client, class_634 clientPlayNetworkHandler, class_2540 clientBuf, PacketSender packetSender) {
        class_2960 instanceIdentifier = clientBuf.method_10810();
        int entityId = clientBuf.method_10816();
        client.execute(() -> SoundInstanceHandler.handleSoundInstancePackets(client, instanceIdentifier, entityId));
    }

    public static void initialize() {
    }

    static {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)NetworkIdentifiers.WATERING_CAN_PARTICLE_S2C, NemuelchS2CNetworking::handleWateringCanParticlePacket);
        ClientPlayNetworking.registerGlobalReceiver((class_2960)NetworkIdentifiers.CANCEL_SLEEP_EVENT_S2C, NemuelchS2CNetworking::handleCancelSleepEventPacket);
        ClientPlayNetworking.registerGlobalReceiver((class_2960)NetworkIdentifiers.START_SOUND_INSTANCE_S2C, NemuelchS2CNetworking::handleSoundInstancePacket);
        ClientPlayNetworking.registerGlobalReceiver((class_2960)NetworkIdentifiers.ENTITY_SPAWN_PACKET, NemuelchS2CNetworking::handleEntitySpawnPacket);
        ClientPlayNetworking.registerGlobalReceiver((class_2960)NetworkIdentifiers.PLAY_PARTICLE_S2C, NemuelchS2CNetworking::handleParticleSpawnPacket);
        ClientPlayNetworking.registerGlobalReceiver((class_2960)NetworkIdentifiers.SOUND_PACKET_S2C, NemuelchS2CNetworking::handleSoundPacket);
        ClientPlayNetworking.registerGlobalReceiver((class_2960)NetworkIdentifiers.POT_LAUNCHER_ACTIVATED, NemuelchS2CNetworking::activatePotLauncher);
        ClientPlayNetworking.registerGlobalReceiver((class_2960)NetworkIdentifiers.TALISMAN_DISCARD_PROJECTILE, NemuelchS2CNetworking::handleTalismanChargeData);
        ClientPlayNetworking.registerGlobalReceiver((class_2960)NetworkIdentifiers.SPAWN_ROTTEN_PARTICLE, NemuelchS2CNetworking::spawnRottenParticles);
        ClientPlayNetworking.registerGlobalReceiver((class_2960)NetworkIdentifiers.THIRD_PERSON_ITEM_RENDERING, NemuelchS2CNetworking::cacheItemRenderingGamerule);
        ClientPlayNetworking.registerGlobalReceiver((class_2960)NetworkIdentifiers.FADE_TO_BLACK_PACKET, NemuelchS2CNetworking::handleFadeToBlack);
        ClientPlayNetworking.registerGlobalReceiver((class_2960)NetworkIdentifiers.FADE_FROM_BLACK_PACKET, NemuelchS2CNetworking::handleFadeFromBlack);
        ClientPlayNetworking.registerGlobalReceiver((class_2960)NetworkIdentifiers.FADE_STATIC_PACKET, NemuelchS2CNetworking::handleConstantFade);
        ClientPlayNetworking.registerGlobalReceiver((class_2960)NetworkIdentifiers.CAMERA_DISPLACEMENT_SEQUENCE_START_PACKET, NemuelchS2CNetworking::handleCameraDisplacementSequenceStart);
        ClientPlayNetworking.registerGlobalReceiver((class_2960)NetworkIdentifiers.CAMERA_DISPLACEMENT_SEQUENCE_STOP_PACKET, NemuelchS2CNetworking::handleCameraDisplacementSequenceStop);
        ClientPlayNetworking.registerGlobalReceiver((class_2960)NetworkIdentifiers.CAMERA_DISPLACEMENT_SEQUENCE_STOP_ALL_PACKET, NemuelchS2CNetworking::handleCameraDisplacementSequenceStopAll);
    }
}

