/*
 * Decompiled with CFR 0.152.
 */
package net.shirojr.nemuelch.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1293;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1803;
import net.minecraft.class_1812;
import net.minecraft.class_1828;
import net.minecraft.class_1844;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3956;
import net.minecraft.class_5455;
import net.shirojr.nemuelch.compat.cca.util.BlightIngredients;
import net.shirojr.nemuelch.compat.cca.util.BlightType;
import net.shirojr.nemuelch.recipe.AbstractHandCraftingRecipe;
import net.shirojr.nemuelch.util.HandInventory;

public class BlightHandMixingRecipe
extends AbstractHandCraftingRecipe {
    private final class_1856 base;
    private final class_1856 poison;
    private final Predicate<class_1799> isBlighted = stack -> {
        List potionEffects = class_1844.method_8067((class_1799)stack);
        for (class_1293 entry : potionEffects) {
            for (BlightType blightType : BlightType.CACHED_VALUES) {
                BlightIngredients ingredients = blightType.getIngredients();
                if (ingredients == null || ingredients.effect() == null || !ingredients.effect().equals(entry.method_5579())) continue;
                return true;
            }
        }
        return false;
    };

    public BlightHandMixingRecipe(class_2960 id, class_1856 base, class_1856 poison) {
        super(id);
        this.base = base;
        this.poison = poison;
    }

    @Override
    public boolean matches(HandInventory inventory, class_1937 world) {
        if (!inventory.isFull()) {
            return false;
        }
        class_1799 mainHandStack = inventory.getMainHandStack();
        class_1799 offHandStack = inventory.getOffHandStack();
        return this.base.method_8093(mainHandStack) && this.poison.method_8093(offHandStack) && this.isBlighted.test(offHandStack) || this.poison.method_8093(mainHandStack) && this.base.method_8093(offHandStack) && this.isBlighted.test(mainHandStack);
    }

    @Override
    public class_1799 craft(HandInventory inventory, class_5455 registryManager) {
        class_1799 mainHandStack = inventory.getMainHandStack();
        class_1799 offHandStack = inventory.getOffHandStack();
        class_1799 baseStack = null;
        class_1799 modifierStack = null;
        if (this.base.method_8093(mainHandStack) && this.poison.method_8093(offHandStack) && this.isBlighted.test(offHandStack)) {
            baseStack = mainHandStack;
            modifierStack = offHandStack;
        } else if (this.base.method_8093(offHandStack) && this.poison.method_8093(mainHandStack) && this.isBlighted.test(mainHandStack)) {
            baseStack = offHandStack;
            modifierStack = mainHandStack;
        }
        if (baseStack == null) {
            return class_1799.field_8037;
        }
        class_1799 result = baseStack.method_7972();
        result.method_7939(1);
        BlightHandMixingRecipe.addResultNbt(modifierStack, result);
        return result;
    }

    private static void addResultNbt(class_1799 modifier, class_1799 result) {
        EnumSet<BlightType> types = EnumSet.noneOf(BlightType.class);
        for (class_1293 potionEffect : class_1844.method_8067((class_1799)modifier)) {
            for (BlightType entry : BlightType.CACHED_VALUES) {
                BlightIngredients ingredients = entry.getIngredients();
                if (ingredients == null || ingredients.effect() == null || !ingredients.effect().equals(potionEffect.method_5579())) continue;
                types.add(entry);
            }
        }
        BlightType.applyToStack(result, types);
    }

    @Override
    public class_1799 method_8110(class_5455 registryManager) {
        return null;
    }

    public class_2371<class_1799> getRemainder(HandInventory inventory) {
        class_2371 remainder = class_2371.method_10213((int)inventory.method_5439(), (Object)class_1799.field_8037);
        for (int i = 0; i < inventory.getStacks().size(); ++i) {
            class_1799 itemStack = inventory.getStacks().get(i);
            if (!itemStack.getRecipeRemainder().method_7960()) {
                remainder.set(i, (Object)itemStack.getRecipeRemainder());
                continue;
            }
            if (itemStack.method_7909() instanceof class_1812) {
                remainder.set(i, (Object)new class_1799((class_1935)class_1802.field_8469));
                continue;
            }
            if (itemStack.method_7909() instanceof class_1828) {
                remainder.set(i, (Object)new class_1799((class_1935)class_1802.field_8469));
                continue;
            }
            if (!(itemStack.method_7909() instanceof class_1803)) continue;
            remainder.set(i, (Object)new class_1799((class_1935)class_1802.field_8469));
        }
        return remainder;
    }

    @Override
    public class_1865<?> method_8119() {
        return Serializer.INSTANCE;
    }

    @Override
    public class_3956<?> method_17716() {
        return Type.INSTANCE;
    }

    public static class Serializer
    implements class_1865<BlightHandMixingRecipe> {
        public static final Serializer INSTANCE = new Serializer();

        public BlightHandMixingRecipe read(class_2960 id, JsonObject json) {
            class_1856 base = class_1856.method_52177((JsonElement)class_3518.method_15296((JsonObject)json, (String)"base"));
            class_1856 poison = class_1856.method_52177((JsonElement)class_3518.method_15296((JsonObject)json, (String)"blight"));
            return new BlightHandMixingRecipe(id, base, poison);
        }

        public BlightHandMixingRecipe read(class_2960 id, class_2540 buf) {
            class_1856 base = class_1856.method_8086((class_2540)buf);
            class_1856 poison = class_1856.method_8086((class_2540)buf);
            return new BlightHandMixingRecipe(id, base, poison);
        }

        public void write(class_2540 buf, BlightHandMixingRecipe recipe) {
            recipe.base.method_8088(buf);
            recipe.poison.method_8088(buf);
        }
    }

    public static class Type
    implements class_3956<BlightHandMixingRecipe> {
        public static final Type INSTANCE = new Type();

        private Type() {
        }
    }
}

