/*
 * Decompiled with CFR 0.152.
 */
package net.shirojr.nemuelch.recipe;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1869;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_5455;
import net.minecraft.class_7710;
import net.minecraft.class_8566;
import net.shirojr.nemuelch.item.custom.supportItem.BookWrapperItem;
import net.shirojr.nemuelch.mixin.access.ShapedRecipeAccess;

public class BookWrapperRecipe
extends class_1869 {
    private final BookWrapperItem.Part part;

    public BookWrapperRecipe(class_2960 id, BookWrapperItem.Part part, int width, int height, class_2371<class_1856> input, class_1799 output) {
        super(id, "", class_7710.field_40251, width, height, input, output);
        this.part = part;
    }

    public BookWrapperItem.Part getPart() {
        return this.part;
    }

    public boolean method_17728(class_8566 inventory, class_1937 world) {
        class_1799 baseStack = class_1799.field_8037;
        for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1799 inventoryStack = inventory.method_5438(i);
            if (inventoryStack.method_7960() || !(inventoryStack.method_7909() instanceof BookWrapperItem)) continue;
            if (!baseStack.method_7960()) {
                return false;
            }
            baseStack = inventoryStack;
        }
        for (int x = 0; x <= inventory.method_17398() - this.method_8150(); ++x) {
            for (int y = 0; y <= inventory.method_17397() - this.method_8158(); ++y) {
                if (this.matchesPattern(inventory, x, y, true)) {
                    return true;
                }
                if (!this.matchesPattern(inventory, x, y, false)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean matchesPattern(class_8566 inv, int offsetX, int offsetY, boolean flipped) {
        for (int x = 0; x < inv.method_17398(); ++x) {
            for (int y = 0; y < inv.method_17397(); ++y) {
                int entryX = x - offsetX;
                int entryY = y - offsetY;
                class_1856 ingredient = class_1856.field_9017;
                if (entryX >= 0 && entryY >= 0 && entryX < this.method_8150() && entryY < this.method_8158()) {
                    ingredient = flipped ? (class_1856)this.method_8117().get(this.method_8150() - entryX - 1 + entryY * this.method_8150()) : (class_1856)this.method_8117().get(entryX + entryY * this.method_8150());
                }
                class_1799 stack = inv.method_5438(x + y * inv.method_17398());
                if (ingredient.method_8103() && stack.method_7909() instanceof class_1769 || ingredient.method_8093(stack)) continue;
                return false;
            }
        }
        return true;
    }

    public class_1799 method_17727(class_8566 inventory, class_5455 dynamicRegistryManager) {
        class_1799 bookWrapperStack = class_1799.field_8037;
        ArrayList<class_1769> dyeItems = new ArrayList<class_1769>();
        for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1799 inventoryStack = inventory.method_5438(i);
            if (inventoryStack.method_7960()) continue;
            if (inventoryStack.method_7909() instanceof BookWrapperItem) {
                if (!bookWrapperStack.method_7960()) {
                    return class_1799.field_8037;
                }
                bookWrapperStack = inventoryStack.method_7972();
                continue;
            }
            class_1792 class_17922 = inventoryStack.method_7909();
            if (!(class_17922 instanceof class_1769)) continue;
            class_1769 item = (class_1769)class_17922;
            dyeItems.add(item);
        }
        class_1799 result = this.method_8110(dynamicRegistryManager).method_7972();
        if (!bookWrapperStack.method_7960() && result.method_7909().equals(bookWrapperStack.method_7909())) {
            result = bookWrapperStack.method_46651(1);
        }
        this.getPart().setColor(result, this.getPart().getBlendedColor(result, dyeItems));
        return result;
    }

    public class_1865<?> method_8119() {
        return Serializer.INSTANCE;
    }

    public static class Serializer
    implements class_1865<BookWrapperRecipe> {
        public static final Serializer INSTANCE = new Serializer();

        public BookWrapperRecipe read(class_2960 id, JsonObject json) {
            BookWrapperItem.Part part = BookWrapperItem.Part.fromString(class_3518.method_15265((JsonObject)json, (String)"part"));
            Map<String, class_1856> symbols = ShapedRecipeAccess.readSymbols(class_3518.method_15296((JsonObject)json, (String)"key"));
            String[] lines = ShapedRecipeAccess.removePadding(ShapedRecipeAccess.getPattern(class_3518.method_15261((JsonObject)json, (String)"pattern")));
            int width = lines[0].length();
            int height = lines.length;
            class_2371<class_1856> ingredients = ShapedRecipeAccess.createPatternMatrix(lines, symbols, width, height);
            class_1799 result = class_1869.method_35228((JsonObject)class_3518.method_15296((JsonObject)json, (String)"result"));
            return new BookWrapperRecipe(id, part, width, height, ingredients, result);
        }

        public BookWrapperRecipe read(class_2960 id, class_2540 buf) {
            BookWrapperItem.Part part = BookWrapperItem.Part.values()[buf.method_10816()];
            int width = buf.method_10816();
            int height = buf.method_10816();
            class_2371 ingredients = class_2371.method_10213((int)(width * height), (Object)class_1856.field_9017);
            ingredients.replaceAll(ignored -> class_1856.method_8086((class_2540)buf));
            class_1799 result = buf.method_10819();
            return new BookWrapperRecipe(id, part, width, height, (class_2371<class_1856>)ingredients, result);
        }

        public void write(class_2540 buf, BookWrapperRecipe recipe) {
            buf.method_10804(recipe.part.ordinal());
            buf.method_10804(recipe.method_8150());
            buf.method_10804(recipe.method_8158());
            for (class_1856 ingredient : recipe.method_8117()) {
                ingredient.method_8088(buf);
            }
            buf.method_10793(((ShapedRecipeAccess)((Object)recipe)).getOutputStack());
        }
    }
}

