/*
 * Decompiled with CFR 0.152.
 */
package net.shirojr.nemuelch.screen.handler;

import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2586;
import net.minecraft.class_3417;
import net.minecraft.class_3913;
import net.minecraft.class_3914;
import net.minecraft.class_3919;
import net.shirojr.nemuelch.NeMuelch;
import net.shirojr.nemuelch.block.entity.custom.RopeWinchBlockEntity;
import net.shirojr.nemuelch.init.NeMuelchBlocks;
import net.shirojr.nemuelch.init.NeMuelchScreenHandlers;
import net.shirojr.nemuelch.init.NeMuelchTags;

public class RopeWinchScreenHandler
extends class_1703 {
    private final class_1263 inventory;
    private final class_1657 player;
    private final class_3913 propertyDelegate;
    private final class_3914 context;
    private int storedRopes;

    public RopeWinchScreenHandler(int syncId, class_1661 inventory) {
        this(syncId, inventory, (class_1263)new class_1277(1), (class_3913)new class_3919(3), class_3914.field_17304, 0);
    }

    public RopeWinchScreenHandler(int syncId, class_1661 playerInventory, class_1263 inventory, class_3913 delegate, class_3914 context, int storedRopes) {
        super(NeMuelchScreenHandlers.ROPER_SCREEN_HANDLER, syncId);
        RopeWinchScreenHandler.method_17359((class_1263)inventory, (int)1);
        this.inventory = inventory;
        this.player = playerInventory.field_7546;
        inventory.method_5435(this.player);
        this.propertyDelegate = delegate;
        this.context = context;
        this.storedRopes = storedRopes;
        this.method_7621(new class_1735(inventory, 0, 80, 21){

            public boolean method_7680(class_1799 stack) {
                return RopeWinchScreenHandler.this.method_7613(stack, (class_1735)RopeWinchScreenHandler.this.field_7761.get(0));
            }

            public void method_7668() {
                RopeWinchScreenHandler.this.method_7609(this.field_7871);
                super.method_7668();
            }
        });
        this.addPlayerInventory(playerInventory);
        this.addPlayerHotbar(playerInventory);
        this.method_17360(delegate);
    }

    public boolean canPlaceMoreRopes() {
        return this.propertyDelegate.method_17390(0) < this.propertyDelegate.method_17390(1);
    }

    public int ropesInSavedState() {
        return this.propertyDelegate.method_17390(0);
    }

    public void applyProgress() {
        if (this.player.method_37908().method_8608()) {
            this.player.method_5783(class_3417.field_15062, 2.0f, 1.0f);
        }
        this.context.method_17393((world, pos) -> {
            if (!world.field_9236) {
                this.propertyDelegate.method_17391(0, this.storedRopes);
                int validSpace = RopeWinchBlockEntity.getValidRopeBlockSpace(world, pos);
                int ropeCount = this.inventory.method_5438(0).method_7947() + this.ropesInSavedState();
                class_2586 patt0$temp = world.method_8321(pos);
                if (patt0$temp instanceof RopeWinchBlockEntity) {
                    RopeWinchBlockEntity entity = (RopeWinchBlockEntity)patt0$temp;
                    if (ropeCount > validSpace) {
                        entity.setStoredRopes(validSpace);
                        this.inventory.method_5434(0, validSpace);
                    } else {
                        entity.setStoredRopes(ropeCount);
                        this.inventory.method_5441(0);
                    }
                }
                this.method_7623();
            }
        });
    }

    public void resetProgress() {
        if (this.player.method_37908().method_8608()) {
            this.player.method_5783(class_3417.field_15184, 2.0f, 1.0f);
        }
        this.propertyDelegate.method_17391(0, 0);
        this.context.method_17393((world, pos) -> {
            this.propertyDelegate.method_17391(0, 0);
            RopeWinchBlockEntity.removeAllRopeBlocks(world, pos);
            int slotDifference = this.inventory.method_5438(0).method_7914() - this.inventory.method_5438(0).method_7947();
            NeMuelch.LOGGER.info("slotDifference: " + slotDifference + " | items in Slot: " + this.inventory.method_5438(0).method_7947());
            NeMuelch.LOGGER.info("ropes in saved state: " + this.storedRopes);
            if (this.storedRopes > slotDifference) {
                this.inventory.method_5447(0, new class_1799((class_1935)NeMuelchBlocks.ROPE.method_8389(), this.inventory.method_5438(0).method_7914()));
                this.storedRopes -= slotDifference;
            }
            NeMuelch.LOGGER.info("leftover ammount: " + this.storedRopes);
            if (this.storedRopes > 0) {
                world.method_8649((class_1297)new class_1542(world, (double)pos.method_10263(), (double)(pos.method_10264() + 1), (double)pos.method_10260(), new class_1799((class_1935)NeMuelchBlocks.ROPE.method_8389(), this.storedRopes), 0.0, 0.4, 0.0));
                this.storedRopes = 0;
            }
            this.method_7623();
        });
    }

    public boolean method_7604(class_1657 player, int id) {
        if (id == 0) {
            this.resetProgress();
            return true;
        }
        if (id == 1) {
            this.applyProgress();
            return true;
        }
        return super.method_7604(player, id);
    }

    public int getScaledProgress() {
        int progress = this.propertyDelegate.method_17390(0);
        int maxProgress = this.propertyDelegate.method_17390(1);
        int progressArrowSize = 32;
        if (maxProgress == 0 || progress == 0) {
            return 0;
        }
        return progress * progressArrowSize / maxProgress;
    }

    public class_1799 method_7601(class_1657 player, int invSlot) {
        class_1799 newStack = class_1799.field_8037;
        class_1735 slot = (class_1735)this.field_7761.get(invSlot);
        if (slot.method_7681()) {
            class_1799 originalStack = slot.method_7677();
            newStack = originalStack.method_7972();
            if (invSlot < this.inventory.method_5439() ? !this.method_7616(originalStack, this.inventory.method_5439(), this.field_7761.size(), true) : !this.method_7616(originalStack, 0, this.inventory.method_5439(), false)) {
                return class_1799.field_8037;
            }
            if (originalStack.method_7960()) {
                slot.method_48931(class_1799.field_8037);
            } else {
                slot.method_7668();
            }
        }
        return newStack;
    }

    public boolean method_7597(class_1657 player) {
        return RopeWinchScreenHandler.method_17695((class_3914)this.context, (class_1657)player, (class_2248)NeMuelchBlocks.ROPER);
    }

    private void addPlayerInventory(class_1661 playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.method_7621(new class_1735((class_1263)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(class_1661 playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.method_7621(new class_1735((class_1263)playerInventory, i, 8 + i * 18, 142));
        }
    }

    public boolean method_7613(class_1799 itemStack, class_1735 slot) {
        return itemStack.method_31573(NeMuelchTags.Items.ROPER_ROPES);
    }
}

