/*
 * Decompiled with CFR 0.152.
 */
package net.shirojr.nemuelch.util.helper;

import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import org.jetbrains.annotations.Nullable;

public class ExplosionHelper {
    private ExplosionHelper() {
    }

    public static BlockAndEntityHandler explode(class_3218 world, class_2338 origin, int radius, ExplosionShape explosionShape, @Nullable Integer extrusion, Predicate<class_2680> blockExceptions, int blastResistance, boolean involveEntities, float entityDamage) {
        BlockAndEntityHandler outputHandler = new BlockAndEntityHandler();
        HashMap explodedBlocks = new HashMap();
        class_2338.class_2339 currentPos = new class_2338.class_2339();
        ArrayList<class_2338> excludedBlocks = new ArrayList<class_2338>();
        for (int x = -radius; x < radius; ++x) {
            for (int y = -radius; y < radius; ++y) {
                for (int z = -radius; z < radius; ++z) {
                    boolean isExcluded;
                    if (!explosionShape.isInsideVolume(radius, extrusion, new class_2382(x, y, z))) continue;
                    currentPos.method_10103(origin.method_10263() + x, origin.method_10264() + y, origin.method_10260() + z);
                    class_2680 currentBlockState = world.method_8320((class_2338)currentPos);
                    boolean isAir = currentBlockState.method_26215();
                    boolean resistsBlast = currentBlockState.method_26204().method_9520() > (float)blastResistance;
                    boolean bl = isExcluded = !blockExceptions.test(currentBlockState);
                    if (isAir) continue;
                    if (resistsBlast || isExcluded) {
                        excludedBlocks.add(currentPos.method_10062());
                        outputHandler.addToUnaffectedBlockPosList(currentPos.method_10062());
                        continue;
                    }
                    outputHandler.addToAffectedBlockStates(currentPos.method_10062(), currentBlockState);
                }
            }
        }
        if (involveEntities) {
            class_238 box = new class_238(new class_243((double)(origin.method_10263() - radius), (double)(origin.method_10264() - radius), (double)(origin.method_10260() - radius)), new class_243((double)(origin.method_10263() + radius), (double)(origin.method_10264() + radius), (double)(origin.method_10260() + radius)));
            List possibleEntities = world.method_8390(class_1309.class, box, livingEntity -> {
                if (!(livingEntity instanceof class_1657)) {
                    return true;
                }
                class_1657 player = (class_1657)livingEntity;
                return !player.method_31549().field_7477 && !player.method_7325();
            });
            for (class_1309 entity : possibleEntities) {
                double squaredRadius;
                double squaredDistanceToEntity = entity.method_19538().method_1025(class_243.method_24953((class_2382)origin));
                if (!(squaredDistanceToEntity > (squaredRadius = (double)(radius * radius)))) continue;
            }
        }
        for (class_2338 currentExcludedPos : excludedBlocks) {
            outputHandler.except(currentExcludedPos, origin);
        }
        outputHandler.iterateBlocks().forEachRemaining(locatableBlock -> world.method_8501(locatableBlock.pos(), class_2246.field_10124.method_9564()));
        return outputHandler;
    }

    public static void explodeSpherical(class_3218 world, class_2338 origin, int radius) {
        Predicate<class_2680> isSafeFromExplosion = blockState -> {
            if (blockState.method_28498((class_2769)class_2741.field_12508)) {
                return true;
            }
            if (blockState.method_27852(class_2246.field_9987)) {
                return true;
            }
            return true;
        };
        BlockAndEntityHandler blockAndEntityHandler = ExplosionHelper.explode(world, origin, radius, ExplosionShape.SPHERE, null, isSafeFromExplosion, 10000, true, 8.0f);
        blockAndEntityHandler.iterateBlocks().forEachRemaining(entry -> {
            boolean allowParticle;
            class_2338 pos = entry.pos();
            class_2680 state = entry.state();
            boolean bl = allowParticle = world.field_9229.method_43048(2) < 1;
            if (allowParticle) {
                double xMovement = world.field_9229.method_43059() - 0.5;
                double yMovement = world.field_9229.method_43059() - 0.5;
                double zMovement = world.field_9229.method_43059() - 0.5;
                world.method_14199((class_2394)class_2398.field_11236, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), 1, xMovement, yMovement, zMovement, 0.25);
            }
        });
        world.method_8396(null, origin, class_3417.field_15152, class_3419.field_15245, 1.0f, 1.0f);
    }

    static class BlockAndEntityHandler {
        private final List<LocatableBlock> affectedBlockStates = new ArrayList<LocatableBlock>();
        private final List<class_2338> unaffectedBlockPosList = new ArrayList<class_2338>();
        private final List<LocatableEntity<?>> affectedEntities = new ArrayList();
        private final List<UUID> unaffectedEntities = new ArrayList<UUID>();

        public void addToAffectedBlockStates(class_2338 pos, class_2680 state) {
            this.affectedBlockStates.add(new LocatableBlock(pos, state));
        }

        public void addToUnaffectedBlockPosList(class_2338 pos) {
            this.unaffectedBlockPosList.add(pos);
        }

        public void addToTargetedLivingEntities(class_1309 entity) {
            this.affectedEntities.add(new LocatableEntity<class_1309>(entity));
        }

        public List<class_2338> getUnaffectedBlockPosList() {
            return this.unaffectedBlockPosList;
        }

        public Iterator<Locatable> iterateTargets() {
            return Iterators.concat(this.iterateBlocks(), this.iterateEntities());
        }

        public Iterator<LocatableBlock> iterateBlocks() {
            return this.affectedBlockStates.stream().filter(locatableBlock -> !this.unaffectedBlockPosList.contains(locatableBlock.pos())).iterator();
        }

        public Iterator<LocatableEntity<?>> iterateEntities() {
            return this.affectedEntities.stream().filter(locatableEntity -> !this.unaffectedEntities.contains(locatableEntity.entity().method_5667())).iterator();
        }

        public void except(class_2338 excludedPos, class_2338 origin) {
            class_243 p1 = class_243.method_24953((class_2382)excludedPos);
            class_243 p0p1 = class_243.method_24953((class_2382)origin).method_1020(p1);
            if (p0p1.method_1027() == 0.0) {
                return;
            }
            this.iterateTargets().forEachRemaining(locatable -> {
                class_243 p2 = locatable.getPos();
                class_243 p1p2 = p2.method_1020(p1);
                if (p1p2.method_1027() == 0.0) {
                    return;
                }
                if (p0p1.method_1036(p1p2).method_1027() == 0.0) {
                    if (locatable instanceof LocatableBlock) {
                        LocatableBlock locatableBlock = (LocatableBlock)locatable;
                        this.unaffectedBlockPosList.add(locatableBlock.pos());
                    } else if (locatable instanceof LocatableEntity) {
                        LocatableEntity locatableEntity = (LocatableEntity)locatable;
                        this.unaffectedEntities.add(locatableEntity.entity().method_5667());
                    }
                }
            });
        }
    }

    static enum ExplosionShape {
        SPHERE,
        CYLINDER,
        CUBE;


        boolean isInsideVolume(int radius, @Nullable Integer extrusion, class_2382 pos) {
            int x = pos.method_10263();
            int y = pos.method_10264();
            int z = pos.method_10260();
            return switch (this.ordinal()) {
                default -> throw new IncompatibleClassChangeError();
                case 0 -> {
                    if (x * x + y * y + z * z < radius * radius) {
                        yield true;
                    }
                    yield false;
                }
                case 1 -> {
                    if (extrusion == null) {
                        yield false;
                    }
                    if (y < -extrusion.intValue() || y > extrusion) {
                        yield false;
                    }
                    if (x * x + z * z < radius * radius) {
                        yield true;
                    }
                    yield false;
                }
                case 2 -> true;
            };
        }
    }

    record LocatableBlock(class_2338 pos, class_2680 state) implements Locatable
    {
        @Override
        public class_243 getPos() {
            return class_243.method_24953((class_2382)this.pos);
        }
    }

    record LocatableEntity<T extends class_1297>(T entity) implements Locatable
    {
        @Override
        public class_243 getPos() {
            return this.entity.method_19538();
        }
    }

    static interface Locatable {
        public class_243 getPos();
    }
}

