/*
 * Decompiled with CFR 0.152.
 */
package net.shirojr.nemuelch.util.logger;

import net.fabricmc.loader.api.FabricLoader;
import net.shirojr.nemuelch.util.logger.LoggerType;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggerUtil {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"nemuelch");

    private LoggerUtil() {
    }

    public static void devLogger(String input) {
        LoggerUtil.devLogger(input, LoggerType.INFO, null);
    }

    public static void devLogger(String input, LoggerType loggerType, @Nullable Exception exception) {
        if (!FabricLoader.getInstance().isDevelopmentEnvironment()) {
            return;
        }
        String printText = "DEV - [ " + input + " ]";
        switch (loggerType) {
            case INFO: {
                LOGGER.info(printText);
                break;
            }
            case WARNING: {
                LOGGER.warn(printText);
                break;
            }
            case ERROR: {
                if (exception == null) {
                    LOGGER.error(printText);
                    break;
                }
                LOGGER.error(printText, (Throwable)exception);
            }
        }
    }
}

