/*
 * Decompiled with CFR 0.152.
 */
package net.shirojr.nemuelch.camera;

import java.util.Objects;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import org.joml.Vector3f;

public class Displacement {
    public static final float EQUALITY_TOLERANCE = 1.0E-6f;
    private class_243 position;
    private float yaw;
    private float pitch;
    private float roll;

    public Displacement(class_243 position, float yaw, float pitch, float roll) {
        this.position = position;
        this.yaw = yaw;
        this.pitch = pitch;
        this.roll = roll;
    }

    public Displacement(class_243 position, Vector3f rotations) {
        this(position, rotations.x, rotations.y, rotations.z);
    }

    public Displacement(class_243 position) {
        this(position, 0.0f, 0.0f, 0.0f);
    }

    public Displacement(float yaw, float pitch, float roll) {
        this(class_243.field_1353, yaw, pitch, roll);
    }

    public Displacement(float yaw, float pitch) {
        this(yaw, pitch, 0.0f);
    }

    public Displacement() {
        this(class_243.field_1353);
    }

    public class_243 getPosition() {
        return this.position;
    }

    public void setPosition(class_243 position) {
        this.position = position;
    }

    public Vector3f getRotations() {
        return new Vector3f(this.yaw, this.pitch, this.roll);
    }

    public void setRotations(Vector3f rotations) {
        this.setYaw(rotations.x);
        this.setPitch(rotations.y);
        this.setRoll(rotations.z);
    }

    public void setRotations(float yaw, float pitch) {
        this.setYaw(yaw);
        this.setPitch(pitch);
    }

    public float getYaw() {
        return this.yaw;
    }

    public void setYaw(float yaw) {
        this.yaw = class_3532.method_15393((float)yaw);
    }

    public float getPitch() {
        return this.pitch;
    }

    public void setPitch(float pitch) {
        this.pitch = class_3532.method_15363((float)pitch, (float)-90.0f, (float)90.0f);
    }

    public float getRoll() {
        return this.roll;
    }

    public void setRoll(float roll) {
        this.roll = class_3532.method_15393((float)roll);
    }

    public class_243 getForwardVector() {
        return class_243.method_1030((float)this.pitch, (float)this.yaw);
    }

    public void add(Displacement other) {
        this.addPosition(other);
        this.addRotation(other);
    }

    public void addPosition(Displacement other) {
        this.setPosition(this.getPosition().method_1019(other.getPosition()));
    }

    public void addRotation(Displacement other) {
        this.setYaw(this.getYaw() + other.getYaw());
        this.setPitch(this.getPitch() + other.getPitch());
        this.setRoll(this.getRoll() + other.getRoll());
    }

    public static Displacement lerp(double delta, Displacement start, Displacement end) {
        class_243 newPos = start.equals(end) ? start.getPosition() : new class_243(class_3532.method_16436((double)delta, (double)start.getPosition().field_1352, (double)end.getPosition().field_1352), class_3532.method_16436((double)delta, (double)start.getPosition().field_1351, (double)end.getPosition().field_1351), class_3532.method_16436((double)delta, (double)start.getPosition().field_1350, (double)end.getPosition().field_1350));
        Vector3f newRotations = start.equals(end) ? start.getRotations() : new Vector3f(class_3532.method_17821((float)((float)delta), (float)start.getYaw(), (float)end.getYaw()), class_3532.method_16439((float)((float)delta), (float)start.getPitch(), (float)end.getPitch()), class_3532.method_17821((float)((float)delta), (float)start.getRoll(), (float)end.getRoll()));
        return new Displacement(newPos, newRotations);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Displacement other = (Displacement)obj;
        if (Math.abs(this.yaw - other.yaw) >= 1.0E-6f) {
            return false;
        }
        if (Math.abs(this.pitch - other.pitch) >= 1.0E-6f) {
            return false;
        }
        if (Math.abs(this.roll - other.roll) >= 1.0E-6f) {
            return false;
        }
        if (this.position == null) {
            return other.position == null;
        }
        if (other.position == null) {
            return false;
        }
        return this.position.method_1025(other.position) < (double)1.0E-12f;
    }

    public int hashCode() {
        double hashScale = 1000000.0025247573;
        int posHash = this.position != null ? Objects.hash((double)Math.round(this.position.field_1352 * hashScale) / hashScale, (double)Math.round(this.position.field_1351 * hashScale) / hashScale, (double)Math.round(this.position.field_1350 * hashScale) / hashScale) : 0;
        return Objects.hash(posHash, (double)Math.round((double)this.yaw * hashScale) / hashScale, (double)Math.round((double)this.pitch * hashScale) / hashScale, (double)Math.round((double)this.roll * hashScale) / hashScale);
    }
}

