/*
 * Decompiled with CFR 0.152.
 */
package net.shirojr.nemuelch.camera;

import net.minecraft.class_3532;
import net.shirojr.nemuelch.camera.Displacement;
import org.apache.commons.lang3.function.TriFunction;

public enum Easing {
    LINEAR((TriFunction<Double, Displacement, Displacement, Displacement>)((TriFunction)Displacement::lerp)),
    SMOOTH_STEP((TriFunction<Double, Displacement, Displacement, Displacement>)((TriFunction)(delta, start, end) -> {
        double smoothStep = class_3532.method_15350((double)delta, (double)0.0, (double)1.0);
        smoothStep = smoothStep * smoothStep * (3.0 - 2.0 * smoothStep);
        return Displacement.lerp(smoothStep, start, end);
    })),
    EASE_IN((TriFunction<Double, Displacement, Displacement, Displacement>)((TriFunction)(delta, start, end) -> Displacement.lerp(delta * delta, start, end))),
    EASE_OUT((TriFunction<Double, Displacement, Displacement, Displacement>)((TriFunction)(delta, start, end) -> {
        double easedDelta = 1.0 - Math.pow(1.0 - delta, 2.0);
        return Displacement.lerp(easedDelta, start, end);
    })),
    EASE_IN_OUT((TriFunction<Double, Displacement, Displacement, Displacement>)((TriFunction)(delta, start, end) -> {
        double easedDelta = delta < 0.5 ? 2.0 * delta * delta : 1.0 - Math.pow(-2.0 * delta + 2.0, 2.0) / 2.0;
        return Displacement.lerp(easedDelta, start, end);
    })),
    OVERSHOOT_BOUNCE((TriFunction<Double, Displacement, Displacement, Displacement>)((TriFunction)(delta, start, end) -> Displacement.lerp(Easing.bounceOut(delta), start, end))),
    OVERSHOOT_SPRING((TriFunction<Double, Displacement, Displacement, Displacement>)((TriFunction)(delta, start, end) -> Displacement.lerp(Easing.springOut(delta), start, end))),
    EASE_POWER_QUADRATIC((TriFunction<Double, Displacement, Displacement, Displacement>)((TriFunction)(delta, start, end) -> Easing.easePower(delta, start, end, 2.0))),
    EASE_POWER_CUBIC((TriFunction<Double, Displacement, Displacement, Displacement>)((TriFunction)(delta, start, end) -> Easing.easePower(delta, start, end, 3.0)));

    private final TriFunction<Double, Displacement, Displacement, Displacement> function;

    private Easing(TriFunction<Double, Displacement, Displacement, Displacement> function) {
        this.function = function;
    }

    public Displacement interpolate(double delta, Displacement start, Displacement end) {
        return (Displacement)this.function.apply((Object)delta, (Object)start, (Object)end);
    }

    public static Displacement easePower(double delta, Displacement start, Displacement end, double power) {
        double easedDelta = Math.pow(delta, power);
        return Displacement.lerp(easedDelta, start, end);
    }

    private static double bounceOut(double delta) {
        if (delta < 0.36363636363636365) {
            return 7.5625 * delta * delta;
        }
        if (delta < 0.7272727272727273) {
            return 7.5625 * (delta -= 0.5454545454545454) * delta + 0.75;
        }
        if (delta < 0.9090909090909091) {
            return 7.5625 * (delta -= 0.8181818181818182) * delta + 0.9375;
        }
        return 7.5625 * (delta -= 0.9545454545454546) * delta + 0.984375;
    }

    private static double springOut(double delta) {
        if (delta == 0.0 || delta == 1.0) {
            return delta;
        }
        double oscillationFrequency = 0.3;
        double phaseShift = oscillationFrequency / 4.0;
        return Math.pow(2.0, -10.0 * delta) * Math.sin((delta - phaseShift) * (Math.PI * 2) / oscillationFrequency) + 1.0;
    }
}

