/*
 * Decompiled with CFR 0.152.
 */
package net.shirojr.nemuelch.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collection;
import java.util.HashSet;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_7157;
import net.minecraft.server.MinecraftServer;
import net.shirojr.nemuelch.compat.cca.component.ActCommandComponent;
import net.shirojr.nemuelch.init.NeMuelchConfigInit;

public class ActCommand
implements CommandRegistrationCallback {
    public static double MAX_DISTANCE = NeMuelchConfigInit.CONFIG.actCommandMaxRange;
    private static final SimpleCommandExceptionType SOURCE_NO_PLAYER = new SimpleCommandExceptionType((Message)class_2561.method_43470((String)"Command not executed by player"));

    public void register(CommandDispatcher<class_2168> dispatcher, class_7157 commandRegistryAccess, class_2170.class_5364 environment) {
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"act").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"content", (ArgumentType)StringArgumentType.string()).executes(ActCommand::runDefault)).then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9308()).executes(ActCommand::runTargets))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"act-debug").requires(source -> source.method_9259(2))).then(class_2170.method_9247((String)"stalk").then(class_2170.method_9244((String)"stalk", (ArgumentType)BoolArgumentType.bool()).executes(ActCommand::runStalkToggle))));
    }

    private static int runTargets(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (player == null) {
            throw SOURCE_NO_PLAYER.create();
        }
        HashSet<class_3222> targetsInMaxRange = new HashSet<class_3222>();
        for (class_3222 target : class_2186.method_9312(context, (String)"targets")) {
            if (player.method_5858((class_1297)target) > MAX_DISTANCE * MAX_DISTANCE) continue;
            targetsInMaxRange.add(target);
        }
        ActCommand.sendText(player, targetsInMaxRange, StringArgumentType.getString(context, (String)"content"));
        return 1;
    }

    private static int runDefault(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (player == null) {
            throw SOURCE_NO_PLAYER.create();
        }
        Collection around = PlayerLookup.around((class_3218)player.method_51469(), (class_243)player.method_19538(), (double)MAX_DISTANCE);
        ActCommand.sendText(player, around, StringArgumentType.getString(context, (String)"content"));
        return 1;
    }

    private static int runStalkToggle(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (player == null) {
            throw SOURCE_NO_PLAYER.create();
        }
        boolean stalk = BoolArgumentType.getBool(context, (String)"stalk");
        ActCommandComponent actCommandComponent = ActCommandComponent.get((class_1657)player);
        actCommandComponent.setStalkMode(stalk);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Stalk all /act commands: " + actCommandComponent.enabledStalkMode())), true);
        return 1;
    }

    private static void sendText(class_3222 source, Collection<class_3222> targets, String content) {
        HashSet<class_3222> receivers = new HashSet<class_3222>(targets);
        MinecraftServer server = source.method_5682();
        if (server != null) {
            for (class_3222 entry : PlayerLookup.all((MinecraftServer)server)) {
                ActCommandComponent actCommandComponent;
                if (!entry.method_5687(2) || !(actCommandComponent = ActCommandComponent.get((class_1657)entry)).enabledStalkMode()) continue;
                receivers.add(entry);
            }
        }
        for (class_3222 target : receivers) {
            class_5250 text = class_2561.method_43470((String)"\u00a76[%s]\u00a7r %s".formatted(source.method_5477().getString(), content)).method_27692(class_124.field_1056);
            if (NeMuelchConfigInit.CONFIG.printActCommandInChat) {
                target.method_7353((class_2561)text, false);
            }
            if (!NeMuelchConfigInit.CONFIG.printActCommandInActionBar) continue;
            target.method_7353((class_2561)text, true);
        }
    }
}

