/*
 * Decompiled with CFR 0.152.
 */
package net.shirojr.nemuelch.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_1923;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2262;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2561;
import net.minecraft.class_2791;
import net.minecraft.class_3218;
import net.minecraft.class_7157;
import net.shirojr.nemuelch.compat.cca.component.BlightChunkComponent;
import net.shirojr.nemuelch.compat.cca.component.BlightChunkTrackerComponent;
import net.shirojr.nemuelch.compat.cca.util.BlightType;

public class BlightCommands
implements CommandRegistrationCallback {
    private static final SimpleCommandExceptionType NO_BLIGHT = new SimpleCommandExceptionType((Message)class_2561.method_43470((String)"Requested Data does not contain any Blight"));

    public void register(CommandDispatcher<class_2168> dispatcher, class_7157 commandRegistryAccess, class_2170.class_5364 registrationEnvironment) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"blight").requires(source -> source.method_9259(2))).then(class_2170.method_9244((String)"from", (ArgumentType)class_2262.method_9698()).then(class_2170.method_9244((String)"to", (ArgumentType)class_2262.method_9698()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"type", (ArgumentType)BlightType.ArgumentType.blightType()).then(class_2170.method_9247((String)"add").executes(BlightCommands::addType))).then(class_2170.method_9247((String)"clear").then(class_2170.method_9247((String)"chunks").executes(BlightCommands::clearChunks))))))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"single", (ArgumentType)class_2262.method_9698()).then(class_2170.method_9247((String)"clear").executes(BlightCommands::clearSingle))).then(class_2170.method_9247((String)"info").executes(BlightCommands::info)))).then(class_2170.method_9247((String)"clear").then(class_2170.method_9247((String)"all").executes(BlightCommands::clearAll)))).then(class_2170.method_9247((String)"info").then(class_2170.method_9247((String)"all").executes(BlightCommands::infoAll))));
    }

    private static int infoAll(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3218 world = ((class_2168)context.getSource()).method_9225();
        Set<class_1923> allBlightedChunks = BlightChunkTrackerComponent.get(world).getAllBlightedChunks();
        if (allBlightedChunks.isEmpty()) {
            throw NO_BLIGHT.create();
        }
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Chunks with Blights: "), true);
        for (class_1923 entry : allBlightedChunks) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"ChunkPos: %s".formatted(entry)), true);
        }
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"%s Chunks contain blight data".formatted(allBlightedChunks.size())), true);
        return 1;
    }

    private static int clearAll(CommandContext<class_2168> context) {
        class_3218 world = ((class_2168)context.getSource()).method_9225();
        BlightChunkTrackerComponent.get(world).clearBlightedChunks(world);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Cleared all partial and complete Chunk Blights in current world"), true);
        return 1;
    }

    private static int info(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2338 pos;
        class_3218 world = ((class_2168)context.getSource()).method_9225();
        class_2791 chunk = world.method_22350(pos = class_2262.method_48299(context, (String)"single"));
        Optional<BlightChunkComponent> component = BlightChunkComponent.maybeGet(chunk);
        if (component.isEmpty() || component.get().isEmpty()) {
            throw NO_BLIGHT.create();
        }
        EnumSet<BlightType> completeChunkBlights = component.get().getCompleteChunkBlights();
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Complete Blights: %s".formatted(completeChunkBlights)), true);
        for (BlightType type : BlightType.CACHED_VALUES) {
            int blightPosCount = component.get().getBlightPosCount(type);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"%s with %s Blocks blighted".formatted(new Object[]{type, blightPosCount})), true);
        }
        return 1;
    }

    private static int clearSingle(CommandContext<class_2168> context) {
        class_3218 world = ((class_2168)context.getSource()).method_9225();
        class_2338 pos = class_2262.method_48299(context, (String)"single");
        class_2791 chunk = world.method_22350(pos);
        BlightChunkComponent.maybeGet(chunk).ifPresent(component -> component.clear(true, true, true));
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Cleared %s of any Blight".formatted(chunk)), true);
        return 1;
    }

    private static int clearChunks(CommandContext<class_2168> context) {
        class_3218 world = ((class_2168)context.getSource()).method_9225();
        class_2338 from = class_2262.method_48299(context, (String)"from");
        class_2338 to = class_2262.method_48299(context, (String)"to");
        class_238 box = new class_238(from, to);
        HashSet chunks = new HashSet();
        BlightType type = BlightType.ArgumentType.getBlockRotation(context, "type");
        class_2338.method_29715((class_238)box).forEach(pos -> chunks.add(world.method_22350(pos)));
        for (class_2791 chunk : chunks) {
            Optional<BlightChunkComponent> blightChunkComponent = BlightChunkComponent.maybeGet(chunk);
            if (blightChunkComponent.isEmpty()) continue;
            BlightChunkComponent component = blightChunkComponent.get();
            component.clear(type);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Cleared Chunk of ChunkPos [x: %s| z: %s]".formatted(chunk.method_12004().field_9181, chunk.method_12004().field_9180)), true);
        }
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Removed all Blight data from %s chunks".formatted(chunks.size())), true);
        return 1;
    }

    private static int addType(CommandContext<class_2168> context) {
        class_3218 world = ((class_2168)context.getSource()).method_9225();
        class_2338 from = class_2262.method_48299(context, (String)"from");
        class_2338 to = class_2262.method_48299(context, (String)"to");
        BlightType type = BlightType.ArgumentType.getBlockRotation(context, "type");
        boolean blightedAnything = false;
        class_238 box = new class_238(from, to);
        for (class_2338 pos : class_2338.method_10097((class_2338)from, (class_2338)to)) {
            BlightChunkComponent component;
            class_2791 chunk = world.method_22350(pos);
            Optional<BlightChunkComponent> blightChunkComponent = BlightChunkComponent.maybeGet(chunk);
            if (blightChunkComponent.isEmpty() || (component = blightChunkComponent.get()).getCompleteChunkBlights().contains((Object)type)) continue;
            blightedAnything = component.addBlightsToPos(pos, Set.of(type));
        }
        if (blightedAnything) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Added %s to all BlockPos in %s".formatted(new Object[]{type, box})), true);
        } else {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Noting was blighted"), true);
        }
        return 1;
    }
}

