/*
 * Decompiled with CFR 0.152.
 */
package net.shirojr.nemuelch.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2178;
import net.minecraft.class_2186;
import net.minecraft.class_2287;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_7157;

public class MiscItemCommands
implements CommandRegistrationCallback {
    private static final SimpleCommandExceptionType MISSING_PLAYER_EXECUTION = new SimpleCommandExceptionType((Message)class_2561.method_43470((String)"Command needs to be executed by Player"));

    public void register(CommandDispatcher<class_2168> commandDispatcher, class_7157 commandRegistryAccess, class_2170.class_5364 registrationEnvironment) {
        CommandNode itemRoot = commandDispatcher.getRoot().getChild("item");
        if (itemRoot == null) {
            return;
        }
        itemRoot.addChild(MiscItemCommands.buildTextCommand("rename", "name", (Command<class_2168>)((Command)MiscItemCommands::reName)));
        itemRoot.addChild(MiscItemCommands.buildTextCommand("relore", "lore", (Command<class_2168>)((Command)MiscItemCommands::reLore)));
        itemRoot.addChild(MiscItemCommands.buildStringCommand("reauthor", "author", (Command<class_2168>)((Command)MiscItemCommands::reAuthor)));
        itemRoot.addChild(MiscItemCommands.buildIntCommand("redamage", "damage", (Command<class_2168>)((Command)MiscItemCommands::reDamage)));
        itemRoot.addChild(MiscItemCommands.buildIntCommand("redurability", "durability", (Command<class_2168>)((Command)MiscItemCommands::reDurability)));
        itemRoot.addChild(MiscItemCommands.buildBooleanCommand("glint", "glint", (Command<class_2168>)((Command)MiscItemCommands::glint)));
        itemRoot.addChild(MiscItemCommands.buildBooleanCommand("unbreakable", "unbreakable", (Command<class_2168>)((Command)MiscItemCommands::unbreakable)));
        itemRoot.addChild(MiscItemCommands.buildEntityCommand("dropall", "target", (Command<class_2168>)((Command)MiscItemCommands::dropAll)));
        itemRoot.addChild((CommandNode)((LiteralArgumentBuilder)class_2170.method_9247((String)"cooldown").then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9306()).then(class_2170.method_9244((String)"item", (ArgumentType)class_2287.method_9776((class_7157)commandRegistryAccess)).then(class_2170.method_9244((String)"ticks", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(MiscItemCommands::reCooldown))))).build());
    }

    private static int unbreakable(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (player == null) {
            throw MISSING_PLAYER_EXECUTION.create();
        }
        boolean unbreakable = BoolArgumentType.getBool(context, (String)"unbreakable");
        class_1799 mainHandStack = player.method_6047();
        class_2487 nbt = mainHandStack.method_7948();
        nbt.method_10556("Unbreakable", unbreakable);
        return MiscItemCommands.finalizeCommand(context);
    }

    private static int glint(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (player == null) {
            throw MISSING_PLAYER_EXECUTION.create();
        }
        boolean glint = BoolArgumentType.getBool(context, (String)"glint");
        class_1799 mainHandStack = player.method_6047();
        class_2487 nbt = mainHandStack.method_7948();
        class_2487 displayNbt = nbt.method_10545("display") ? nbt.method_10562("display") : new class_2487();
        displayNbt.method_10556("glint", glint);
        nbt.method_10566("display", (class_2520)displayNbt);
        return MiscItemCommands.finalizeCommand(context);
    }

    private static int dropAll(CommandContext<class_2168> context) throws CommandSyntaxException {
        StringBuilder sb = new StringBuilder();
        for (class_1297 entity : class_2186.method_9317(context, (String)"target")) {
            if (!sb.isEmpty()) {
                sb.append(", ");
            }
            sb.append(entity.method_5477().getString());
            if (entity instanceof class_1657) {
                class_1657 player = (class_1657)entity;
                player.method_31548().method_7388();
                continue;
            }
            if (!(entity instanceof class_1309)) continue;
            class_1309 livingEntity = (class_1309)entity;
            for (class_1799 stack : livingEntity.method_5743()) {
                if (stack == null || stack.method_7960()) continue;
                livingEntity.method_5775(stack.method_7972());
                stack.method_7939(0);
            }
        }
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Dropped all items for " + String.valueOf(sb))), true);
        return 1;
    }

    private static int reDurability(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (player == null) {
            throw MISSING_PLAYER_EXECUTION.create();
        }
        class_1799 mainHandStack = player.method_6047();
        int damage = Math.min(IntegerArgumentType.getInteger(context, (String)"durability"), mainHandStack.method_7936());
        mainHandStack.method_7974(mainHandStack.method_7936() - damage);
        return MiscItemCommands.finalizeCommand(context);
    }

    private static int reDamage(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (player == null) {
            throw MISSING_PLAYER_EXECUTION.create();
        }
        class_1799 mainHandStack = player.method_6047();
        int damage = Math.min(IntegerArgumentType.getInteger(context, (String)"damage"), mainHandStack.method_7936());
        mainHandStack.method_7974(damage);
        return MiscItemCommands.finalizeCommand(context);
    }

    private static int reAuthor(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (player == null) {
            throw MISSING_PLAYER_EXECUTION.create();
        }
        String author = StringArgumentType.getString(context, (String)"author");
        class_1799 mainHandStack = player.method_6047();
        mainHandStack.method_7959("author", (class_2520)class_2519.method_23256((String)author));
        return MiscItemCommands.finalizeCommand(context);
    }

    private static int reLore(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (player == null) {
            throw MISSING_PLAYER_EXECUTION.create();
        }
        class_2561 lore = class_2178.method_9280(context, (String)"lore");
        class_1799 mainHandStack = player.method_6047();
        class_2487 nbt = mainHandStack.method_7948();
        class_2487 displayNbt = nbt.method_10545("display") ? nbt.method_10562("display") : new class_2487();
        class_2499 loreListNbt = new class_2499();
        String jsonLore = class_2561.class_2562.method_10867((class_2561)lore);
        loreListNbt.add((Object)class_2519.method_23256((String)jsonLore));
        displayNbt.method_10566("Lore", (class_2520)loreListNbt);
        return MiscItemCommands.finalizeCommand(context);
    }

    private static int reName(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (player == null) {
            throw MISSING_PLAYER_EXECUTION.create();
        }
        class_2561 name = class_2178.method_9280(context, (String)"name");
        class_1799 mainHandStack = player.method_6047();
        mainHandStack.method_7977(name);
        return MiscItemCommands.finalizeCommand(context);
    }

    private static int reCooldown(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_1792 item = class_2287.method_9777(context, (String)"item").method_9785();
        int ticks = IntegerArgumentType.getInteger(context, (String)"ticks");
        StringBuilder sb = new StringBuilder();
        int validEntries = 0;
        for (class_1297 entity : class_2186.method_9317(context, (String)"targets")) {
            if (!(entity instanceof class_1657)) continue;
            class_1657 player = (class_1657)entity;
            player.method_7357().method_7906(item, ticks);
            if (validEntries > 0) {
                sb.append(", ");
            }
            ++validEntries;
            sb.append(player.method_5477().getString());
        }
        if (validEntries <= 0) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"No cooldown was applied"), true);
            return 0;
        }
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Applied %s ticks cooldown to %s for ".formatted(ticks, item.method_7848().getString()) + String.valueOf(sb))), true);
        return 1;
    }

    private static LiteralCommandNode<class_2168> buildTextCommand(String commandName, String argumentName, Command<class_2168> executes) {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)commandName).requires(source -> source.method_9259(2))).then(class_2170.method_9244((String)argumentName, (ArgumentType)class_2178.method_9281()).executes(executes))).build();
    }

    private static LiteralCommandNode<class_2168> buildStringCommand(String commandName, String argumentName, Command<class_2168> executes) {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)commandName).requires(source -> source.method_9259(2))).then(class_2170.method_9244((String)argumentName, (ArgumentType)StringArgumentType.string()).executes(executes))).build();
    }

    private static LiteralCommandNode<class_2168> buildIntCommand(String commandName, String argumentName, Command<class_2168> executes) {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)commandName).requires(source -> source.method_9259(2))).then(class_2170.method_9244((String)argumentName, (ArgumentType)IntegerArgumentType.integer()).executes(executes))).build();
    }

    private static CommandNode<class_2168> buildEntityCommand(String commandName, String argumentName, Command<class_2168> executes) {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)commandName).requires(source -> source.method_9259(2))).then(class_2170.method_9244((String)argumentName, (ArgumentType)class_2186.method_9306()).executes(executes))).build();
    }

    private static CommandNode<class_2168> buildBooleanCommand(String commandName, String argumentName, Command<class_2168> executes) {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)commandName).requires(source -> source.method_9259(2))).then(class_2170.method_9244((String)argumentName, (ArgumentType)BoolArgumentType.bool()).executes(executes))).build();
    }

    private static int finalizeCommand(CommandContext<class_2168> context) {
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Successfully applied item data to Main Hand ItemStack"), true);
        return 1;
    }
}

