/*
 * Decompiled with CFR 0.152.
 */
package net.shirojr.nemuelch.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.tree.CommandNode;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2277;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_5321;
import net.minecraft.class_7157;
import net.minecraft.class_7733;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.shirojr.nemuelch.command.NeMuelchCommandUtil;
import net.shirojr.nemuelch.init.NeMuelchItems;
import net.shirojr.nemuelch.item.custom.adminToolItem.SoundToolItem;
import org.jetbrains.annotations.Nullable;

public class SoundToolCommand
implements CommandRegistrationCallback {
    private static final SimpleCommandExceptionType NO_USER = new SimpleCommandExceptionType((Message)class_2561.method_43470((String)"Command needs to be executed by an Entity"));
    private static final SimpleCommandExceptionType NOT_VALID_SOUND = new SimpleCommandExceptionType((Message)class_2561.method_43470((String)"Specified SoundEvent is not valid"));

    public void register(CommandDispatcher<class_2168> dispatcher, class_7157 commandRegistryAccess, class_2170.class_5364 registrationEnvironment) {
        LiteralArgumentBuilder soundToolCommandNode = (LiteralArgumentBuilder)class_2170.method_9247((String)"sound").then(class_2170.method_9247((String)"tool").then(class_2170.method_9247((String)"create").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"sound", (ArgumentType)class_7733.method_45603((class_7157)commandRegistryAccess, (class_5321)class_7924.field_41225)).executes(SoundToolCommand::run)).then(class_2170.method_9244((String)"volume", (ArgumentType)FloatArgumentType.floatArg()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"pitch", (ArgumentType)FloatArgumentType.floatArg()).executes(SoundToolCommand::runVolPitch)).then(class_2170.method_9244((String)"pos", (ArgumentType)class_2277.method_9737()).executes(SoundToolCommand::runVolPitchPos))).then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9309()).executes(SoundToolCommand::runVolPitchTarget)))))));
        NeMuelchCommandUtil.getOrCreateNeMuelchNode(dispatcher).addChild((CommandNode)soundToolCommandNode.build());
    }

    private static int run(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (player == null) {
            throw NO_USER.create();
        }
        class_5321 sound = (class_5321)class_7733.method_45602(context, (String)"sound", (class_5321)class_7924.field_41225).method_40230().orElseThrow(() -> ((SimpleCommandExceptionType)NOT_VALID_SOUND).create());
        class_1799 stack = NeMuelchItems.SOUND_TOOL.method_7854();
        SoundToolCommand.modifyStack(stack, (class_3414)class_7923.field_41172.method_29107(sound), null, null, null, null);
        player.method_31548().method_7398(stack);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Created new Item successfully"), true);
        return 1;
    }

    private static int runVolPitch(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (player == null) {
            throw NO_USER.create();
        }
        class_5321 sound = (class_5321)class_7733.method_45602(context, (String)"sound", (class_5321)class_7924.field_41225).method_40230().orElseThrow(() -> ((SimpleCommandExceptionType)NOT_VALID_SOUND).create());
        class_1799 stack = NeMuelchItems.SOUND_TOOL.method_7854();
        float volume = FloatArgumentType.getFloat(context, (String)"volume");
        float pitch = FloatArgumentType.getFloat(context, (String)"pitch");
        SoundToolCommand.modifyStack(stack, (class_3414)class_7923.field_41172.method_29107(sound), Float.valueOf(volume), Float.valueOf(pitch), null, null);
        player.method_31548().method_7398(stack);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Created new Item successfully"), true);
        return 1;
    }

    private static int runVolPitchPos(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (player == null) {
            throw NO_USER.create();
        }
        class_5321 sound = (class_5321)class_7733.method_45602(context, (String)"sound", (class_5321)class_7924.field_41225).method_40230().orElseThrow(() -> ((SimpleCommandExceptionType)NOT_VALID_SOUND).create());
        class_1799 stack = NeMuelchItems.SOUND_TOOL.method_7854();
        float volume = FloatArgumentType.getFloat(context, (String)"volume");
        float pitch = FloatArgumentType.getFloat(context, (String)"pitch");
        class_243 pos = class_2277.method_9736(context, (String)"pos");
        SoundToolCommand.modifyStack(stack, (class_3414)class_7923.field_41172.method_29107(sound), Float.valueOf(volume), Float.valueOf(pitch), pos, null);
        player.method_31548().method_7398(stack);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Created new Item successfully"), true);
        return 1;
    }

    private static int runVolPitchTarget(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (player == null) {
            throw NO_USER.create();
        }
        class_5321 sound = (class_5321)class_7733.method_45602(context, (String)"sound", (class_5321)class_7924.field_41225).method_40230().orElseThrow(() -> ((SimpleCommandExceptionType)NOT_VALID_SOUND).create());
        class_1799 stack = NeMuelchItems.SOUND_TOOL.method_7854();
        float volume = FloatArgumentType.getFloat(context, (String)"volume");
        float pitch = FloatArgumentType.getFloat(context, (String)"pitch");
        class_1297 entity = class_2186.method_9313(context, (String)"target");
        SoundToolCommand.modifyStack(stack, (class_3414)class_7923.field_41172.method_29107(sound), Float.valueOf(volume), Float.valueOf(pitch), null, entity);
        player.method_31548().method_7398(stack);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Created new Item successfully"), true);
        return 1;
    }

    private static void modifyStack(class_1799 stack, class_3414 sound, @Nullable Float volume, @Nullable Float pitch, @Nullable class_243 pos, @Nullable class_1297 target) {
        SoundToolItem.setSound(stack, sound);
        if (volume != null) {
            SoundToolItem.setVolume(stack, volume);
        }
        if (pitch != null) {
            SoundToolItem.setPitch(stack, pitch);
        }
        if (pos != null) {
            SoundToolItem.setPos(stack, pos);
        }
        if (target != null) {
            SoundToolItem.setTarget(stack, target);
        }
    }
}

