/*
 * Decompiled with CFR 0.152.
 */
package net.shirojr.nemuelch.compat.cca.component;

import dev.onyxstudios.cca.api.v3.component.Component;
import dev.onyxstudios.cca.api.v3.component.sync.AutoSyncedComponent;
import dev.onyxstudios.cca.api.v3.component.tick.ServerTickingComponent;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.Predicate;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2818;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.shirojr.nemuelch.NeMuelch;
import net.shirojr.nemuelch.compat.cca.NeMuelchComponents;
import net.shirojr.nemuelch.compat.cca.util.BlightType;
import net.shirojr.nemuelch.init.NeMuelchTags;
import org.jetbrains.annotations.Nullable;

public interface BlightChunkComponent
extends Component,
ServerTickingComponent,
AutoSyncedComponent {
    public static final class_2960 KEY = NeMuelch.getId("blight_chunk");
    public static final int DEFAULT_TICK_SPEED = 800;
    public static final Map<class_2680, Boolean> BLIGHT_IMMUNITY_CACHE = new WeakHashMap<class_2680, Boolean>();
    public static final Predicate<class_2680> NO_BLIGHT = state -> BLIGHT_IMMUNITY_CACHE.computeIfAbsent((class_2680)state, entry -> {
        if (!entry.method_26227().method_15769()) {
            return true;
        }
        if (state.method_26164(NeMuelchTags.Blocks.NEVER_BLIGHT)) {
            return true;
        }
        return state.method_26164(class_3481.field_33715);
    });

    public static Optional<BlightChunkComponent> maybeGet(@Nullable class_2791 chunk) {
        if (chunk == null) {
            return Optional.empty();
        }
        return NeMuelchComponents.BLIGHT_CHUNK.maybeGet((Object)chunk);
    }

    @Nullable
    default public class_3218 getServerWorld() {
        class_2791 class_27912 = this.getProvider();
        if (!(class_27912 instanceof class_2818)) {
            return null;
        }
        class_2818 worldChunk = (class_2818)class_27912;
        class_1937 class_19372 = worldChunk.method_12200();
        if (!(class_19372 instanceof class_3218)) {
            return null;
        }
        class_3218 serverWorld = (class_3218)class_19372;
        return serverWorld;
    }

    public class_2791 getProvider();

    public EnumSet<BlightType> getBlightsOfPos(class_2338 var1);

    public HashSet<class_2338> getPosWithBlights(BlightType ... var1);

    public boolean addBlightsToPos(class_2338 var1, Set<BlightType> var2);

    public EnumSet<BlightType> getCompleteChunkBlights();

    public double getCompleteBlightThreshold();

    public void setCompleteBlightThreshold(double var1);

    public long getTimeOfFirstInitializedBlight();

    public long getTick();

    public void setTick(long var1);

    public void stopTicking();

    public void clearAndConvertToCompleteBlight(BlightType var1);

    public int getBlightPosCount(BlightType var1);

    default public boolean isBlighted(class_2338 pos, BlightType ... types) {
        EnumSet<BlightType> blightsOfPos = this.getBlightsOfPos(pos);
        if (types.length == 0) {
            return !blightsOfPos.isEmpty();
        }
        for (BlightType type : types) {
            if (blightsOfPos.contains((Object)type)) continue;
            return false;
        }
        return true;
    }

    default public boolean isBlightedWithAllTypes(class_2338 pos) {
        return this.getBlightsOfPos(pos).size() >= BlightType.CACHED_VALUES.length;
    }

    public boolean isChunkCompletelyBlighted(BlightType ... var1);

    public boolean contains(BlightType ... var1);

    public void clear(boolean var1, boolean var2, boolean var3);

    public void clear(BlightType ... var1);

    public void clearPos(class_2338 var1, Set<BlightType> var2);

    public boolean isEmpty();

    public void markDirty();

    default public void sync() {
        NeMuelchComponents.BLIGHT_CHUNK.sync((Object)this.getProvider());
    }

    public static double getNormalizedPortionOfChunk(class_2791 chunk, int blocks) {
        int maxChunkBlockCount = chunk.method_31605() * 16 * 16;
        return class_3532.method_15350((double)blocks, (double)0.0, (double)maxChunkBlockCount) / (double)maxChunkBlockCount;
    }

    public static boolean isSameChunk(class_2338 originPos, class_2338 otherPos) {
        return originPos.method_10263() >> 4 == otherPos.method_10263() >> 4 && originPos.method_10260() >> 4 == otherPos.method_10260() >> 4;
    }
}

