/*
 * Decompiled with CFR 0.152.
 */
package net.shirojr.nemuelch.compat.cca.component;

import dev.onyxstudios.cca.api.v3.component.Component;
import dev.onyxstudios.cca.api.v3.component.sync.AutoSyncedComponent;
import dev.onyxstudios.cca.api.v3.component.tick.CommonTickingComponent;
import java.util.Locale;
import java.util.Set;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3542;
import net.shirojr.nemuelch.NeMuelch;
import net.shirojr.nemuelch.compat.cca.NeMuelchComponents;
import net.shirojr.nemuelch.compat.cca.util.BlightType;

public interface BlightEntityComponent
extends Component,
AutoSyncedComponent,
CommonTickingComponent {
    public static final class_2960 KEY = NeMuelch.getId("blight_entity");

    public static BlightEntityComponent get(class_1309 provider) {
        return (BlightEntityComponent)NeMuelchComponents.BLIGHT_ENTITY.get((Object)provider);
    }

    public class_1309 getProvider();

    public Severity getSeverity(BlightType var1);

    public void setSeverity(BlightType var1, Severity var2, boolean var3, boolean var4);

    public void clearSeverities(boolean var1);

    public boolean isEmpty();

    default public void sync() {
        if (!(this.getProvider().method_37908() instanceof class_3218)) {
            return;
        }
        NeMuelchComponents.BLIGHT_ENTITY.sync((Object)this.getProvider());
    }

    public static enum Severity implements class_3542
    {
        NONE(0, 0),
        LOW(80, 0),
        MEDIUM(2000, 1),
        HIGH(20000, 3);

        private final int effectDuration;
        private final int effectAmplifier;

        private Severity(int effectDuration, int effectAmplifier) {
            this.effectDuration = effectDuration;
            this.effectAmplifier = effectAmplifier;
        }

        public void onApplied(class_1309 target, Set<BlightType> types) {
            for (BlightType type : types) {
                if (type.getEffect() == null) continue;
                target.method_6092(new class_1293(type.getEffect(), this.getEffectDuration(), this.getEffectAmplifier(), true, true));
            }
            if (target instanceof class_1657) {
                class_1657 player = (class_1657)target;
                class_1661 inventory = player.method_31548();
                for (int i = 0; i < inventory.method_5439(); ++i) {
                    class_1799 stack = inventory.method_5438(i);
                    if (stack.method_7960()) continue;
                    BlightType.applyToStack(stack, types);
                }
            }
        }

        public void onCleared(class_1309 target, Set<BlightType> types) {
        }

        public int getEffectDuration() {
            return this.effectDuration;
        }

        public int getEffectAmplifier() {
            return this.effectAmplifier;
        }

        public String method_15434() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public static Severity fromString(String name) {
            for (Severity entry : Severity.values()) {
                if (!entry.method_15434().equals(name.toLowerCase(Locale.ROOT))) continue;
                return entry;
            }
            throw new IllegalStateException("No such Blight Severity: " + name);
        }
    }
}

