/*
 * Decompiled with CFR 0.152.
 */
package net.shirojr.nemuelch.compat.cca.component;

import dev.onyxstudios.cca.api.v3.component.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1937;
import net.minecraft.class_269;
import net.minecraft.class_2960;
import net.minecraft.class_5819;
import net.shirojr.nemuelch.NeMuelch;
import net.shirojr.nemuelch.compat.cca.NeMuelchComponents;
import net.shirojr.nemuelch.compat.cca.util.RespawnLocation;
import org.jetbrains.annotations.Nullable;

public interface RespawnLocationsComponent
extends Component {
    public static final class_2960 KEY = NeMuelch.getId("respawn_locations");

    public static RespawnLocationsComponent get(class_1937 world) {
        return RespawnLocationsComponent.get(world.method_8428());
    }

    public static RespawnLocationsComponent get(class_269 scoreboard) {
        return (RespawnLocationsComponent)NeMuelchComponents.RESPAWN_LOCATIONS.get((Object)scoreboard);
    }

    public Map<class_2960, RespawnLocation> getLocations();

    @Nullable
    public class_2960 getLastLocation();

    public void setLastLocation(@Nullable class_2960 var1);

    default public Set<UUID> getAssigned(class_2960 location) {
        RespawnLocation respawnLocation = this.getLocations().get(location);
        if (respawnLocation == null) {
            return Set.of();
        }
        return Collections.unmodifiableSet(respawnLocation.assignedEntities());
    }

    default public Set<UUID> getAssigned(RespawnLocation location) {
        return this.getAssigned(location.identifier());
    }

    default public Set<RespawnLocation> getAssigned(UUID uuid) {
        HashSet<RespawnLocation> locations = new HashSet<RespawnLocation>();
        for (Map.Entry<class_2960, RespawnLocation> entry : this.getLocations().entrySet()) {
            if (!entry.getValue().assignedEntities().contains(uuid)) continue;
            locations.add(entry.getValue());
        }
        return locations;
    }

    @Nullable
    default public RespawnLocation chooseRandomRespawnLocation(class_5819 random, UUID uuid, boolean excludePrevious) {
        ArrayList<RespawnLocation> choosableLocations = new ArrayList<RespawnLocation>();
        for (RespawnLocation location : this.getLocations().values()) {
            if (!location.assignedEntities().contains(uuid) || excludePrevious && this.getLastLocation() != null && location.identifier().equals((Object)this.getLastLocation())) continue;
            choosableLocations.add(location);
        }
        if (choosableLocations.isEmpty()) {
            this.setLastLocation(null);
            return null;
        }
        RespawnLocation selectedLocation = (RespawnLocation)choosableLocations.get(random.method_43048(choosableLocations.size()));
        this.setLastLocation(selectedLocation.identifier());
        return selectedLocation;
    }

    public void add(boolean var1, RespawnLocation ... var2);

    default public void add(RespawnLocation ... locations) {
        this.add(true, locations);
    }

    public void remove(List<class_2960> var1);

    default public void remove(RespawnLocation ... locations) {
        ArrayList<class_2960> identifiers = new ArrayList<class_2960>();
        if (locations.length == 0) {
            identifiers.addAll(this.getLocations().keySet());
        }
        for (RespawnLocation location : locations) {
            identifiers.add(location.identifier());
        }
        this.remove(identifiers);
        this.sync();
    }

    public void assign(RespawnLocation var1, UUID var2);

    default public boolean assign(class_2960 identifier, UUID target) {
        RespawnLocation respawnLocation = this.getLocations().get(identifier);
        if (respawnLocation == null) {
            return false;
        }
        this.assign(respawnLocation, target);
        return true;
    }

    public void unassign(RespawnLocation var1, UUID var2);

    default public boolean unassign(class_2960 identifier, UUID target) {
        RespawnLocation respawnLocation = this.getLocations().get(identifier);
        if (respawnLocation == null) {
            return false;
        }
        this.unassign(respawnLocation, target);
        return true;
    }

    public void sync();
}

