/*
 * Decompiled with CFR 0.152.
 */
package net.shirojr.nemuelch.compat.cca.implementation;

import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.shirojr.nemuelch.compat.cca.component.BlightEntityComponent;
import net.shirojr.nemuelch.compat.cca.util.BlightType;

public class BlightEntityComponentImpl
implements BlightEntityComponent {
    private final class_1309 provider;
    private final EnumMap<BlightType, BlightEntityComponent.Severity> blights;

    public BlightEntityComponentImpl(class_1309 provider) {
        this.provider = provider;
        this.blights = new EnumMap(BlightType.class);
    }

    @Override
    public class_1309 getProvider() {
        return this.provider;
    }

    @Override
    public BlightEntityComponent.Severity getSeverity(BlightType type) {
        return this.blights.getOrDefault((Object)type, BlightEntityComponent.Severity.NONE);
    }

    @Override
    public void setSeverity(BlightType type, BlightEntityComponent.Severity severity, boolean disregardSeverityRanking, boolean shouldSync) {
        BlightEntityComponent.Severity existingSeverity;
        if (!disregardSeverityRanking && (existingSeverity = this.blights.get((Object)type)) != null && existingSeverity.ordinal() <= severity.ordinal()) {
            return;
        }
        this.blights.put(type, severity);
        if (shouldSync) {
            this.sync();
        }
    }

    @Override
    public void clearSeverities(boolean shouldSync) {
        this.blights.forEach((type, severity) -> severity.onCleared(this.getProvider(), Set.of(type)));
        this.blights.clear();
        if (shouldSync) {
            this.sync();
        }
    }

    @Override
    public boolean isEmpty() {
        if (this.blights.isEmpty()) {
            return true;
        }
        for (BlightEntityComponent.Severity entry : this.blights.values()) {
            if (entry == BlightEntityComponent.Severity.NONE) continue;
            return false;
        }
        return true;
    }

    public void tick() {
        class_1937 world = this.provider.method_37908();
        if (world == null) {
            return;
        }
    }

    public void readFromNbt(class_2487 tag) {
        if (tag.method_10545("EntityBlights")) {
            this.clearSeverities(false);
            class_2487 nbt = tag.method_10562("EntityBlights");
            for (String key : nbt.method_10541()) {
                BlightType type = BlightType.fromString(key);
                BlightEntityComponent.Severity severity = BlightEntityComponent.Severity.fromString(nbt.method_10558(key));
                this.setSeverity(type, severity, true, false);
            }
            this.sync();
        }
    }

    public void writeToNbt(class_2487 tag) {
        class_2487 nbt = new class_2487();
        for (Map.Entry<BlightType, BlightEntityComponent.Severity> entry : this.blights.entrySet()) {
            nbt.method_10582(entry.getKey().method_15434(), entry.getValue().method_15434());
        }
        tag.method_10566("EntityBlights", (class_2520)nbt);
    }
}

