/*
 * Decompiled with CFR 0.152.
 */
package net.shirojr.nemuelch.compat.cca.implementation;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_1309;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.shirojr.nemuelch.NeMuelch;
import net.shirojr.nemuelch.compat.cca.NeMuelchComponents;
import net.shirojr.nemuelch.compat.cca.component.GeneralMonsterComponent;
import net.shirojr.nemuelch.monster.AbstractMonsterType;
import net.shirojr.nemuelch.monster.type.DryadMonsterType;
import net.shirojr.nemuelch.monster.type.HumanMonsterType;
import net.shirojr.nemuelch.monster.type.VampireMonsterType;
import net.shirojr.nemuelch.monster.type.WerwolfMonsterType;
import org.jetbrains.annotations.Nullable;

public class GeneralMonsterComponentImpl
implements GeneralMonsterComponent {
    public static final double DOMINANCE_SUM_MARGIN = 1.0E-6;
    private final class_1309 provider;
    private final HashSet<AbstractMonsterType> monsterTypes;

    public GeneralMonsterComponentImpl(class_1309 provider) {
        this.provider = provider;
        this.monsterTypes = new HashSet();
        this.monsterTypes.add(new VampireMonsterType(provider, 1.0f, 1.0f, 1.0f));
        this.monsterTypes.add(new DryadMonsterType(provider));
        this.monsterTypes.add(new WerwolfMonsterType(provider));
        this.monsterTypes.add(new HumanMonsterType(provider));
    }

    @Override
    @Nullable
    public AbstractMonsterType getMonsterType(class_2960 identifier) {
        for (AbstractMonsterType type : this.monsterTypes) {
            if (!type.getIdentifier().equals((Object)identifier)) continue;
            return type;
        }
        return null;
    }

    @Override
    public Set<AbstractMonsterType> getActiveMonsterTypes() {
        HashSet<AbstractMonsterType> result = new HashSet<AbstractMonsterType>();
        for (AbstractMonsterType type : this.monsterTypes) {
            if (type.getDominance() <= 0.0f) continue;
            result.add(type);
        }
        return result;
    }

    @Override
    public Set<AbstractMonsterType> getDominatingMonsterTypes() {
        float highestValue = -1.0f;
        HashSet<AbstractMonsterType> result = new HashSet<AbstractMonsterType>();
        for (AbstractMonsterType entry : this.monsterTypes) {
            float dominance = entry.getDominance();
            if (dominance > highestValue) {
                highestValue = dominance;
                result.clear();
                result.add(entry);
                continue;
            }
            if (dominance != highestValue) continue;
            result.add(entry);
        }
        return result;
    }

    @Override
    public void setWithProportions(AbstractMonsterType type, float value) {
        Set<AbstractMonsterType> oldDominating = Collections.unmodifiableSet(this.getDominatingMonsterTypes());
        float valueClamped = class_3532.method_15363((float)value, (float)0.0f, (float)1.0f);
        float valueOld = type.getDominance();
        float sumOthersOld = 1.0f - valueOld;
        float remainingNew = 1.0f - valueClamped;
        for (AbstractMonsterType entry : this.monsterTypes) {
            if (entry.equals(type)) {
                entry.setDominance(valueClamped);
                continue;
            }
            float oldEntryValue = entry.getDominance();
            float redistributedEntryValue = sumOthersOld == 0.0f ? remainingNew / (float)(this.monsterTypes.size() - 1) : oldEntryValue * (remainingNew / sumOthersOld);
            entry.setDominance(redistributedEntryValue);
        }
        Set<AbstractMonsterType> newDominating = Collections.unmodifiableSet(this.getDominatingMonsterTypes());
        GeneralMonsterComponentImpl.handleDominantChanges(oldDominating, newDominating);
    }

    private static void handleDominantChanges(Set<AbstractMonsterType> oldDominating, Set<AbstractMonsterType> newDominating) {
        HashSet<AbstractMonsterType> addedDominating = new HashSet<AbstractMonsterType>(newDominating);
        addedDominating.removeAll(oldDominating);
        HashSet<AbstractMonsterType> removedDominating = new HashSet<AbstractMonsterType>(oldDominating);
        removedDominating.removeAll(newDominating);
        for (AbstractMonsterType addedEntry : addedDominating) {
            addedEntry.onMonsterTypeGainedDominance(addedEntry.getProvider());
        }
        for (AbstractMonsterType removedEntry : removedDominating) {
            removedEntry.onMonsterTypeLostDominance(removedEntry.getProvider());
        }
    }

    @Override
    public void reset() {
        for (AbstractMonsterType entry : this.monsterTypes) {
            entry.resetDominance();
        }
    }

    @Override
    public void renormalize() {
        float sum = 0.0f;
        for (AbstractMonsterType type : this.monsterTypes) {
            sum += type.getDominance();
        }
        if ((double)Math.abs(sum - 1.0f) < 1.0E-6) {
            return;
        }
        for (AbstractMonsterType entry : this.monsterTypes) {
            if (sum == 0.0f) {
                entry.setDominance(1.0f / (float)this.monsterTypes.size());
                continue;
            }
            entry.setDominance(entry.getDominance() / sum);
        }
    }

    public void serverTick() {
        if (!(this.provider.method_37908() instanceof class_3218)) {
            return;
        }
        for (AbstractMonsterType entry : this.monsterTypes) {
            entry.serverTick();
        }
    }

    public void readFromNbt(class_2487 nbt) {
        if (nbt.method_10545("monsterTypes")) {
            class_2499 nbtList = nbt.method_10554("monsterTypes", 10);
            block0: for (class_2520 nbtElement : nbtList) {
                class_2487 nbtEntry = (class_2487)nbtElement;
                if (!nbtEntry.method_10545("identifier")) {
                    NeMuelch.LOGGER.warn("monster type [{}] nbt implementation not aligned with general retrieval", (Object)nbtEntry);
                    continue;
                }
                class_2960 nbtEntryIdentifier = class_2960.method_12829((String)nbtEntry.method_10558("identifier"));
                if (nbtEntryIdentifier == null) continue;
                for (AbstractMonsterType registeredType : this.monsterTypes) {
                    if (!registeredType.getIdentifier().equals((Object)nbtEntryIdentifier)) continue;
                    registeredType.applyNbt(nbtEntry);
                    continue block0;
                }
            }
        }
    }

    public void writeToNbt(class_2487 nbt) {
        class_2499 nbtList = new class_2499();
        for (AbstractMonsterType type : this.monsterTypes) {
            nbtList.add((Object)type.asNbt());
        }
        nbt.method_10566("monsterTypes", (class_2520)nbtList);
    }

    @Override
    public void sync() {
        NeMuelchComponents.MONSTER.sync((Object)this.provider);
    }
}

