/*
 * Decompiled with CFR 0.152.
 */
package net.shirojr.nemuelch.compat.cca.util;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_5819;
import net.shirojr.nemuelch.compat.cca.component.BlightChunkComponent;
import net.shirojr.nemuelch.compat.cca.util.BlightType;
import net.shirojr.nemuelch.init.NemuelchGameRules;

public class BlightChunkSpreader {
    public static final int BORDER_SPREAD_ATTEMPTS = 4;
    private int spreadIndex = 0;
    private final BlightChunkComponent component;

    public BlightChunkSpreader(BlightChunkComponent component) {
        this.component = component;
    }

    public void spreadFromPartialChunk(class_3218 world) {
        HashSet<class_2338> spreaderPositions = this.component.getPosWithBlights(BlightType.SPREADING);
        if (spreaderPositions.isEmpty()) {
            return;
        }
        ArrayList<class_2338> posList = new ArrayList<class_2338>(spreaderPositions);
        int totalPositions = posList.size();
        int maxSpreadAttempts = Math.min(world.method_8450().method_8356(NemuelchGameRules.BLIGHT_MAX_SPREAD_ATTEMPTS), totalPositions);
        for (int i = 0; i < maxSpreadAttempts; ++i) {
            class_2338 spreaderPos = (class_2338)posList.get(this.spreadIndex % totalPositions);
            this.spreadIndex = (this.spreadIndex + 1) % totalPositions;
            EnumSet<BlightType> blights = this.component.getBlightsOfPos(spreaderPos);
            this.spreadPartial(world, spreaderPos, blights);
        }
    }

    public void spreadFromCompleteChunk(class_3218 world) {
        class_5819 random = world.method_8409();
        class_1923 chunkPos = this.component.getProvider().method_12004();
        int minX = chunkPos.method_8326();
        int maxX = chunkPos.method_8327();
        int minZ = chunkPos.method_8328();
        int maxZ = chunkPos.method_8329();
        for (int i = 0; i < 4; ++i) {
            class_2338 borderPos = this.getRandomBorderPosition(random, minX, maxX, minZ, maxZ, world);
            if (!(random.method_43057() < 0.3f)) continue;
            EnumSet<BlightType> blightsOfPos = this.component.getBlightsOfPos(borderPos);
            this.spreadCompleteChunk(world, borderPos, blightsOfPos);
        }
    }

    public class_2338 getRandomBorderPosition(class_5819 random, int minX, int maxX, int minZ, int maxZ, class_3218 world) {
        int x;
        class_2350 direction = class_2350.class_2353.field_11062.method_10183(random);
        int z = switch (direction) {
            case class_2350.field_11043 -> {
                x = minX + random.method_43048(16);
                yield minZ;
            }
            case class_2350.field_11034 -> {
                x = maxX;
                yield minZ + random.method_43048(16);
            }
            case class_2350.field_11035 -> {
                x = minX + random.method_43048(16);
                yield maxZ;
            }
            default -> {
                x = minX;
                yield minZ + random.method_43048(16);
            }
        };
        return new class_2338(x, world.method_8624(class_2902.class_2903.field_13202, x, z), z);
    }

    public void spreadPartial(class_3218 world, class_2338 pos, Set<BlightType> blights) {
        class_5819 random = world.method_8409();
        HashSet<class_2338> appliedTargetPos = new HashSet<class_2338>();
        for (class_2350 direction : class_2350.values()) {
            class_2338 neighborPos;
            if ((double)random.method_43057() >= 0.8 || !BlightChunkComponent.isSameChunk(pos, neighborPos = pos.method_10093(direction))) continue;
            this.component.addBlightsToPos(neighborPos, blights);
            appliedTargetPos.add(neighborPos);
        }
        boolean clearedSource = false;
        if ((double)random.method_43057() < 0.05) {
            this.component.clearPos(pos, Set.of());
            clearedSource = true;
        }
        for (class_2338 appliedTo : appliedTargetPos) {
            for (BlightType blight : blights) {
                blight.getActions().get().onSuccessfulSpread(world, this.component.getTimeOfFirstInitializedBlight(), pos, appliedTo, clearedSource);
            }
        }
    }

    private void spreadCompleteChunk(class_3218 world, class_2338 borderPos, EnumSet<BlightType> blights) {
        class_5819 random = world.method_8409();
        HashSet appliedTargetPos = new HashSet();
        for (class_2350 direction : class_2350.values()) {
            class_2791 targetChunk;
            class_2338 neighborPos;
            if ((double)random.method_43057() >= 0.8 || BlightChunkComponent.isSameChunk(borderPos, neighborPos = borderPos.method_10093(direction)) || (targetChunk = world.method_8402(neighborPos.method_10263() >> 4, neighborPos.method_10260() >> 4, class_2806.field_12803, false)) == null || targetChunk.method_12009() != class_2806.field_12803) continue;
            Optional<BlightChunkComponent> neighborComponent = BlightChunkComponent.maybeGet(targetChunk);
            neighborComponent.ifPresent(otherComponent -> {
                if (otherComponent.addBlightsToPos(neighborPos, blights)) {
                    appliedTargetPos.add(neighborPos);
                }
            });
        }
        for (class_2338 appliedTo : appliedTargetPos) {
            for (BlightType blight : blights) {
                blight.getActions().get().onSuccessfulSpread(world, this.component.getTimeOfFirstInitializedBlight(), borderPos, appliedTo, false);
            }
        }
        if (!appliedTargetPos.isEmpty()) {
            this.component.stopTicking();
        }
    }
}

