/*
 * Decompiled with CFR 0.152.
 */
package net.shirojr.nemuelch.entity.custom;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1743;
import net.minecraft.class_1799;
import net.minecraft.class_1804;
import net.minecraft.class_1937;
import net.minecraft.class_2379;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2743;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3542;
import net.shirojr.nemuelch.compat.cca.component.AttachableComponent;
import net.shirojr.nemuelch.entity.custom.projectile.DropPotEntity;
import net.shirojr.nemuelch.init.NeMuelchEntities;
import net.shirojr.nemuelch.init.NeMuelchItems;
import net.shirojr.nemuelch.init.NeMuelchSounds;
import net.shirojr.nemuelch.item.custom.supportItem.DropPotBlockItem;
import net.shirojr.nemuelch.network.util.NetworkIdentifiers;
import net.shirojr.nemuelch.util.EntityInteractionHitBox;
import net.shirojr.nemuelch.util.helper.AttachableHelper;
import net.shirojr.nemuelch.util.logger.LoggerUtil;
import org.apache.logging.log4j.util.TriConsumer;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class PotLauncherEntity
extends class_1297 {
    public static final float WIDTH = 2.2f;
    public static final float HEIGHT = 2.4f;
    public static final double LEASH_RELEASE_DISTANCE = 5.0;
    public static final double LEASH_RESISTANCE_FACTOR = 0.5;
    public static final int ACTIVATION_DURATION = 20;
    private static final class_2379 DEFAULT_ANGLES = new class_2379(1.0f, 0.0f, 0.0f);
    private static final class_2940<class_2379> ANGLES = class_2945.method_12791(PotLauncherEntity.class, (class_2941)class_2943.field_13316);
    private static final class_2940<class_1799> POT_SLOT = class_2945.method_12791(PotLauncherEntity.class, (class_2941)class_2943.field_13322);
    private static final class_2940<Optional<UUID>> LEASH_HOLDER = class_2945.method_12791(PotLauncherEntity.class, (class_2941)class_2943.field_13313);
    @Nullable
    private class_1799 attachedLeadItem;
    private final HashMap<InteractionHitBox, class_238> interactionBoxes = new HashMap();
    private int activationTicks;
    private int dismountCooldownTicks;

    public PotLauncherEntity(class_1299<PotLauncherEntity> dropPotEntityEntityType, class_1937 world) {
        super(dropPotEntityEntityType, world);
        this.interactionBoxes.put(InteractionHitBox.PITCH_LEVER, InteractionHitBox.PITCH_LEVER.getLocalSpace());
        this.interactionBoxes.put(InteractionHitBox.YAW_PULLER, InteractionHitBox.YAW_PULLER.getLocalSpace());
        this.interactionBoxes.put(InteractionHitBox.LOADING_AREA, InteractionHitBox.LOADING_AREA.getLocalSpace());
        this.activationTicks = -1;
        this.dismountCooldownTicks = -1;
    }

    public PotLauncherEntity(class_1937 world, class_243 pos) {
        this(NeMuelchEntities.POT_LAUNCHER, world);
        this.method_33574(pos);
    }

    public PotLauncherEntity(class_1937 world, class_243 pos, float pitch, float yaw) {
        this(world, pos);
        this.setAngles(pitch, yaw);
    }

    protected void method_5693() {
        this.field_6011.method_12784(ANGLES, (Object)DEFAULT_ANGLES);
        this.field_6011.method_12784(POT_SLOT, (Object)class_1799.field_8037);
        this.field_6011.method_12784(LEASH_HOLDER, Optional.empty());
    }

    public class_2379 getAngles() {
        return (class_2379)this.field_6011.method_12789(ANGLES);
    }

    public void setAngles(class_2379 angles) {
        this.field_6011.method_12778(ANGLES, (Object)angles);
    }

    public void setAngles(float pitch, float yaw) {
        if (pitch < 0.0f) {
            pitch = 360.0f + pitch;
        }
        if (pitch > 5.0f && pitch < 320.0f) {
            pitch = this.getAngles().method_10256();
        }
        this.setAngles(new class_2379(pitch, yaw, DEFAULT_ANGLES.method_10258()));
        LoggerUtil.devLogger("pitch: " + pitch + " | yaw: " + yaw);
    }

    public class_1799 getPotSlot() {
        return (class_1799)this.field_6011.method_12789(POT_SLOT);
    }

    public boolean setPotSlot(class_1799 stack) {
        if (!(stack.method_7909() instanceof DropPotBlockItem)) {
            return false;
        }
        this.field_6011.method_12778(POT_SLOT, (Object)stack.method_7972());
        return true;
    }

    public void clearPotSlot() {
        this.field_6011.method_12778(POT_SLOT, (Object)class_1799.field_8037);
    }

    @Nullable
    public class_1799 getAttachedLeadItem() {
        return this.attachedLeadItem;
    }

    public void setAttachedLeadItem(@Nullable class_1799 attachedLeadItem) {
        this.attachedLeadItem = attachedLeadItem;
    }

    public int getActivationTicks() {
        return this.activationTicks;
    }

    public void setActive(boolean active) {
        this.activationTicks = active ? 0 : -1;
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            for (class_3222 serverPlayerEntity : PlayerLookup.tracking((class_1297)this)) {
                class_2540 buf = PacketByteBufs.create();
                buf.method_10804(this.method_5628());
                buf.writeBoolean(active);
                ServerPlayNetworking.send((class_3222)serverPlayerEntity, (class_2960)NetworkIdentifiers.POT_LAUNCHER_ACTIVATED, (class_2540)buf);
            }
            if (active) {
                serverWorld.method_45447(null, this.method_24515(), NeMuelchSounds.LAUNCHER_LAUNCH, class_3419.field_15245);
            }
        }
    }

    public boolean isActivated() {
        return this.activationTicks != -1;
    }

    public void setActivationTicks(int activationTicks) {
        this.activationTicks = activationTicks;
    }

    public void onFinishedActivation() {
        this.spawnAndThrowEntity();
        this.setActive(false);
    }

    public int getDismountCooldownTicks() {
        return this.dismountCooldownTicks;
    }

    public void setDismountCooldownTicks(int dismountCooldownTicks) {
        this.dismountCooldownTicks = dismountCooldownTicks;
    }

    public HashMap<InteractionHitBox, class_238> getInteractionBoxes() {
        return this.interactionBoxes;
    }

    private void updatedInteractionHitBoxes() {
        float yawInRad = (float)Math.toRadians(this.getAngles().method_10257());
        for (Map.Entry<InteractionHitBox, class_238> entry : this.interactionBoxes.entrySet()) {
            entry.setValue(EntityInteractionHitBox.calculateRotatedBox(entry.getKey().getLocalSpace(), yawInRad));
        }
    }

    public void method_5865(class_1297 passenger, class_1297.class_4738 positionUpdater) {
        if (passenger instanceof class_1657) {
            class_1657 player = (class_1657)passenger;
            player.method_36456(this.getAngles().method_10257());
            player.method_5636(this.getAngles().method_10257());
        }
        super.method_5865(passenger, positionUpdater);
        if (!this.method_5626(passenger)) {
            return;
        }
        double pitchInRad = Math.toRadians(this.getAngles().method_10256());
        double yawInRad = Math.toRadians(this.getAngles().method_10257());
        float normalizedPosition = (float)this.getActivationTicks() / 20.0f;
        double distance = class_3532.method_16439((float)(normalizedPosition * normalizedPosition * normalizedPosition), (float)1.5f, (float)0.0f);
        class_243 offset = new class_243(0.0, 0.7, 0.0);
        double x = distance * Math.cos(pitchInRad) * Math.sin(yawInRad);
        double y = distance * Math.sin(pitchInRad);
        double z = -distance * Math.cos(pitchInRad) * Math.cos(yawInRad);
        class_243 newPosition = new class_243(x, y, z).method_1019(this.method_19538()).method_1019(offset);
        positionUpdater.accept(passenger, newPosition.field_1352, newPosition.field_1351, newPosition.field_1350);
    }

    public void method_5773() {
        super.method_5773();
        this.updatedInteractionHitBoxes();
        if (this.getActivationTicks() >= 0 && this.getActivationTicks() <= 20) {
            this.setActivationTicks(this.getActivationTicks() + 1);
        }
        if (this.getDismountCooldownTicks() >= 0) {
            this.setDismountCooldownTicks(this.getDismountCooldownTicks() + 1);
        }
        if (this.getActivationTicks() >= 20) {
            this.onFinishedActivation();
        }
        if (this.getDismountCooldownTicks() > 60) {
            this.setDismountCooldownTicks(-1);
        }
        class_238 entityBox = this.method_5829().method_1014(5.0);
        List entitiesInRange = this.method_37908().method_8335((class_1297)this, entityBox);
        class_1297 closestEntity = this.getClosestEntity(entitiesInRange);
        if (closestEntity == null) {
            return;
        }
        if (this.getDismountCooldownTicks() == -1) {
            class_1542 itemEntity;
            class_1657 closestPlayer;
            if (closestEntity instanceof class_1657 && PotLauncherEntity.isOnTop(this, (class_1297)(closestPlayer = (class_1657)closestEntity), 0.5)) {
                if (!this.method_37908().method_8608()) {
                    this.startRiding(closestPlayer);
                }
                this.setDismountCooldownTicks(0);
            }
            if (closestEntity instanceof class_1542 && PotLauncherEntity.isOnTop(this, (class_1297)(itemEntity = (class_1542)closestEntity), 0.5) && itemEntity.method_6983().method_7909() instanceof DropPotBlockItem) {
                if (!this.method_37908().method_8608()) {
                    this.setPotSlot(itemEntity.method_6983().method_7972());
                    itemEntity.method_31472();
                }
                this.setDismountCooldownTicks(0);
            }
        }
        if (this.getActivationTicks() == -1 && this.method_5782() && FabricLoader.getInstance().isDevelopmentEnvironment()) {
            this.setActive(true);
        }
    }

    @Nullable
    private class_1297 getClosestEntity(List<class_1297> entities) {
        if (entities.isEmpty()) {
            return null;
        }
        class_1297 closestEntity = null;
        for (class_1297 entity : entities) {
            double closestDistance;
            if (closestEntity == null) {
                closestEntity = entity;
                continue;
            }
            double distance = this.method_19538().method_1025(entity.method_19538());
            if (!(distance < (closestDistance = this.method_19538().method_1025(closestEntity.method_19538())))) continue;
            closestEntity = entity;
        }
        return closestEntity;
    }

    public class_243 method_29919() {
        return super.method_29919().method_1031(0.0, -0.5, 0.0);
    }

    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        AttachableComponent attachableComponent = AttachableComponent.get(this);
        class_1799 stack = player.method_5998(hand);
        if (stack.method_7909() instanceof class_1804 && attachableComponent.getAttachedEntity() == null) {
            if (this.method_37908() instanceof class_3218) {
                AttachableHelper.attachBoth(attachableComponent, AttachableComponent.get((class_1297)player));
                this.setAttachedLeadItem(stack.method_7972());
                stack.method_7934(1);
            }
            return class_1269.field_5812;
        }
        if (attachableComponent.getAttachedEntity() != null && attachableComponent.getAttachedEntity().method_5667().equals(player.method_5667())) {
            if (this.method_37908() instanceof class_3218) {
                AttachableHelper.detachBoth(attachableComponent, AttachableComponent.get((class_1297)player));
                if (this.getAttachedLeadItem() != null) {
                    class_1264.method_5449((class_1937)this.method_37908(), (double)this.getItemDropPosition().method_10216(), (double)this.getItemDropPosition().method_10214(), (double)this.getItemDropPosition().method_10215(), (class_1799)this.getAttachedLeadItem());
                    this.setAttachedLeadItem(null);
                }
            }
            return class_1269.field_5812;
        }
        class_243 start = player.method_33571();
        class_243 direction = player.method_5720().method_1029().method_1021(5.0);
        class_243 end = start.method_1019(direction);
        Map.Entry<InteractionHitBox, class_238> closestInteraction = null;
        double closestRange = Double.MAX_VALUE;
        for (Map.Entry<InteractionHitBox, class_238> entry : this.interactionBoxes.entrySet()) {
            class_238 worldSpaceBox = entry.getValue().method_997(this.method_19538());
            if (!worldSpaceBox.method_992(start, end).isPresent()) continue;
            double sqDistance = ((class_243)worldSpaceBox.method_992(start, end).get()).method_1025(start);
            if (closestInteraction != null && !(closestRange > sqDistance)) continue;
            closestInteraction = entry;
            closestRange = sqDistance;
        }
        if (closestInteraction == null) {
            return super.method_5688(player, hand);
        }
        if (!this.method_37908().method_8608()) {
            ((InteractionHitBox)((Object)closestInteraction.getKey())).onHit(this, player.method_5715() ? 1.0 : -1.0, 10.0f);
        }
        if (((InteractionHitBox)((Object)closestInteraction.getKey())).equals((Object)InteractionHitBox.LOADING_AREA)) {
            if (!this.hasProjectileOrEntityLoaded()) {
                if (stack.method_7960()) {
                    return this.startRiding(player) ? class_1269.field_5812 : class_1269.field_5811;
                }
                if (stack.method_7909() instanceof DropPotBlockItem && this.setPotSlot(stack)) {
                    if (player.method_7337()) {
                        this.setActive(true);
                    } else {
                        stack.method_7934(1);
                    }
                    return class_1269.field_5812;
                }
            }
            return class_1269.field_5811;
        }
        return class_1269.field_5812;
    }

    public boolean hasProjectileOrEntityLoaded() {
        return !this.getPotSlot().method_7960() || !this.method_5685().isEmpty();
    }

    private boolean startRiding(class_1657 player) {
        if (this.method_5782()) {
            return false;
        }
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            if (!this.getPotSlot().method_7960()) {
                class_1264.method_5449((class_1937)serverWorld, (double)this.getItemDropPosition().method_10216(), (double)this.getItemDropPosition().method_10214(), (double)this.getItemDropPosition().method_10215(), (class_1799)this.getPotSlot().method_7972());
                this.clearPotSlot();
            }
            return player.method_5804((class_1297)this);
        }
        return true;
    }

    public void spawnAndThrowEntity() {
        Object e;
        double spawnDistance = 2.0;
        double pitchInRad = -Math.toRadians(this.getAngles().method_10256());
        double yawInRad = Math.toRadians(this.getAngles().method_10257());
        class_243 launchPos = this.method_19538().method_1019(new class_243(spawnDistance * -Math.sin(yawInRad) * Math.cos(pitchInRad), spawnDistance * Math.sin(pitchInRad) + 2.0, spawnDistance * Math.cos(yawInRad) * Math.cos(pitchInRad)));
        class_243 direction = new class_243(-Math.cos(pitchInRad) * Math.sin(yawInRad), Math.sin(pitchInRad), Math.cos(pitchInRad) * Math.cos(yawInRad));
        if (this.method_5782() && (e = this.method_5685().get(0)) instanceof class_1657) {
            class_1657 player = (class_1657)e;
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                serverPlayer.method_5848();
                serverPlayer.method_5808(launchPos.field_1352, launchPos.field_1351, launchPos.field_1350, serverPlayer.method_36454(), serverPlayer.method_36455());
                serverPlayer.method_18799(direction.method_1021(3.0));
                if (serverPlayer.method_23668()) {
                    serverPlayer.method_23669();
                }
                serverPlayer.field_13987.method_14364((class_2596)new class_2743((class_1297)serverPlayer));
            }
        } else if (!this.getPotSlot().method_7960()) {
            DropPotEntity potEntity = new DropPotEntity(this.method_37908(), launchPos, direction.method_1021(2.0), this.getPotSlot().method_7972());
            this.method_37908().method_8649((class_1297)potEntity);
            this.clearPotSlot();
        }
        this.dismountCooldownTicks = 0;
    }

    public class_243 getItemDropPosition() {
        return this.method_19538().method_1031(0.0, (double)2.4f, 0.0);
    }

    public boolean method_5640(double distance) {
        double d = 16.0;
        return distance < (d *= 64.0 * PotLauncherEntity.method_5824()) * d;
    }

    public boolean method_30949(class_1297 other) {
        return PotLauncherEntity.canCollide(this, other);
    }

    public static boolean canCollide(class_1297 entity, class_1297 other) {
        return (other.method_30948() || other.method_5810()) && !entity.method_5794(other);
    }

    public boolean method_30948() {
        return true;
    }

    public boolean method_5863() {
        return true;
    }

    public boolean method_5698(class_1297 attacker) {
        class_1309 livingEntity;
        class_1799 stack;
        if (attacker instanceof class_1309 && (stack = (livingEntity = (class_1309)attacker).method_6047()).method_7909() instanceof class_1743) {
            class_1937 class_19372 = livingEntity.method_37908();
            if (class_19372 instanceof class_3218) {
                class_3218 serverWorld = (class_3218)class_19372;
                this.onBreak(serverWorld);
            }
            return true;
        }
        return super.method_5698(attacker);
    }

    public void onBreak(class_3218 serverWorld) {
        serverWorld.method_8396(null, this.method_24515(), class_3417.field_14675, class_3419.field_15254, 1.0f, 1.0f);
        class_1264.method_5449((class_1937)serverWorld, (double)this.getItemDropPosition().method_10216(), (double)this.getItemDropPosition().method_10214(), (double)this.getItemDropPosition().method_10215(), (class_1799)NeMuelchItems.POT_LAUNCHER.method_7854());
        this.method_31472();
    }

    protected void method_5749(class_2487 nbt) {
        class_2499 anglesNbt = nbt.method_10554("angles", 5);
        this.setAngles(anglesNbt.isEmpty() ? DEFAULT_ANGLES : new class_2379(anglesNbt));
        this.setPotSlot(class_1799.method_7915((class_2487)nbt.method_10562("pot_slot")));
        if (nbt.method_10545("leashItem")) {
            class_2487 leashItemNbt = nbt.method_10562("leashItem");
            this.setAttachedLeadItem(class_1799.method_7915((class_2487)leashItemNbt));
        }
    }

    protected void method_5652(class_2487 nbt) {
        if (!DEFAULT_ANGLES.equals((Object)this.getAngles())) {
            nbt.method_10566("angles", (class_2520)this.getAngles().method_10255());
        }
        class_2487 potSlotNbt = new class_2487();
        this.getPotSlot().method_7953(potSlotNbt);
        nbt.method_10566("loaded", (class_2520)potSlotNbt);
        if (this.getAttachedLeadItem() != null) {
            class_2487 leashItemNbt = new class_2487();
            this.getAttachedLeadItem().method_7953(leashItemNbt);
            nbt.method_10566("leashItem", (class_2520)leashItemNbt);
        }
    }

    public static boolean isOnTop(class_1297 baseEntity, class_1297 topEntity, double verticalExpand) {
        if (baseEntity.method_5626(topEntity)) {
            return false;
        }
        class_238 entityBox = baseEntity.method_5829();
        class_243 topEntityPos = topEntity.method_19538();
        boolean isVerticallyAligned = topEntityPos.field_1351 >= entityBox.field_1325 && topEntityPos.field_1351 <= entityBox.field_1325 + verticalExpand;
        boolean isHorizontallyAligned = topEntityPos.field_1352 >= entityBox.field_1323 && topEntityPos.field_1352 <= entityBox.field_1320 && topEntityPos.field_1350 >= entityBox.field_1321 && topEntityPos.field_1350 <= entityBox.field_1324;
        return isVerticallyAligned && isHorizontallyAligned;
    }

    public void method_36209() {
        super.method_36209();
        if (this.method_37908() instanceof class_3218) {
            AttachableComponent attachableComponent = AttachableComponent.get(this);
            AttachableHelper.detachBoth(attachableComponent, AttachableComponent.get(attachableComponent.getAttachedEntity()));
        }
    }

    public static enum InteractionHitBox implements class_3542
    {
        PITCH_LEVER("pitch_lever", 1.2, 0.25, 0.25, new class_243((double)0.9f, (double)0.65f, 0.5), new Vector3f(0.9882353f, 0.011764706f, 0.9254902f), (TriConsumer<PotLauncherEntity, Double, Float>)((TriConsumer)(entity, delta, angleChange) -> {
            float change = delta > 0.0 ? angleChange.floatValue() : -angleChange.floatValue();
            entity.setAngles(entity.getAngles().method_10256() + change, entity.getAngles().method_10257());
            InteractionHitBox.playSound(entity, class_3417.field_14675, 0.9f, 1.0f);
        }), true),
        YAW_PULLER("yaw_puller", 0.6, 0.25, 0.9, new class_243((double)-0.9f, (double)0.05f, 0.5), new Vector3f(0.7137255f, 0.9882353f, 0.011764706f), (TriConsumer<PotLauncherEntity, Double, Float>)((TriConsumer)(entity, delta, angleChange) -> {
            float change = delta > 0.0 ? angleChange.floatValue() : -angleChange.floatValue();
            entity.setAngles(entity.getAngles().method_10256(), entity.getAngles().method_10257() + change);
            InteractionHitBox.playSound(entity, class_3417.field_15053, 0.8f, 1.1f);
        }), true),
        LOADING_AREA("loading_area", 0.5, 0.9, 1.5, new class_243(0.0, 0.5, 0.25), new Vector3f(0.65882355f, 0.5294118f, 0.87058824f), (TriConsumer<PotLauncherEntity, Double, Float>)((TriConsumer)(entity, delta, angleChange) -> {}), false);

        private final String name;
        private final class_238 localSpace;
        private final Vector3f debugColor;
        private final TriConsumer<PotLauncherEntity, Double, Float> action;
        private final boolean scrollable;

        private InteractionHitBox(String name, double minY, double width, double height, class_243 offset, Vector3f debugColor, TriConsumer<PotLauncherEntity, Double, Float> action, boolean scrollable) {
            this.name = name;
            this.localSpace = new class_238(-width / 2.0, minY, -width / 2.0, width / 2.0, minY + height, width / 2.0).method_997(offset);
            this.debugColor = debugColor;
            this.action = action;
            this.scrollable = scrollable;
        }

        public String method_15434() {
            return this.name;
        }

        public String getName() {
            return this.method_15434();
        }

        public boolean isScrollable() {
            return this.scrollable;
        }

        public static Optional<InteractionHitBox> byName(String name) {
            return Arrays.stream(InteractionHitBox.values()).filter(box -> box.method_15434().equals(name)).findFirst();
        }

        public class_238 getLocalSpace() {
            return this.localSpace;
        }

        public Vector3f getDebugColor() {
            return this.debugColor;
        }

        public void onHit(PotLauncherEntity entity, Double delta) {
            this.onHit(entity, delta, 0.0f);
        }

        public void onHit(PotLauncherEntity entity, Double delta, float angleChange) {
            this.action.accept((Object)entity, (Object)delta, (Object)Float.valueOf(angleChange));
        }

        private static void playSound(PotLauncherEntity entity, class_3414 sound, float minPitch, float maxPitch) {
            class_1937 class_19372 = entity.method_37908();
            if (class_19372 instanceof class_3218) {
                class_3218 serverWorld = (class_3218)class_19372;
                float randomPitch = class_3532.method_16439((float)serverWorld.method_8409().method_43057(), (float)minPitch, (float)maxPitch);
                serverWorld.method_43128(null, entity.method_23317(), entity.method_23318(), entity.method_23321(), sound, class_3419.field_15254, 2.0f, randomPitch);
            }
        }
    }
}

