/*
 * Decompiled with CFR 0.152.
 */
package net.shirojr.nemuelch.item.custom.supportItem;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3542;
import net.minecraft.class_5536;
import net.shirojr.nemuelch.init.NeMuelchConfigInit;
import net.shirojr.nemuelch.init.NeMuelchTags;
import org.jetbrains.annotations.Nullable;

public class BookWrapperItem
extends class_1792 {
    public BookWrapperItem(class_1792.class_1793 settings) {
        super(settings);
    }

    public class_1269 method_7884(class_1838 context) {
        class_1799 stack = context.method_8041();
        class_2338 blockPos = context.method_8037();
        class_1657 player = context.method_8036();
        if (player == null) {
            return super.method_7884(context);
        }
        class_1937 world = player.method_37908();
        class_2680 targetState = world.method_8320(blockPos);
        if (Part.SIGIL.canEquip(stack) && targetState.method_26164(NeMuelchTags.Blocks.SIGIL_COLOR_BLOCKS)) {
            if (targetState.method_28498((class_2769)class_2741.field_12548)) {
                if (!((Boolean)targetState.method_11654((class_2769)class_2741.field_12548)).booleanValue()) {
                    return class_1269.field_5814;
                }
                if (!world.method_8608()) {
                    world.method_8501(blockPos, (class_2680)targetState.method_11657((class_2769)class_2741.field_12548, (Comparable)Boolean.valueOf(false)));
                }
            }
            if (world instanceof class_3218) {
                class_3218 serverWorld = (class_3218)world;
                Part.SIGIL.equip(serverWorld, blockPos, stack, targetState.method_26205((class_1922)world, (class_2338)blockPos).field_16011);
            }
            return class_1269.field_5812;
        }
        return class_1269.field_5814;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 stack = user.method_5998(hand);
        boolean destroy = BookWrapperItem.destroyAfterUsage(stack);
        if (SignedWrapperInfo.getContent(stack, false).isEmpty()) {
            return class_1271.method_22430((Object)stack);
        }
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            for (class_1799 storedStack : SignedWrapperInfo.getStoredStacks(stack, true)) {
                user.method_31548().method_7398(storedStack);
            }
            serverWorld.method_8396(null, user.method_24515(), class_3417.field_17481, class_3419.field_15254, 1.0f, 1.0f);
            serverWorld.method_8396(null, user.method_24515(), class_3417.field_15184, class_3419.field_15254, 1.0f, 1.0f);
            if (destroy) {
                stack.method_7934(1);
                serverWorld.method_8396(null, user.method_24515(), class_3417.field_43160, class_3419.field_15254, 1.0f, 1.0f);
                return class_1271.method_22427((Object)stack);
            }
            if (Part.SIGIL.hasPart(stack)) {
                Part.SIGIL.remove(stack);
                serverWorld.method_8396(null, user.method_24515(), class_3417.field_15194, class_3419.field_15254, 1.0f, 1.0f);
            }
        }
        return class_1271.method_22427((Object)(destroy ? class_1799.field_8037 : stack));
    }

    public boolean method_31565(class_1799 wrapperStack, class_1735 slot, class_5536 clickType, class_1657 player) {
        class_1799 contentStack = slot.method_7677();
        if (!contentStack.method_31573(NeMuelchTags.Items.BOOK_WRAPPER_CONTENT)) {
            return false;
        }
        if (SignedWrapperInfo.addContent(player.method_37908(), (class_1309)player, wrapperStack, contentStack)) {
            this.playInsertSound((class_1297)player);
            contentStack.method_7934(1);
            return true;
        }
        return super.method_31565(wrapperStack, slot, clickType, player);
    }

    public boolean allowNbtUpdateAnimation(class_1657 player, class_1268 hand, class_1799 oldStack, class_1799 newStack) {
        class_2487 oldNbt = oldStack.method_7972().method_7969();
        class_2487 newNbt = newStack.method_7972().method_7969();
        if (oldNbt != null && !oldNbt.method_10545("Sigil")) {
            return newNbt != null && newNbt.method_10545("Sigil");
        }
        return false;
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        super.method_7851(stack, world, tooltip, context);
        class_2487 nbt = stack.method_7969();
        if (nbt == null || !BookWrapperItem.showItemUsageHistory(stack)) {
            return;
        }
        List<SignedWrapperInfo> content = SignedWrapperInfo.getContent(stack, false);
        if (content.isEmpty()) {
            return;
        }
        tooltip.add((class_2561)class_2561.method_43471((String)"item.nemuelch.book_wrapper.tooltip.desc1"));
        if (world == null) {
            return;
        }
        for (int i = 0; i < Math.min(SignedWrapperInfo.MAX_LINES, content.size()); ++i) {
            SignedWrapperInfo entry = content.get(i);
            tooltip.add(entry.getOutput(world));
        }
    }

    public static boolean destroyAfterUsage(class_1799 stack) {
        return !Part.STRIP.hasPart(stack);
    }

    public static boolean showItemUsageHistory(class_1799 stack) {
        return Part.SIGIL.hasPart(stack);
    }

    private void playInsertSound(class_1297 entity) {
        entity.method_5783(class_3417.field_34376, 0.8f, 0.8f + entity.method_37908().method_8409().method_43057() * 0.4f);
    }

    public static enum Part implements class_3542
    {
        WRAPPER("wrapper", "Wrapper", class_3417.field_17481, 16639931, Set.of()),
        STRIP("wrapper_strip", "Strip", class_3417.field_15062, 3847130, Set.of(WRAPPER)),
        SIGIL("wrapper_sigil", "Sigil", class_3417.field_14640, 11546150, Set.of(WRAPPER, STRIP));

        private final String name;
        private final String nbtKey;
        private final class_3414 sound;
        private final int defaultColor;
        private final Set<Part> requiredParts;

        private Part(String name, String nbtKey, class_3414 sound, int defaultColor, Set<Part> requiredParts) {
            this.name = name;
            this.nbtKey = nbtKey;
            this.sound = sound;
            this.defaultColor = defaultColor;
            this.requiredParts = requiredParts;
        }

        public String getNbtKey() {
            return this.nbtKey;
        }

        public class_3414 getSound() {
            return this.sound;
        }

        public int getDefaultColor() {
            return this.defaultColor;
        }

        public Set<Part> getRequiredParts() {
            return this.requiredParts;
        }

        public String method_15434() {
            return this.name;
        }

        public static Part fromString(String name) {
            for (Part entry : Part.values()) {
                if (!entry.method_15434().equals(name)) continue;
                return entry;
            }
            throw new IllegalStateException("Invalid Identifier for BookWrapperItem Part recipe");
        }

        @Nullable
        public Integer getColor(class_1799 stack) {
            class_2487 nbt = stack.method_7969();
            if (nbt == null || !nbt.method_10545(this.nbtKey)) {
                return null;
            }
            return nbt.method_10550(this.nbtKey);
        }

        public void setColor(class_1799 stack, @Nullable Integer color) {
            stack.method_7948().method_10569(this.nbtKey, color == null ? this.defaultColor : color);
        }

        public void equip(class_3218 world, class_2338 pos, class_1799 stack, int color) {
            this.setColor(stack, color);
            world.method_8396(null, pos, this.sound, class_3419.field_15254, 1.0f, 1.0f);
        }

        public boolean canEquip(class_1799 stack) {
            if (this.hasPart(stack)) {
                return false;
            }
            for (Part requiredPart : this.getRequiredParts()) {
                Integer color = requiredPart.getColor(stack);
                if (color != null) continue;
                return false;
            }
            return true;
        }

        public void remove(class_1799 stack) {
            class_2487 nbt = stack.method_7969();
            if (nbt == null) {
                return;
            }
            nbt.method_10551(this.nbtKey);
        }

        public boolean hasPart(class_1799 stack) {
            class_2487 nbt = stack.method_7969();
            return nbt != null && nbt.method_10545(this.nbtKey);
        }

        @Nullable
        public Integer getBlendedColor(class_1799 bookWrapperItemStack, List<class_1769> dyeItems) {
            if (!(bookWrapperItemStack.method_7909() instanceof BookWrapperItem)) {
                return null;
            }
            int[] rgbSum = new int[3];
            int maxBrightnessSum = 0;
            int colorCount = 0;
            Integer existingColor = this.getColor(bookWrapperItemStack);
            if (existingColor != null) {
                float r = (float)(existingColor >> 16 & 0xFF) / 255.0f;
                float g = (float)(existingColor >> 8 & 0xFF) / 255.0f;
                float b = (float)(existingColor & 0xFF) / 255.0f;
                maxBrightnessSum += (int)(Math.max(r, Math.max(g, b)) * 255.0f);
                rgbSum[0] = rgbSum[0] + (int)(r * 255.0f);
                rgbSum[1] = rgbSum[1] + (int)(g * 255.0f);
                rgbSum[2] = rgbSum[2] + (int)(b * 255.0f);
                ++colorCount;
            }
            for (class_1769 dyeItem : dyeItems) {
                float[] components = dyeItem.method_7802().method_7787();
                int r = (int)(components[0] * 255.0f);
                int g = (int)(components[1] * 255.0f);
                int b = (int)(components[2] * 255.0f);
                maxBrightnessSum += Math.max(r, Math.max(g, b));
                rgbSum[0] = rgbSum[0] + r;
                rgbSum[1] = rgbSum[1] + g;
                rgbSum[2] = rgbSum[2] + b;
                ++colorCount;
            }
            if (colorCount == 0) {
                return null;
            }
            int averageR = rgbSum[0] / colorCount;
            int averageG = rgbSum[1] / colorCount;
            int averageB = rgbSum[2] / colorCount;
            float averageMaxBrightness = (float)maxBrightnessSum / (float)colorCount;
            float currentMaxComponent = Math.max(averageR, Math.max(averageG, averageB));
            averageR = (int)((float)averageR * averageMaxBrightness / currentMaxComponent);
            averageG = (int)((float)averageG * averageMaxBrightness / currentMaxComponent);
            averageB = (int)((float)averageB * averageMaxBrightness / currentMaxComponent);
            return averageR << 16 | averageG << 8 | averageB;
        }
    }

    public record SignedWrapperInfo(String source, class_1799 stack, long timeOfAddedContent) {
        public static final int MAX_LINES = NeMuelchConfigInit.CONFIG.bookWrapperItemData.getMaxTooltipLineNumber();
        public static final int STORABLE_ITEMS_AMOUNT = NeMuelchConfigInit.CONFIG.bookWrapperItemData.getMaxItemStorageAmount();

        public static void toNbt(List<SignedWrapperInfo> data, class_2487 nbt) {
            class_2499 nbtList = new class_2499();
            for (SignedWrapperInfo entry : data) {
                class_2487 entryNbt = new class_2487();
                entryNbt.method_10582("SourceName", entry.source);
                class_2487 stackNbt = new class_2487();
                entry.stack.method_7953(stackNbt);
                entryNbt.method_10566("Item", (class_2520)stackNbt);
                entryNbt.method_10544("TimeOfAddedContent", entry.timeOfAddedContent);
                nbtList.add((Object)entryNbt);
            }
            nbt.method_10566("BookWrapperTooltipContent", (class_2520)nbtList);
        }

        public static List<SignedWrapperInfo> fromNbt(@Nullable class_2487 nbt) {
            ArrayList<SignedWrapperInfo> signedWrapperInfos = new ArrayList<SignedWrapperInfo>();
            if (nbt == null || !nbt.method_10545("BookWrapperTooltipContent")) {
                return signedWrapperInfos;
            }
            for (class_2520 nbtElement : nbt.method_10554("BookWrapperTooltipContent", 10)) {
                class_2487 entryNbt = (class_2487)nbtElement;
                String playerName = entryNbt.method_10558("SourceName");
                class_1799 content = class_1799.method_7915((class_2487)entryNbt.method_10562("Item"));
                long timeOfAddedContent = entryNbt.method_10537("TimeOfAddedContent");
                signedWrapperInfos.add(new SignedWrapperInfo(playerName, content, timeOfAddedContent));
            }
            return signedWrapperInfos;
        }

        public class_2561 getOutput(class_1937 world) {
            Object output = "From %s - %s".formatted(this.source, this.stack.method_7964().getString());
            if (NeMuelchConfigInit.CONFIG.bookWrapperItemData.showsInsertionTime()) {
                long days;
                long hours;
                long minutes;
                long seconds = (world.method_8510() - this.timeOfAddedContent) / 20L;
                String formattedTime = seconds < 60L ? seconds + " seconds" : ((minutes = seconds / 60L) < 60L ? minutes + " minute" + (minutes != 1L ? "s" : "") : ((hours = minutes / 60L) < 24L ? hours + " hour" + (hours != 1L ? "s" : "") : days + " day" + ((days = hours / 24L) != 1L ? "s" : "")));
                output = (String)output + " - %s ago".formatted(formattedTime);
            }
            return class_2561.method_43470((String)output);
        }

        public static boolean addContent(class_1937 world, class_1309 source, class_1799 wrapperStack, class_1799 contentStack) {
            ArrayList<SignedWrapperInfo> signedWrapperInfoList = new ArrayList<SignedWrapperInfo>();
            class_2487 nbt = wrapperStack.method_7969();
            if (nbt != null && nbt.method_10545("BookWrapperTooltipContent")) {
                signedWrapperInfoList.addAll(SignedWrapperInfo.fromNbt(nbt));
            }
            if (signedWrapperInfoList.size() >= STORABLE_ITEMS_AMOUNT) {
                return false;
            }
            SignedWrapperInfo entry = new SignedWrapperInfo(source.method_5477().getString(), contentStack.method_46651(1), world.method_8510());
            signedWrapperInfoList.add(entry);
            SignedWrapperInfo.toNbt(signedWrapperInfoList, wrapperStack.method_7948());
            return true;
        }

        public static List<SignedWrapperInfo> getContent(class_1799 wrappedStack, boolean removeFromWrapper) {
            class_2487 nbt = wrappedStack.method_7969();
            List<SignedWrapperInfo> signedWrapperInfos = SignedWrapperInfo.fromNbt(nbt);
            if (removeFromWrapper && nbt != null) {
                nbt.method_10551("BookWrapperTooltipContent");
            }
            return signedWrapperInfos;
        }

        public static List<class_1799> getStoredStacks(class_1799 wrapperStack, boolean removeFromWrapper) {
            ArrayList<class_1799> stacks = new ArrayList<class_1799>();
            List<SignedWrapperInfo> content = SignedWrapperInfo.getContent(wrapperStack, removeFromWrapper);
            for (SignedWrapperInfo entry : content) {
                stacks.add(entry.stack.method_7972());
            }
            return stacks;
        }

        public static List<class_1799> getStoredStacks(List<SignedWrapperInfo> data) {
            ArrayList<class_1799> result = new ArrayList<class_1799>();
            for (SignedWrapperInfo entry : data) {
                result.add(entry.stack);
            }
            return result;
        }
    }
}

