/*
 * Decompiled with CFR 0.152.
 */
package net.shirojr.nemuelch.item.custom.supportItem;

import java.util.HashSet;
import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.shirojr.nemuelch.network.util.NetworkIdentifiers;
import net.shirojr.nemuelch.network.util.NetworkUtil;

public class TalismanItem
extends class_1792 {
    public static final int COOLDOWN_BETWEEN_CHARGES = 10;
    private final int maxCharges;

    public TalismanItem(class_1792.class_1793 settings, int maxCharges) {
        super(settings);
        this.maxCharges = maxCharges;
    }

    public int getMaxCharges() {
        return this.maxCharges;
    }

    public boolean allowNbtUpdateAnimation(class_1657 player, class_1268 hand, class_1799 oldStack, class_1799 newStack) {
        return false;
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        super.method_7888(stack, world, entity, slot, selected);
        if (!(world instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)world;
        if (!(entity instanceof class_1309)) {
            return;
        }
        class_1309 livingEntity = (class_1309)entity;
        class_1799 offHandStack = livingEntity.method_6079();
        if (stack != offHandStack) {
            boolean notInSlot = false;
            if (entity instanceof class_1657) {
                notInSlot = true;
            } else if (!selected) {
                notInSlot = true;
            }
            if (notInSlot) {
                class_2487 nbt = stack.method_7969();
                if (nbt == null || !nbt.method_10545("Projectiles")) {
                    return;
                }
                nbt.method_10551("Projectiles");
                return;
            }
        }
        for (class_1676 projectile2 : serverWorld.method_8390(class_1676.class, entity.method_5829().method_1014(5.0), projectile -> true)) {
            if (!this.addTargetedProjectileIfMissing(stack, projectile2)) continue;
            this.useDefensiveCharge(livingEntity, projectile2, stack);
        }
    }

    public static int getCharges(class_1799 stack) {
        if (!(stack.method_7909() instanceof TalismanItem)) {
            return -1;
        }
        class_2487 nbt = stack.method_7969();
        if (nbt == null || !nbt.method_10545("Charges")) {
            return 0;
        }
        return nbt.method_10550("Charges");
    }

    public void setCharges(class_1799 stack, int charges) {
        if (charges <= 0) {
            class_2487 nbt = stack.method_7969();
            if (nbt == null) {
                return;
            }
            nbt.method_10551("Charges");
            return;
        }
        stack.method_7948().method_10569("Charges", class_3532.method_15340((int)charges, (int)0, (int)this.maxCharges));
    }

    public static HashSet<UUID> getTargetedProjectiles(class_1799 stack) {
        HashSet<UUID> result = new HashSet<UUID>();
        class_2487 nbt = stack.method_7969();
        if (nbt == null || !nbt.method_10545("Projectiles")) {
            return result;
        }
        for (class_2520 nbtElement : nbt.method_10554("Projectiles", 8)) {
            result.add(UUID.fromString(nbtElement.method_10714()));
        }
        return result;
    }

    public static void setTargetProjectiles(class_1799 stack, HashSet<class_1676> projectiles) {
        class_2487 nbt = stack.method_7948();
        class_2499 nbtList = new class_2499();
        for (class_1676 projectile : projectiles) {
            nbtList.add((Object)class_2519.method_23256((String)projectile.method_5845()));
        }
        nbt.method_10566("Projectiles", (class_2520)nbtList);
    }

    public boolean addTargetedProjectileIfMissing(class_1799 stack, class_1676 projectile) {
        class_2487 nbt = stack.method_7948();
        class_2499 nbtList = nbt.method_10545("Projectiles") ? nbt.method_10554("Projectiles", 8) : new class_2499();
        String newProjectileUuid = projectile.method_5845();
        for (class_2520 nbtElement : nbtList) {
            String existingProjectileUuid = nbtElement.method_10714();
            if (!newProjectileUuid.equals(existingProjectileUuid)) continue;
            return false;
        }
        nbtList.add((Object)class_2519.method_23256((String)newProjectileUuid));
        nbt.method_10566("Projectiles", (class_2520)nbtList);
        return true;
    }

    public void useDefensiveCharge(class_1309 user, class_1676 projectile, class_1799 stack) {
        if (!(user.method_37908() instanceof class_3218)) {
            return;
        }
        if (user instanceof class_1657) {
            class_1657 player = (class_1657)user;
            player.method_7357().method_7906((class_1792)this, 10);
        }
        for (class_3222 serverPlayerEntity : PlayerLookup.tracking((class_1297)projectile)) {
            class_2540 buf = PacketByteBufs.create();
            NetworkUtil.writeVec3d(buf, user.method_19538().method_1031(0.0, (double)(user.method_17682() / 2.0f), 0.0));
            buf.method_10804(projectile.method_5628());
            buf.method_10793(stack);
            ServerPlayNetworking.send((class_3222)serverPlayerEntity, (class_2960)NetworkIdentifiers.TALISMAN_DISCARD_PROJECTILE, (class_2540)buf);
        }
    }
}

