/*
 * Decompiled with CFR 0.152.
 */
package net.shirojr.nemuelch.mixin;

import java.util.Optional;
import net.fabricmc.fabric.api.tag.convention.v1.ConventionalBiomeTags;
import net.minecraft.class_2256;
import net.minecraft.class_2261;
import net.minecraft.class_2302;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.shirojr.nemuelch.compat.cca.component.BlightChunkComponent;
import net.shirojr.nemuelch.compat.cca.util.BlightType;
import net.shirojr.nemuelch.init.NeMuelchConfigInit;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_2302.class})
public abstract class CropBlockMixin
extends class_2261
implements class_2256 {
    @Shadow
    public abstract int method_9829(class_2680 var1);

    @Shadow
    public abstract class_2680 method_9828(int var1);

    public CropBlockMixin(class_4970.class_2251 settings) {
        super(settings);
    }

    @Inject(method={"randomTick"}, at={@At(value="HEAD")}, cancellable=true)
    private void tickCrops(class_2680 state, class_3218 world, class_2338 pos, class_5819 random, CallbackInfo ci) {
        if (CropBlockMixin.isBlightContaminated(world, pos)) {
            int currentAge = this.method_9829(state);
            world.method_8501(pos, this.method_9828(Math.max(0, currentAge - 1)));
            ci.cancel();
            return;
        }
        if (CropBlockMixin.isFrozen(world, pos)) {
            ci.cancel();
        }
    }

    @Unique
    private static boolean isBlightContaminated(class_3218 world, class_2338 pos) {
        Optional<BlightChunkComponent> blightChunkComponent = BlightChunkComponent.maybeGet(world.method_22350(pos));
        if (blightChunkComponent.isEmpty()) {
            return false;
        }
        BlightChunkComponent component = blightChunkComponent.get();
        return component.isBlighted(pos, BlightType.CORRUPTED) || component.isBlighted(pos, BlightType.WITHERING);
    }

    @Unique
    private static boolean isFrozen(class_3218 world, class_2338 pos) {
        if (!NeMuelchConfigInit.CONFIG.frozenGroundPreventsCropBlockGrowth) {
            return false;
        }
        class_6880 cropBlockBiome = world.method_23753(pos);
        return cropBlockBiome.method_40220(ConventionalBiomeTags.CLIMATE_COLD);
    }
}

