/*
 * Decompiled with CFR 0.152.
 */
package net.shirojr.nemuelch.monster;

import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.shirojr.nemuelch.compat.cca.component.GeneralMonsterComponent;
import net.shirojr.nemuelch.monster.AbstractMonsterType;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractMonsterAbilities {
    protected final AbstractMonsterType monsterType;
    protected final class_1309 self;
    private boolean isNightBuffer;

    public AbstractMonsterAbilities(AbstractMonsterType monsterType) {
        this.monsterType = monsterType;
        this.self = this.monsterType.getProvider();
        this.isNightBuffer = this.self.method_37908().method_23886();
    }

    public class_1309 getSelf() {
        return this.self;
    }

    public AbstractMonsterType getMonsterType() {
        return this.monsterType;
    }

    protected boolean isNotDominant() {
        GeneralMonsterComponent monsterComponent = GeneralMonsterComponent.get(this.self);
        return !monsterComponent.getDominatingMonsterTypes().contains(this.monsterType);
    }

    public final void onAttackOther(class_1657 self, class_1937 world, class_1268 hand, class_1297 target, @Nullable class_3966 hitResult) {
        if (this.isNotDominant()) {
            return;
        }
        this.doOnAttackOther(self, world, hand, target, hitResult);
    }

    public final void onKilledOther(class_1309 attacker, class_1309 victim) {
        if (this.isNotDominant()) {
            return;
        }
        this.doOnKilledOther(attacker, victim);
    }

    public final void onAttackBlock(class_1657 player, class_1937 world, class_1268 hand, class_2338 pos, class_2350 direction) {
        if (this.isNotDominant()) {
            return;
        }
        this.doOnAttackBlock(player, world, hand, pos, direction);
    }

    public final void onSteppedOn(class_3218 serverWorld, class_1309 self, class_1313 movementType, class_243 movement) {
        if (this.isNotDominant()) {
            return;
        }
        this.doOnSteppedOn(serverWorld, self, movementType, movement);
    }

    public final void onInteractBlock(class_1657 player, class_1937 world, class_1268 hand, class_3965 hitResult) {
        if (this.isNotDominant()) {
            return;
        }
        this.doOnInteractBlock(player, world, hand, hitResult);
    }

    public final void onInteractEntity(class_1657 player, class_1937 world, class_1268 hand, class_1297 target, @Nullable class_3966 hitResult) {
        if (this.isNotDominant()) {
            return;
        }
        this.doOnInteractEntity(player, world, hand, target, hitResult);
    }

    protected final void onNightfall() {
        if (this.isNotDominant()) {
            return;
        }
        this.doOnNightfall();
    }

    protected final void onDawn() {
        if (this.isNotDominant()) {
            return;
        }
        this.doOnDawn();
    }

    public final void onStartSleeping(class_2338 blockPos) {
        if (this.isNotDominant()) {
            return;
        }
        this.doOnStartSleeping(blockPos);
    }

    public final void onStopSleeping(class_2338 blockPos) {
        if (this.isNotDominant()) {
            return;
        }
        this.doOnStopSleeping(blockPos);
    }

    public final void onKeybindPressed(class_3222 player, int key) {
        if (this.isNotDominant()) {
            return;
        }
        this.doOnKeybindPressed(player, key);
    }

    public void serverTick() {
        class_1937 class_19372 = this.getSelf().method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)class_19372;
        if (serverWorld.method_23886() != this.isNightBuffer) {
            if (serverWorld.method_23886()) {
                this.onNightfall();
            } else {
                this.onDawn();
            }
            this.isNightBuffer = serverWorld.method_23886();
        }
        if (this.isNotDominant()) {
            return;
        }
        this.doOnServerTick();
    }

    protected abstract void doOnAttackOther(class_1657 var1, class_1937 var2, class_1268 var3, class_1297 var4, @Nullable class_3966 var5);

    protected abstract void doOnKilledOther(class_1309 var1, class_1309 var2);

    protected abstract void doOnAttackBlock(class_1657 var1, class_1937 var2, class_1268 var3, class_2338 var4, class_2350 var5);

    protected abstract void doOnSteppedOn(class_3218 var1, class_1309 var2, class_1313 var3, class_243 var4);

    protected abstract void doOnInteractBlock(class_1657 var1, class_1937 var2, class_1268 var3, class_3965 var4);

    protected abstract void doOnInteractEntity(class_1657 var1, class_1937 var2, class_1268 var3, class_1297 var4, @Nullable class_3966 var5);

    protected abstract void doOnNightfall();

    protected abstract void doOnDawn();

    protected abstract void doOnStartSleeping(class_2338 var1);

    protected abstract void doOnStopSleeping(class_2338 var1);

    protected abstract void doOnKeybindPressed(class_3222 var1, int var2);

    protected abstract void doOnServerTick();
}

