/*
 * Decompiled with CFR 0.152.
 */
package net.shirojr.nemuelch.monster.type;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1421;
import net.minecraft.class_1429;
import net.minecraft.class_1569;
import net.minecraft.class_1588;
import net.minecraft.class_1621;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_7923;
import net.shirojr.nemuelch.NeMuelch;
import net.shirojr.nemuelch.init.NeMuelchTags;
import net.shirojr.nemuelch.monster.AbstractMonsterAbilities;
import net.shirojr.nemuelch.monster.AbstractMonsterType;
import net.shirojr.nemuelch.monster.abilities.VampireMonsterAbilities;

public class VampireMonsterType
extends AbstractMonsterType {
    public static final class_2960 IDENTIFIER = NeMuelch.getId("vampire");
    public static final float SPECIALISATION_GAIN_FACTOR = 0.5f;
    public static final float SPECIALISATION_DECAY_OTHER_FACTOR = 0.98f;
    private float animalSpecialization;
    private float monsterSpecialization;
    private float humanoidSpecialization;
    private Rank rank;
    private int drinkCooldownTicks;

    public VampireMonsterType(class_1309 provider, float animal, float monster, float humanoid) {
        super(IDENTIFIER, provider, 0.0f);
        float total = animal + monster + humanoid;
        this.animalSpecialization = animal / total;
        this.monsterSpecialization = monster / total;
        this.humanoidSpecialization = humanoid / total;
        this.drinkCooldownTicks = 0;
    }

    @Override
    protected AbstractMonsterAbilities createAbilities() {
        return new VampireMonsterAbilities(this);
    }

    public float getAnimalSpecialization() {
        return this.animalSpecialization;
    }

    public float getMonsterSpecialization() {
        return this.monsterSpecialization;
    }

    public float getHumanoidSpecialization() {
        return this.humanoidSpecialization;
    }

    public Rank getRank() {
        return this.rank;
    }

    public void setRank(Rank rank) {
        this.rank = rank;
    }

    public SubType calculateSubType() {
        float dominant = Math.max(this.animalSpecialization, Math.max(this.monsterSpecialization, this.humanoidSpecialization));
        float specialisationThreshold = 0.5f;
        float hybridThreshold = 0.3f;
        if (dominant < specialisationThreshold) {
            return SubType.BALANCED;
        }
        if (this.animalSpecialization == dominant) {
            if (this.monsterSpecialization > this.humanoidSpecialization && this.monsterSpecialization > hybridThreshold) {
                return SubType.APEX_PREDATOR;
            }
            if (this.humanoidSpecialization > hybridThreshold) {
                return SubType.PRIMAL_MASTER;
            }
            return SubType.BEAST_LORD;
        }
        if (this.monsterSpecialization == dominant) {
            if (this.humanoidSpecialization > this.animalSpecialization && this.humanoidSpecialization > hybridThreshold) {
                return SubType.DARK_SOVEREIGN;
            }
            if (this.animalSpecialization > hybridThreshold) {
                return SubType.APEX_PREDATOR;
            }
            return SubType.SHADOW_HUNTER;
        }
        if (this.monsterSpecialization > this.animalSpecialization && this.monsterSpecialization > hybridThreshold) {
            return SubType.DARK_SOVEREIGN;
        }
        if (this.animalSpecialization > hybridThreshold) {
            return SubType.PRIMAL_MASTER;
        }
        return SubType.BLOOD_NOBLE;
    }

    public float calculateSpecialisationGain(BloodSource source, float yield) {
        float baseGain = yield * 0.5f;
        float dominantSpecialisation = switch (source.ordinal()) {
            case 0 -> this.getAnimalSpecialization();
            case 1 -> this.getMonsterSpecialization();
            default -> this.getHumanoidSpecialization();
        };
        float diminishingFactor = 1.0f - dominantSpecialisation * 0.5f;
        return baseGain * diminishingFactor;
    }

    public void addSpecialization(BloodSource source, float amount) {
        switch (source.ordinal()) {
            case 0: {
                this.animalSpecialization += amount;
                this.monsterSpecialization *= 0.98f;
                this.humanoidSpecialization *= 0.98f;
                break;
            }
            case 1: {
                this.monsterSpecialization += amount;
                this.animalSpecialization *= 0.98f;
                this.humanoidSpecialization *= 0.98f;
                break;
            }
            case 2: {
                this.humanoidSpecialization += amount;
                this.animalSpecialization *= 0.98f;
                this.monsterSpecialization *= 0.98f;
            }
        }
        float total = this.animalSpecialization + this.monsterSpecialization + this.humanoidSpecialization;
        this.animalSpecialization /= total;
        this.monsterSpecialization /= total;
        this.humanoidSpecialization /= total;
    }

    private int calculateSuspicion(class_1309 target, class_1937 world, BloodSource source) {
        int result = source.getSuspicion();
        if (world.method_8530()) {
            result *= 2;
        }
        List witnesses = world.method_8390(class_1309.class, target.method_5829().method_1014(16.0), entity -> entity != target && entity.method_6057((class_1297)target));
        return result += witnesses.size() * 3;
    }

    public boolean shouldTargetDie(class_1309 target, float bloodTaken) {
        float deathChance = BloodSource.get(target).getDeathChance();
        float killControl = this.rank.getKillControlFactor();
        float yieldMultiplier = 1.0f + bloodTaken * 2.0f;
        float finalDeathChance = Math.min(0.85f, deathChance * deathChance * yieldMultiplier);
        return this.provider.method_6051().method_43057() < finalDeathChance;
    }

    private BloodSuckResult handleAntiVampireFeedback(class_1309 target, List<String> consequences) {
        List<class_1799> targetInventory = VampireMonsterType.getTargetInventory(target);
        float severity = this.calculateAntiVampireSeverity(targetInventory);
        float rankResistance = this.getRank().getAntiVampireResistance();
        float damage = 4.0f * severity * rankResistance;
        if (!this.provider.method_37908().method_8608()) {
            this.provider.method_5643(this.provider.method_48923().method_48831(), damage);
            this.provider.method_6092(new class_1293(class_1294.field_5911, (int)(300.0f * severity), 1));
        }
        consequences.add("\u00a7cThe blessed items sear your undead flesh!");
        return new BloodSuckResult(-0.02f * severity, 0.0f, BloodSource.get(target), (int)(30.0f * severity), false, consequences);
    }

    private float calculateAntiVampireSeverity(List<class_1799> inventory) {
        float severity = 0.0f;
        List<String> bannedWords = List.of("silver", "holy", "sun", "athame", "garlic");
        block11: for (class_1799 stack : inventory) {
            if (stack.method_7960()) continue;
            class_2487 nbt = stack.method_7969();
            if (nbt != null && nbt.method_10545("anti_vampire") && nbt.method_10577("anti_vampire")) {
                severity += 2.0f;
                continue;
            }
            if (stack.method_31573(NeMuelchTags.Items.ANTI_VAMPIRE)) {
                severity += 2.0f;
                continue;
            }
            for (String bannedWord : bannedWords) {
                String itemPath = class_7923.field_41178.method_10221((Object)stack.method_7909()).method_12832();
                if (!itemPath.contains(bannedWord)) continue;
                float wordSeverity = switch (bannedWord) {
                    case "holy", "athame" -> 1.5f;
                    case "silver", "garlic", "sun" -> 1.2f;
                    default -> 1.0f;
                };
                severity += wordSeverity;
                continue block11;
            }
        }
        return Math.min(severity, 5.0f);
    }

    public BloodSuckResult attemptBloodSuck(class_1309 target) {
        ArrayList<String> consequences = new ArrayList<String>();
        List<class_1799> targetInventory = VampireMonsterType.getTargetInventory(target);
        boolean hasAntiVampireItemStacks = false;
        for (class_1799 itemStack : targetInventory) {
            if (!VampireMonsterType.containsAntiVampireProperties().test(itemStack)) continue;
            hasAntiVampireItemStacks = true;
            break;
        }
        if (hasAntiVampireItemStacks) {
            return this.handleAntiVampireFeedback(target, consequences);
        }
        BloodSource bloodSource = BloodSource.get(target);
        float baseYield = bloodSource.getBaseYield();
        return null;
    }

    private static List<class_1799> getTargetInventory(class_1309 target) {
        ArrayList<class_1799> inventory = new ArrayList<class_1799>();
        if (target instanceof class_1588) {
            class_1588 hostileTarget = (class_1588)target;
            for (class_1799 itemStack : hostileTarget.method_5743()) {
                inventory.add(itemStack);
            }
        } else if (target instanceof class_1308) {
            class_1308 mobTarget = (class_1308)target;
            for (class_1799 itemStack : mobTarget.method_5743()) {
                inventory.add(itemStack);
            }
        } else if (target instanceof class_3222) {
            class_3222 playerTarget = (class_3222)target;
            for (int i = 0; i < 9; ++i) {
                class_1799 hotbarStack = (class_1799)playerTarget.method_31548().field_7547.get(i);
                inventory.add(hotbarStack);
            }
            inventory.add(playerTarget.method_6047());
            inventory.add(playerTarget.method_6079());
            inventory.addAll((Collection<class_1799>)playerTarget.method_31548().field_7548);
        }
        return inventory;
    }

    public static Predicate<class_1799> containsAntiVampireProperties() {
        List<String> bannedWords = List.of("silver", "holy", "sun", "light", "athame", "garlic");
        return stack -> {
            if (stack.method_7960()) {
                return false;
            }
            Iterator iterator = bannedWords.iterator();
            if (iterator.hasNext()) {
                String bannedWord = (String)iterator.next();
                if (class_7923.field_41178.method_10221((Object)stack.method_7909()).method_12832().contains(bannedWord)) {
                    return true;
                }
                if (stack.method_31573(NeMuelchTags.Items.ANTI_VAMPIRE)) {
                    return true;
                }
                class_2487 nbt = stack.method_7969();
                return nbt != null && nbt.method_10545("anti_vampire") && nbt.method_10577("anti_vampire");
            }
            return false;
        };
    }

    @Override
    public void onMonsterTypeGainedDominance(class_1309 provider) {
        super.onMonsterTypeGainedDominance(provider);
        this.playSoundForProvider(class_3417.field_14845, class_3419.field_15248, provider.method_19538(), 1.0f, 0.8f);
    }

    @Override
    public void onMonsterTypeLostDominance(class_1309 provider) {
        super.onMonsterTypeLostDominance(provider);
    }

    @Override
    public void serverTick() {
        if (this.drinkCooldownTicks > 0) {
            --this.drinkCooldownTicks;
        }
    }

    @Override
    protected void writeCustomNbt(class_2487 nbt) {
    }

    @Override
    protected void readCustomNbt(class_2487 nbt) {
    }

    public static enum Rank {
        SCUM(0.05f, 15.0f, 1.5f, 1.0f),
        PEASANT(0.1f, 17.5f, 1.2f, 0.9f),
        SERVANT(0.4f, 20.0f, 1.0f, 0.7f),
        KING(0.8f, 25.0f, 0.6f, 0.5f),
        EMPEROR(0.9f, 35.0f, 0.3f, 0.3f),
        GOD(1.0f, 60.0f, 0.05f, 0.2f);

        private final float upperBloodThreshold;
        private final float damageMultiplier;
        private final float killControlFactor;
        private final float antiVampireResistance;

        private Rank(float upperBloodThreshold, float damageMultiplier, float killControlFactor, float antiVampireResistance) {
            this.upperBloodThreshold = upperBloodThreshold;
            this.damageMultiplier = damageMultiplier;
            this.killControlFactor = killControlFactor;
            this.antiVampireResistance = antiVampireResistance;
        }

        public float getUpperBloodThreshold() {
            return this.upperBloodThreshold;
        }

        public float getDamageMultiplier() {
            return this.damageMultiplier;
        }

        public float getKillControlFactor() {
            return this.killControlFactor;
        }

        public float getAntiVampireResistance() {
            return this.antiVampireResistance;
        }

        public static Rank get(float normalizedBlood) {
            Rank highestMatch = SCUM;
            while (highestMatch.getNext().upperBloodThreshold <= normalizedBlood && !(highestMatch = highestMatch.getNext()).equals((Object)GOD)) {
            }
            return highestMatch;
        }

        public Rank getBefore() {
            int indexBefore = Math.max(this.ordinal() - 1, 0);
            return Rank.values()[indexBefore];
        }

        public Rank getNext() {
            int nextIndex = Math.min(this.ordinal() + 1, Rank.values().length - 1);
            return Rank.values()[nextIndex];
        }
    }

    public static enum SubType {
        BALANCED(0.33f, 0.33f, 0.34f, "Balanced"),
        BEAST_LORD(0.7f, 0.2f, 0.1f, "Animal-focused"),
        SHADOW_HUNTER(0.2f, 0.7f, 0.1f, "Monster-focused"),
        BLOOD_NOBLE(0.1f, 0.2f, 0.7f, "Humanoid-focused"),
        APEX_PREDATOR(0.5f, 0.5f, 0.0f, "Animal/Monster hybrid"),
        DARK_SOVEREIGN(0.0f, 0.5f, 0.5f, "Monster/Humanoid hybrid"),
        PRIMAL_MASTER(0.5f, 0.0f, 0.5f, "Animal/Humanoid hybrid");

        private final float animalAffinity;
        private final float monsterAffinity;
        private final float humanoidAffinity;
        private final String description;

        private SubType(float animal, float monster, float humanoid, String description) {
            this.animalAffinity = animal;
            this.monsterAffinity = monster;
            this.humanoidAffinity = humanoid;
            this.description = description;
        }

        public float getAnimalAffinity() {
            return this.animalAffinity;
        }

        public float getMonsterAffinity() {
            return this.monsterAffinity;
        }

        public float getHumanoidAffinity() {
            return this.humanoidAffinity;
        }

        public String getDescription() {
            return this.description;
        }
    }

    public static enum BloodSource {
        ANIMAL(0.03f, 5, 0.4f, "Passive creatures"),
        MONSTER(0.08f, 2, 0.3f, "Hostile entities"),
        HUMANOID(0.1f, 25, 0.2f, "Humanoids"),
        PLAYER(0.12f, 40, 0.05f, "Players");

        private final float baseYield;
        private final int suspicion;
        private final float deathChance;
        private final String description;

        private BloodSource(float baseYield, int suspicion, float deathChance, String description) {
            this.baseYield = baseYield;
            this.suspicion = suspicion;
            this.deathChance = deathChance;
            this.description = description;
        }

        public static BloodSource get(class_1309 target) {
            if (target instanceof class_1429 || target instanceof class_1421) {
                return ANIMAL;
            }
            if (target instanceof class_1569 || target instanceof class_1621) {
                return MONSTER;
            }
            if (target instanceof class_1657) {
                return PLAYER;
            }
            return HUMANOID;
        }

        public float getBaseYield() {
            return this.baseYield;
        }

        public int getSuspicion() {
            return this.suspicion;
        }

        public float getDeathChance() {
            return this.deathChance;
        }

        public String getDescription() {
            return this.description;
        }
    }

    public record BloodSuckResult(float bloodGained, float specializationGained, BloodSource sourceType, int suspicionGained, boolean entityKilled, List<String> consequences) {
    }
}

