/*
 * Decompiled with CFR 0.152.
 */
package net.shirojr.nemuelch.render;

import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_1676;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.shirojr.nemuelch.NeMuelch;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class TalismanChargeRenderer
implements WorldRenderEvents.AfterEntities {
    private static TalismanChargeRenderer instance = null;
    private final List<Data> renderData = new ArrayList<Data>();

    public static TalismanChargeRenderer getInstance() {
        if (instance == null) {
            instance = new TalismanChargeRenderer();
        }
        return instance;
    }

    public List<Data> getRenderData() {
        return this.renderData;
    }

    public boolean inProgress(class_1676 projectile) {
        for (Data entry : this.getRenderData()) {
            if (!entry.projectile.equals((Object)projectile)) continue;
            return true;
        }
        return false;
    }

    public void afterEntities(WorldRenderContext context) {
        if (this.renderData.isEmpty()) {
            return;
        }
        for (Data entry : this.renderData) {
            float progress = entry.getProgress(context.tickDelta());
            class_243 start = entry.getUserPos();
            class_243 currentEnd = start.method_35590(entry.getProjectilePos(), (double)progress);
            TalismanChargeRenderer.renderRepeatingTexture(context.matrixStack(), context.consumers(), context.camera(), start, currentEnd);
        }
        this.renderData.removeIf(Data::isFinished);
    }

    private static void renderRepeatingTexture(class_4587 matrices, class_4597 vertexConsumers, class_4184 camera, class_243 start, class_243 end) {
        class_243 camPos = camera.method_19326();
        class_243 direction = end.method_1020(start);
        double length = direction.method_1033();
        if (length == 0.0) {
            return;
        }
        class_1921 renderLayer = class_1921.method_23580((class_2960)NeMuelch.getId("textures/misc/talisman_charge.png"));
        class_4588 buffer = vertexConsumers.getBuffer(renderLayer);
        float segmentSize = 0.25f;
        int segmentsAmount = (int)Math.ceil(length / (double)segmentSize);
        for (int i = 0; i < segmentsAmount; ++i) {
            float segmentStart = (float)i * segmentSize;
            float segmentEnd = Math.min((float)(i + 1) * segmentSize, (float)length);
            float actualSegmentLength = segmentEnd - segmentStart;
            float segmentDelta = (float)((double)segmentStart / length);
            class_243 segmentPos = start.method_35590(end, (double)segmentDelta);
            float uvCutoff = actualSegmentLength / segmentSize;
            matrices.method_22903();
            matrices.method_22904(segmentPos.method_10216() - camPos.method_10216(), segmentPos.method_10214() - camPos.method_10214(), segmentPos.method_10215() - camPos.method_10215());
            matrices.method_22907(camera.method_23767());
            Matrix4f positionMatrix = matrices.method_23760().method_23761();
            Matrix3f normalMatrix = matrices.method_23760().method_23762();
            float halfSize = segmentSize / 2.0f;
            float actualHalfSize = actualSegmentLength / 2.0f;
            buffer.method_22918(positionMatrix, -actualHalfSize, -halfSize, 0.0f).method_1336(255, 255, 255, 255).method_22913(0.0f, 1.0f).method_22922(class_4608.field_21444).method_22916(0xF000F0).method_23763(normalMatrix, 0.0f, 1.0f, 0.0f).method_1344();
            buffer.method_22918(positionMatrix, -actualHalfSize, halfSize, 0.0f).method_1336(255, 255, 255, 255).method_22913(0.0f, 0.0f).method_22922(class_4608.field_21444).method_22916(0xF000F0).method_23763(normalMatrix, 0.0f, 1.0f, 0.0f).method_1344();
            buffer.method_22918(positionMatrix, actualHalfSize, halfSize, 0.0f).method_1336(255, 255, 255, 255).method_22913(uvCutoff, 0.0f).method_22922(class_4608.field_21444).method_22916(0xF000F0).method_23763(normalMatrix, 0.0f, 1.0f, 0.0f).method_1344();
            buffer.method_22918(positionMatrix, actualHalfSize, -halfSize, 0.0f).method_1336(255, 255, 255, 255).method_22913(uvCutoff, 1.0f).method_22922(class_4608.field_21444).method_22916(0xF000F0).method_23763(normalMatrix, 0.0f, 1.0f, 0.0f).method_1344();
            matrices.method_22909();
        }
    }

    public static class Data {
        public static int CHARGE_TRAVEL_TIME = 80;
        private final class_1676 projectile;
        private final class_243 userPos;
        @Nullable
        private final class_1799 stack;
        private final int startAge;

        public Data(class_1676 projectile, class_243 userPos, @Nullable class_1799 stack) {
            this.projectile = projectile;
            this.userPos = userPos;
            this.stack = stack;
            this.startAge = projectile.field_6012;
        }

        public boolean isFinished() {
            return this.projectile.method_31481() || this.projectile.field_6012 >= this.startAge + CHARGE_TRAVEL_TIME;
        }

        public float getProgress(float tickDelta) {
            float elapsedTicks = (float)(this.projectile.field_6012 - this.startAge) + tickDelta;
            return Math.min(elapsedTicks / (float)CHARGE_TRAVEL_TIME, 1.0f);
        }

        public class_243 getProjectilePos() {
            return this.projectile.method_19538().method_1031(0.0, (double)(this.projectile.method_17682() / 2.0f), 0.0);
        }

        public class_243 getUserPos() {
            return this.userPos;
        }

        @Nullable
        public class_1799 getStack() {
            return this.stack;
        }
    }
}

