/*
 * Decompiled with CFR 0.152.
 */
package net.shirojr.nemuelch.util.helper;

import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2256;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3542;
import net.minecraft.class_4538;
import net.shirojr.nemuelch.init.NeMuelchConfigInit;
import net.shirojr.nemuelch.init.NeMuelchTags;
import net.shirojr.nemuelch.item.custom.supportItem.WateringCanItem;

public class WateringCanHelper {
    public static final String FILL_STATE_NBT_KEY = "watering_can.fillState";
    public static final String MAX_FILL_NBT_KEY = "watering_can.maxFill";
    public static final String SHOULD_FILL_NBT_KEY = "watering_can.shouldFill";

    private WateringCanHelper() {
    }

    public static void writeNbtFillState(class_1799 itemStack, int fillState) {
        itemStack.method_7948().method_10569(FILL_STATE_NBT_KEY, fillState);
    }

    public static int readNbtFillState(class_1799 itemStack) {
        if (!itemStack.method_7948().method_10545(FILL_STATE_NBT_KEY)) {
            return 0;
        }
        return itemStack.method_7948().method_10550(FILL_STATE_NBT_KEY);
    }

    public static void writeNbtMaxFill(class_1799 itemStack, int fillState) {
        itemStack.method_7948().method_10569(MAX_FILL_NBT_KEY, fillState);
    }

    public static ItemMaterial getItemMaterial(class_1799 itemStack) {
        for (ItemMaterial entry : ItemMaterial.values()) {
            WateringCanItem wateringCanItem;
            class_1792 class_17922 = itemStack.method_7909();
            if (!(class_17922 instanceof WateringCanItem) || (wateringCanItem = (WateringCanItem)class_17922).getItemMaterial() != entry) continue;
            return entry;
        }
        return ItemMaterial.COPPER;
    }

    public static boolean useOnFertilizable(class_1937 world, class_2338 pos) {
        class_2680 blockState = world.method_8320(pos);
        if (NeMuelchConfigInit.CONFIG.enableFertilizableBlockWhitelistFeature && !blockState.method_26164(NeMuelchTags.Blocks.FERTILIZABLE_WHITELIST)) {
            return false;
        }
        class_2248 class_22482 = blockState.method_26204();
        if (!(class_22482 instanceof class_2256)) {
            return false;
        }
        class_2256 fertilizable = (class_2256)class_22482;
        if (((class_2256)blockState.method_26204()).method_9651((class_4538)world, pos, blockState, world.field_9236)) {
            if (world instanceof class_3218 && fertilizable.method_9650(world, world.field_9229, pos, blockState)) {
                fertilizable.method_9652((class_3218)world, world.field_9229, pos, blockState);
            }
            return true;
        }
        return false;
    }

    public static enum ItemMaterial implements class_3542
    {
        COPPER("copper", NeMuelchConfigInit.CONFIG.wateringCan.getCopper().getCapacity(), 2),
        IRON("iron", NeMuelchConfigInit.CONFIG.wateringCan.getIron().getCapacity(), 4),
        GOLD("gold", NeMuelchConfigInit.CONFIG.wateringCan.getGold().getCapacity(), 8),
        DIAMOND("diamond", NeMuelchConfigInit.CONFIG.wateringCan.getDiamond().getCapacity(), 10);

        private final int capacity;
        private final int range;
        private final String id;

        private ItemMaterial(String id, int capacity, int range) {
            this.capacity = capacity;
            this.id = id;
            this.range = range;
        }

        public int getCapacity() {
            return this.capacity;
        }

        public int getRange() {
            return this.range;
        }

        public String method_15434() {
            return this.id;
        }
    }
}

