/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.semihardcore.command;

import com.google.common.util.concurrent.AtomicDouble;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import insane96mcp.semihardcore.capability.PlayerLifeImpl;
import insane96mcp.semihardcore.module.MaxHealth;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class SHCommand {
    public static final String COMMAND_FAIL = "semihardcore:command_fail";

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"semihardcore").requires(source -> source.m_6761_(2))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82127_((String)"optout").then(Commands.m_82129_((String)"optout", (ArgumentType)BoolArgumentType.bool()).executes(context -> SHCommand.optOut((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"player"), BoolArgumentType.getBool((CommandContext)context, (String)"optout")))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"lives").then(Commands.m_82127_((String)"get").executes(context -> SHCommand.getLives((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"player"))))).then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(context -> SHCommand.setLives((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"player"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount")))))).then(Commands.m_82127_((String)"add").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer()).then(Commands.m_82129_((String)"max", (ArgumentType)IntegerArgumentType.integer()).executes(context -> SHCommand.addLives((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"player"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount"), IntegerArgumentType.getInteger((CommandContext)context, (String)"max"))))).executes(context -> SHCommand.addLives((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"player"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount"))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"health").then(Commands.m_82127_((String)"get").executes(context -> SHCommand.getHealth((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"player"))))).then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(context -> SHCommand.setHealth((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"player"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount")))))).then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(context -> SHCommand.addHealth((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"player"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount"))))))));
    }

    private static int optOut(CommandSourceStack source, ServerPlayer targetPlayer, boolean optOut) {
        targetPlayer.getCapability(PlayerLifeImpl.INSTANCE).ifPresent(cap -> cap.setOptOut(optOut));
        source.m_288197_(() -> Component.m_237110_((String)("semihardcore:opt_" + (optOut ? "out" : "in")), (Object[])new Object[]{targetPlayer.m_7755_()}), true);
        return 1;
    }

    private static int getLives(CommandSourceStack source, ServerPlayer targetPlayer) {
        AtomicInteger lives = new AtomicInteger(0);
        targetPlayer.getCapability(PlayerLifeImpl.INSTANCE).ifPresent(cap -> lives.set(cap.getLives()));
        source.m_288197_(() -> Component.m_237110_((String)"semihardcore:player_get_lives_left", (Object[])new Object[]{targetPlayer.m_7755_(), lives}), true);
        return lives.get();
    }

    private static int setLives(CommandSourceStack source, ServerPlayer targetPlayer, int amount) {
        return SHCommand.setLives(source, targetPlayer, amount, -1);
    }

    private static int setLives(CommandSourceStack source, ServerPlayer targetPlayer, int amount, int max) {
        AtomicBoolean success = new AtomicBoolean(false);
        targetPlayer.getCapability(PlayerLifeImpl.INSTANCE).ifPresent(cap -> {
            if (max == -1) {
                cap.setLives(amount);
            } else {
                cap.setLives(amount, max);
            }
            source.m_288197_(() -> Component.m_237110_((String)"semihardcore:player_set_lives_left", (Object[])new Object[]{targetPlayer.m_7755_(), amount}), true);
            success.set(true);
        });
        if (!success.get()) {
            source.m_81352_((Component)Component.m_237115_((String)COMMAND_FAIL));
        }
        return amount;
    }

    private static int addLives(CommandSourceStack source, ServerPlayer targetPlayer, int amount) {
        return SHCommand.addLives(source, targetPlayer, amount, -1);
    }

    private static int addLives(CommandSourceStack source, ServerPlayer targetPlayer, int amount, int max) {
        AtomicBoolean success = new AtomicBoolean(false);
        targetPlayer.getCapability(PlayerLifeImpl.INSTANCE).ifPresent(cap -> {
            if (max == -1) {
                cap.addLives(amount);
            } else {
                cap.addLives(amount, max);
            }
            source.m_288197_(() -> Component.m_237110_((String)"semihardcore:player_add_lives_left", (Object[])new Object[]{amount, targetPlayer.m_7755_()}), true);
            success.set(true);
        });
        if (!success.get()) {
            source.m_81352_((Component)Component.m_237115_((String)COMMAND_FAIL));
        }
        return amount;
    }

    private static int getHealth(CommandSourceStack source, ServerPlayer targetPlayer) {
        AtomicDouble health = new AtomicDouble(0.0);
        targetPlayer.getCapability(PlayerLifeImpl.INSTANCE).ifPresent(playerLife -> health.set((double)(20.0f + playerLife.getHealthModifier())));
        MaxHealth.updateMaxHealth((Player)targetPlayer, false);
        source.m_288197_(() -> Component.m_237110_((String)"semihardcore:player_get_health", (Object[])new Object[]{targetPlayer.m_7755_(), health}), true);
        return (int)health.get();
    }

    private static int setHealth(CommandSourceStack source, ServerPlayer targetPlayer, int amount) {
        targetPlayer.getCapability(PlayerLifeImpl.INSTANCE).ifPresent(playerLife -> playerLife.setHealthModifier(amount - 20));
        MaxHealth.updateMaxHealth((Player)targetPlayer, false);
        source.m_288197_(() -> Component.m_237110_((String)"semihardcore:player_set_health", (Object[])new Object[]{targetPlayer.m_7755_(), amount}), true);
        return amount;
    }

    private static int addHealth(CommandSourceStack source, ServerPlayer targetPlayer, int amount) {
        targetPlayer.getCapability(PlayerLifeImpl.INSTANCE).ifPresent(playerLife -> playerLife.addHealthModifier(amount));
        MaxHealth.updateMaxHealth((Player)targetPlayer, true);
        source.m_288197_(() -> Component.m_237110_((String)"semihardcore:player_add_health", (Object[])new Object[]{amount, targetPlayer.m_7755_()}), true);
        return amount;
    }
}

