/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.semihardcore.module;

import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.semihardcore.SemiHardcore;
import insane96mcp.semihardcore.capability.PlayerLifeImpl;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetSubtitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitleTextPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GameType;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@LoadFeature(module="semihardcore:base")
public class Lives
extends Feature {
    @Config(min=1.0, description="How many lives players spawn with")
    public static Integer startingLives = 6;
    @Config(min=0.0, description="Max lives players can have. 0 for infinite")
    public static Integer maxLives = 0;
    @Config(description="Announce players' life lost to chat")
    public static Boolean announceLifeLostToChat = true;
    private boolean hasChangedGameRule = false;
    private double x;
    private double y;
    private double z;
    private float rotationX = 0.0f;
    private float rotationY = 0.0f;

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPlayerDeath(LivingDeathEvent event) {
        ServerPlayer player;
        block3: {
            block2: {
                LivingEntity livingEntity;
                if (!this.isEnabled() || event.getEntity().m_9236_().f_46443_ || !((livingEntity = event.getEntity()) instanceof ServerPlayer)) break block2;
                player = (ServerPlayer)livingEntity;
                if (!(event.getEntity() instanceof FakePlayer) && !event.getEntity().m_9236_().m_6106_().m_5466_() && player.f_8941_.m_9290_() != GameType.CREATIVE && player.f_8941_.m_9290_() != GameType.SPECTATOR) break block3;
            }
            return;
        }
        player.getCapability(PlayerLifeImpl.INSTANCE).ifPresent(playerLife -> {
            if (playerLife.isOptOut()) {
                return;
            }
            playerLife.addLives(-1);
            if (playerLife.getLives() <= 0) {
                player.m_9158_(player.m_9236_().m_46472_(), player.m_20183_(), player.m_146909_(), true, false);
                GameRules.BooleanValue immediateRespawn = (GameRules.BooleanValue)player.m_9236_().m_46469_().m_46170_(GameRules.f_46156_);
                if (!immediateRespawn.m_46223_()) {
                    immediateRespawn.m_46246_(true, player.m_9236_().m_7654_());
                    this.hasChangedGameRule = true;
                }
                this.x = player.m_20185_();
                this.y = player.m_20186_();
                this.z = player.m_20189_();
                this.rotationX = player.m_146909_();
                this.rotationY = player.m_146908_();
                LightningBolt lightningBolt = new LightningBolt(EntityType.f_20465_, player.m_9236_());
                lightningBolt.m_20874_(true);
                lightningBolt.m_146884_(player.m_20182_());
                player.m_9236_().m_7967_((Entity)lightningBolt);
            }
        });
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        ServerPlayer player;
        block3: {
            block2: {
                Player player2;
                if (!this.isEnabled() || event.getEntity().m_9236_().f_46443_ || !((player2 = event.getEntity()) instanceof ServerPlayer)) break block2;
                player = (ServerPlayer)player2;
                if (!event.isEndConquered() && !player.m_9236_().m_6106_().m_5466_() && player.f_8941_.m_9290_() != GameType.CREATIVE) break block3;
            }
            return;
        }
        player.getCapability(PlayerLifeImpl.INSTANCE).ifPresent(playerLife -> {
            if (playerLife.isOptOut()) {
                return;
            }
            if (playerLife.getLives() > 0 && player.f_8941_.m_9290_() != GameType.SPECTATOR) {
                player.f_8906_.m_9829_((Packet)new ClientboundSetTitleTextPacket((Component)Component.m_237115_((String)SemiHardcore.lang("life_lost"))));
                if (playerLife.getLives() > 1) {
                    player.f_8906_.m_9829_((Packet)new ClientboundSetSubtitleTextPacket((Component)Component.m_237110_((String)SemiHardcore.lang("lives_remaining"), (Object[])new Object[]{playerLife.getLives()})));
                } else {
                    player.f_8906_.m_9829_((Packet)new ClientboundSetSubtitleTextPacket((Component)Component.m_237110_((String)SemiHardcore.lang("life_remaining"), (Object[])new Object[]{playerLife.getLives()})));
                }
                if (announceLifeLostToChat.booleanValue()) {
                    player.f_8924_.m_6846_().m_240416_((Component)Component.m_237110_((String)SemiHardcore.lang("player_life_lost"), (Object[])new Object[]{player.m_5446_().getString(), playerLife.getLives()}), false);
                }
            } else {
                player.f_8906_.m_9829_((Packet)new ClientboundSetTitleTextPacket((Component)Component.m_237115_((String)SemiHardcore.lang("gg_wp"))));
                player.f_8906_.m_9829_((Packet)new ClientboundSetSubtitleTextPacket((Component)Component.m_237110_((String)SemiHardcore.lang("no_lives_remaining"), (Object[])new Object[]{playerLife.getLives()})));
                player.m_143403_(GameType.SPECTATOR);
                player.m_8999_((ServerLevel)player.m_9236_(), this.x, this.y, this.z, this.rotationY, this.rotationX);
                if (this.hasChangedGameRule) {
                    ((GameRules.BooleanValue)player.m_9236_().m_46469_().m_46170_(GameRules.f_46156_)).m_46246_(false, player.m_9236_().m_7654_());
                }
                if (announceLifeLostToChat.booleanValue()) {
                    player.f_8924_.m_6846_().m_240416_((Component)Component.m_237110_((String)SemiHardcore.lang("player_no_lives_remaining"), (Object[])new Object[]{player.m_5446_().getString(), playerLife.getLives()}), false);
                }
            }
        });
    }
}

