/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.semihardcore.module;

import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.base.config.MinMax;
import insane96mcp.insanelib.util.ModNBTData;
import insane96mcp.semihardcore.SemiHardcore;
import insane96mcp.semihardcore.capability.PlayerLifeImpl;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@LoadFeature(module="semihardcore:base")
public class MaxHealth
extends Feature {
    @Config(min=0.0, description="How much max health players spawn with")
    public static Integer startingHealth = 10;
    @Config(description="Max health lost when the player dies. Negative numbers can be used to give health to players.")
    public static Integer healthPenalty = -2;
    @Config(description="Min and max max health players can have. E.g. Setting min to -10 and max to 0 means that the player can't have less than 5 hearts and more than 10")
    public static MinMax cap = new MinMax(-18.0, 0.0);
    public static final UUID MAX_HEALTH_MODIFIER_UUID = UUID.fromString("5ee1626e-c727-4ecd-96b5-f1487896fd44");

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPlayerDeath(LivingDeathEvent event) {
        ServerPlayer player;
        block3: {
            block2: {
                LivingEntity livingEntity;
                if (!this.isEnabled() || healthPenalty == 0 || event.getEntity().m_9236_().f_46443_ || !((livingEntity = event.getEntity()) instanceof ServerPlayer)) break block2;
                player = (ServerPlayer)livingEntity;
                if (!(event.getEntity() instanceof FakePlayer) && !event.getEntity().m_9236_().m_6106_().m_5466_() && player.f_8941_.m_9294_()) break block3;
            }
            return;
        }
        player.getCapability(PlayerLifeImpl.INSTANCE).ifPresent(livesCap -> {
            if (livesCap.isOptOut()) {
                return;
            }
            livesCap.addHealthModifier(-healthPenalty.intValue());
        });
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (!this.isEnabled() || event.getEntity().m_9236_().f_46443_ || event.isEndConquered()) {
            return;
        }
        ServerPlayer player = (ServerPlayer)event.getEntity();
        MaxHealth.updateMaxHealth((Player)player, true);
    }

    @SubscribeEvent
    public void onPlayerJoin(EntityJoinLevelEvent event) {
        ServerPlayer serverPlayer;
        Entity entity;
        if (!this.isEnabled() || event.getEntity().m_9236_().f_46443_ || !((entity = event.getEntity()) instanceof ServerPlayer) || ((Boolean)ModNBTData.get((Entity)(serverPlayer = (ServerPlayer)entity), (ResourceLocation)SemiHardcore.location("starting_health_applied"), Boolean.class)).booleanValue()) {
            return;
        }
        MaxHealth.updateMaxHealth((Player)serverPlayer, false);
        ModNBTData.put((Entity)serverPlayer, (ResourceLocation)SemiHardcore.location("starting_health_applied"), (Object)true);
    }

    public static void updateMaxHealth(Player player, boolean message) {
        player.getCapability(PlayerLifeImpl.INSTANCE).ifPresent(playerLife -> {
            if (playerLife.isOptOut()) {
                return;
            }
            if (!player.m_21204_().m_22171_(Attributes.f_22276_)) {
                return;
            }
            if (player.m_21051_(Attributes.f_22276_).m_22111_(MAX_HEALTH_MODIFIER_UUID) != null) {
                player.m_21051_(Attributes.f_22276_).m_22120_(MAX_HEALTH_MODIFIER_UUID);
            }
            player.m_21051_(Attributes.f_22276_).m_22125_(new AttributeModifier(MAX_HEALTH_MODIFIER_UUID, SemiHardcore.lang("health_modifier"), (double)playerLife.getHealthModifier(), AttributeModifier.Operation.ADDITION));
            player.m_21153_(player.m_21233_());
            if (message) {
                if (healthPenalty > 0) {
                    player.m_213846_((Component)Component.m_237110_((String)SemiHardcore.lang("max_health_lost"), (Object[])new Object[]{healthPenalty}));
                } else {
                    player.m_213846_((Component)Component.m_237110_((String)SemiHardcore.lang("max_health_gained"), (Object[])new Object[]{healthPenalty * -1}));
                }
            }
        });
    }
}

