package com.herobrinemod.herobrinespringcompat;

import com.herobrinemod.herobrine.entities.InfectedEntity;
import com.herobrinemod.herobrine.savedata.ConfigHandler;
import com.herobrinemod.herobrinespringcompat.entities.*;
import com.herobrinemod.herobrinespringcompat.items.ItemList;
import de.larsensmods.stl_backport.entity.STLEntityTypes;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectors;
import net.fabricmc.fabric.api.biome.v1.ModificationPhase;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricDefaultAttributeRegistry;
import net.minecraft.class_1311;
import net.minecraft.class_1317;
import net.minecraft.class_1972;
import net.minecraft.class_2378;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_5483;
import net.minecraft.class_6862;
import net.minecraft.class_7706;
import net.minecraft.class_7924;
import net.minecraft.class_9169;

import static net.minecraft.class_7923.field_41178;

public class HerobrineSpringCompatMod implements ModInitializer {
    public static final String MODID = "herobrinespringcompat";

    @Override
    public void onInitialize() {
        registerItems();
        registerItemGroups();
        registerEntityAttributes();
        registerEntitySpawns();
    }

    private void registerItems() {
        class_2378.method_10230(field_41178, class_2960.method_60655(MODID, "cold_infected_pig_spawn_egg"), ItemList.COLD_INFECTED_PIG_SPAWN_EGG);
        class_2378.method_10230(field_41178, class_2960.method_60655(MODID, "warm_infected_pig_spawn_egg"), ItemList.WARM_INFECTED_PIG_SPAWN_EGG);
        class_2378.method_10230(field_41178, class_2960.method_60655(MODID, "cold_infected_cow_spawn_egg"), ItemList.COLD_INFECTED_COW_SPAWN_EGG);
        class_2378.method_10230(field_41178, class_2960.method_60655(MODID, "warm_infected_cow_spawn_egg"), ItemList.WARM_INFECTED_COW_SPAWN_EGG);
        class_2378.method_10230(field_41178, class_2960.method_60655(MODID, "cold_infected_chicken_spawn_egg"), ItemList.COLD_INFECTED_CHICKEN_SPAWN_EGG);
        class_2378.method_10230(field_41178, class_2960.method_60655(MODID, "warm_infected_chicken_spawn_egg"), ItemList.WARM_INFECTED_CHICKEN_SPAWN_EGG);
    }

    private void registerItemGroups() {
        ItemGroupEvents.modifyEntriesEvent(class_7706.field_40205).register(content -> content.addAfter(com.herobrinemod.herobrine.items.ItemList.INFECTED_PIG_SPAWN_EGG, ItemList.WARM_INFECTED_PIG_SPAWN_EGG));
        ItemGroupEvents.modifyEntriesEvent(class_7706.field_40205).register(content -> content.addAfter(ItemList.WARM_INFECTED_PIG_SPAWN_EGG, ItemList.COLD_INFECTED_PIG_SPAWN_EGG));
        ItemGroupEvents.modifyEntriesEvent(class_7706.field_40205).register(content -> content.addAfter(com.herobrinemod.herobrine.items.ItemList.INFECTED_COW_SPAWN_EGG, ItemList.WARM_INFECTED_COW_SPAWN_EGG));
        ItemGroupEvents.modifyEntriesEvent(class_7706.field_40205).register(content -> content.addAfter(ItemList.WARM_INFECTED_COW_SPAWN_EGG, ItemList.COLD_INFECTED_COW_SPAWN_EGG));
        ItemGroupEvents.modifyEntriesEvent(class_7706.field_40205).register(content -> content.addAfter(com.herobrinemod.herobrine.items.ItemList.INFECTED_CHICKEN_SPAWN_EGG, ItemList.WARM_INFECTED_CHICKEN_SPAWN_EGG));
        ItemGroupEvents.modifyEntriesEvent(class_7706.field_40205).register(content -> content.addAfter(ItemList.WARM_INFECTED_CHICKEN_SPAWN_EGG, ItemList.COLD_INFECTED_CHICKEN_SPAWN_EGG));
    }

    private void registerEntityAttributes() {
        FabricDefaultAttributeRegistry.register(EntityTypeList.COLD_INFECTED_PIG, ColdInfectedPigEntity.registerAttributes());
        FabricDefaultAttributeRegistry.register(EntityTypeList.WARM_INFECTED_PIG, WarmInfectedPigEntity.registerAttributes());
        FabricDefaultAttributeRegistry.register(EntityTypeList.COLD_INFECTED_COW, ColdInfectedCowEntity.registerAttributes());
        FabricDefaultAttributeRegistry.register(EntityTypeList.WARM_INFECTED_COW, WarmInfectedCowEntity.registerAttributes());
        FabricDefaultAttributeRegistry.register(EntityTypeList.COLD_INFECTED_CHICKEN, ColdInfectedChickenEntity.registerAttributes());
        FabricDefaultAttributeRegistry.register(EntityTypeList.WARM_INFECTED_CHICKEN, WarmInfectedChickenEntity.registerAttributes());
    }

    private void registerEntitySpawns() {
        BiomeModifications.create(class_2960.method_60655(MODID, "replace_warm_infected_animals")).add(ModificationPhase.ADDITIONS, BiomeSelectors.tag(class_6862.method_40092(class_7924.field_41236, class_2960.method_60655("spring_to_life", "warm_animal_biomes"))), (context) -> {
            context.getSpawnSettings().removeSpawnsOfEntityType(com.herobrinemod.herobrine.entities.EntityTypeList.INFECTED_COW);
            context.getSpawnSettings().removeSpawnsOfEntityType(com.herobrinemod.herobrine.entities.EntityTypeList.INFECTED_PIG);
            context.getSpawnSettings().removeSpawnsOfEntityType(com.herobrinemod.herobrine.entities.EntityTypeList.INFECTED_CHICKEN);
            context.getSpawnSettings().addSpawn(class_1311.field_6294, new class_5483.class_1964(EntityTypeList.WARM_INFECTED_PIG, ConfigHandler.getHerobrineConfig().readInt("InfectedMobWeight"), 3, 6));
            context.getSpawnSettings().addSpawn(class_1311.field_6294, new class_5483.class_1964(EntityTypeList.WARM_INFECTED_CHICKEN, ConfigHandler.getHerobrineConfig().readInt("InfectedMobWeight"), 4, 8));
            context.getSpawnSettings().addSpawn(class_1311.field_6294, new class_5483.class_1964(EntityTypeList.WARM_INFECTED_COW, ConfigHandler.getHerobrineConfig().readInt("InfectedMobWeight"), 2, 4));
        }).add(ModificationPhase.ADDITIONS, BiomeSelectors.includeByKey(class_1972.field_9417, class_1972.field_9440, class_1972.field_35118), (context) -> context.getSpawnSettings().addSpawn(class_1311.field_6294, new class_5483.class_1964(STLEntityTypes.WARM_CHICKEN.get(), 10, 4, 4)));
        BiomeModifications.create(class_2960.method_60655(MODID, "replace_cold_infected_animals")).add(ModificationPhase.ADDITIONS, BiomeSelectors.tag(class_6862.method_40092(class_7924.field_41236, class_2960.method_60655("spring_to_life", "cold_animal_biomes"))), (context) -> {
            context.getSpawnSettings().removeSpawnsOfEntityType(com.herobrinemod.herobrine.entities.EntityTypeList.INFECTED_COW);
            context.getSpawnSettings().removeSpawnsOfEntityType(com.herobrinemod.herobrine.entities.EntityTypeList.INFECTED_PIG);
            context.getSpawnSettings().removeSpawnsOfEntityType(com.herobrinemod.herobrine.entities.EntityTypeList.INFECTED_CHICKEN);
            context.getSpawnSettings().addSpawn(class_1311.field_6294, new class_5483.class_1964(EntityTypeList.COLD_INFECTED_PIG, ConfigHandler.getHerobrineConfig().readInt("InfectedMobWeight"), 3, 6));
            context.getSpawnSettings().addSpawn(class_1311.field_6294, new class_5483.class_1964(EntityTypeList.COLD_INFECTED_CHICKEN, ConfigHandler.getHerobrineConfig().readInt("InfectedMobWeight"), 4, 8));
            context.getSpawnSettings().addSpawn(class_1311.field_6294, new class_5483.class_1964(EntityTypeList.COLD_INFECTED_COW, ConfigHandler.getHerobrineConfig().readInt("InfectedMobWeight"), 2, 4));
        });

        class_1317.method_20637(EntityTypeList.COLD_INFECTED_PIG, class_9169.field_48745, class_2902.class_2903.field_13203, InfectedEntity::canSpawn);
        class_1317.method_20637(EntityTypeList.WARM_INFECTED_PIG, class_9169.field_48745, class_2902.class_2903.field_13203, InfectedEntity::canSpawn);
        class_1317.method_20637(EntityTypeList.COLD_INFECTED_COW, class_9169.field_48745, class_2902.class_2903.field_13203, InfectedEntity::canSpawn);
        class_1317.method_20637(EntityTypeList.WARM_INFECTED_COW, class_9169.field_48745, class_2902.class_2903.field_13203, InfectedEntity::canSpawn);
        class_1317.method_20637(EntityTypeList.COLD_INFECTED_CHICKEN, class_9169.field_48745, class_2902.class_2903.field_13203, InfectedEntity::canSpawn);
        class_1317.method_20637(EntityTypeList.WARM_INFECTED_CHICKEN, class_9169.field_48745, class_2902.class_2903.field_13203, InfectedEntity::canSpawn);
    }
}
