package com.herobrinemod.herobrinespringcompat.entities;

import com.herobrinemod.herobrine.entities.InfectedEntity;
import com.herobrinemod.herobrine.entities.SurvivorEntity;
import de.larsensmods.stl_backport.entity.STLEntityTypes;
import de.larsensmods.stl_backport.item.STLItems;
import net.minecraft.class_1282;
import net.minecraft.class_1299;
import net.minecraft.class_1347;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1400;
import net.minecraft.class_1427;
import net.minecraft.class_1543;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5712;
import net.minecraft.entity.ai.goal.*;

public class WarmInfectedChickenEntity extends InfectedEntity {
    public float flapProgress;
    public float maxWingDeviation;
    public float prevMaxWingDeviation;
    public float prevFlapProgress;
    public float flapSpeed = 1.0f;
    private float wingMovement = 1.0f;
    public int eggLayTime = this.field_5974.method_43048(6000) + 6000;

    public WarmInfectedChickenEntity(class_1299<? extends class_1588> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6194 = 3;
        this.setConversionEntity(STLEntityTypes.WARM_CHICKEN.get());
    }

    @Override
    protected void method_5959() {
        this.field_6201.method_6277(0, new class_1347(this));
        this.field_6201.method_6277(1, new class_1366(this, 1.0, false));
        this.field_6201.method_6277(2, new class_1400<>(this, class_1543.class, false));
        this.field_6201.method_6277(3, new class_1400<>(this, class_1657.class, false));
        this.field_6201.method_6277(4, new class_1400<>(this, SurvivorEntity.class, false));
        this.field_6201.method_6277(5, new class_1400<>(this, class_1427.class, false));
        this.field_6201.method_6277(6, new class_1394(this, 1.0));
        this.field_6201.method_6277(7, new class_1361(this, class_1543.class, 8.0f));
        this.field_6201.method_6277(8, new class_1361(this, class_1657.class, 8.0f));
        this.field_6201.method_6277(9, new class_1361(this, SurvivorEntity.class, 8.0f));
        this.field_6201.method_6277(10, new class_1361(this, class_1427.class, 8.0f));
        this.field_6201.method_6277(11, new class_1376(this));
    }

    public static class_5132.class_5133 registerAttributes() {
        return method_26918()
                .method_26868(class_5134.field_23716, 4.0)
                .method_26868(class_5134.field_23721, 1.0)
                .method_26868(class_5134.field_23717, 16.0)
                .method_26868(class_5134.field_23719, 0.25);
    }

    @Override
    public void method_6007() {
        super.method_6007();
        this.prevFlapProgress = this.flapProgress;
        this.prevMaxWingDeviation = this.maxWingDeviation;
        this.maxWingDeviation += (this.method_24828() ? -1.0f : 4.0f) * 0.3f;
        this.maxWingDeviation = class_3532.method_15363(this.maxWingDeviation, 0.0f, 1.0f);
        if (!this.method_24828() && this.flapSpeed < 1.0f) {
            this.flapSpeed = 1.0f;
        }

        this.flapSpeed *= 0.9f;
        class_243 vec3d = this.method_18798();
        if (!this.method_24828() && vec3d.field_1351 < 0.0) {
            this.method_18799(vec3d.method_18805(1.0, 0.6, 1.0));
        }

        this.flapProgress += this.flapSpeed * 2.0f;
        if (!this.method_37908().field_9236 && this.method_5805() && !this.method_6109() && --this.eggLayTime <= 0) {
            this.method_5783(class_3417.field_15219, 1.0f, (this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.2f + 1.0f);
            this.method_5706(STLItems.BROWN_EGG.get()); // Had re-implement the entire infected chicken just to change this. I love Java, OOP, and inheritance. It always makes sense and never has any missing features that it should have being a 30-year-old interpreted language
            this.method_32876(class_5712.field_28738);
            this.eggLayTime = this.field_5974.method_43048(6000) + 6000;
        }
    }

    @Override
    protected boolean method_5776() {
        return this.field_28627 > this.wingMovement;
    }

    @Override
    protected void method_5801() {
        this.wingMovement = this.field_28627 + this.maxWingDeviation / 2.0f;
    }

    @Override
    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.eggLayTime = nbt.method_10550("EggLayTime");
    }

    @Override
    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10569("EggLayTime", this.eggLayTime);
    }

    @Override
    protected class_3414 method_5994() {
        return class_3417.field_14871;
    }

    @Override
    protected class_3414 method_6011(class_1282 source) {
        return class_3417.field_14601;
    }

    @Override
    protected class_3414 method_6002() {
        return class_3417.field_15140;
    }

    @Override
    protected void method_5712(class_2338 pos, class_2680 state) {
        this.method_5783(class_3417.field_14685, 0.15f, 1.0f);
    }
}
