/*
 * Decompiled with CFR 0.152.
 */
package de.maxi.boatfix;

import de.maxi.boatfix.Config;
import java.lang.reflect.Field;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

@Mod(value="boatfix")
public class Boatfix {
    public static final String MOD_ID = "boatfix";
    private boolean lastUseKeyState = false;
    private boolean isEatingInBoat = false;

    public Boatfix() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)Config.SPEC);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> MinecraftForge.EVENT_BUS.register((Object)this));
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        if (!((Boolean)Config.ENABLE_BOAT_FIX.get()).booleanValue()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null || mc.f_91073_ == null || mc.f_91080_ != null) {
            return;
        }
        LocalPlayer player = mc.f_91074_;
        if (!(player.m_20202_() instanceof Boat)) {
            this.isEatingInBoat = false;
            this.lastUseKeyState = false;
            return;
        }
        boolean useKeyPressed = mc.f_91066_.f_92095_.m_90857_() || mc.f_91067_.m_91584_();
        boolean useKeyJustPressed = useKeyPressed && !this.lastUseKeyState;
        this.lastUseKeyState = useKeyPressed;
        if (!useKeyPressed && this.isEatingInBoat) {
            this.isEatingInBoat = false;
            if (player.m_6117_()) {
                player.m_5810_();
            }
            return;
        }
        if (useKeyJustPressed && this.canEat(player)) {
            this.startEatingWithKeyboardTrick(mc, player);
        }
        if (this.isEatingInBoat && useKeyPressed && !player.m_6117_() && this.canEat(player)) {
            this.continueEatingWithKeyboardTrick(mc, player);
        }
    }

    private boolean canEat(LocalPlayer player) {
        ItemStack mainHand = player.m_21205_();
        ItemStack offHand = player.m_21206_();
        return mainHand.m_41614_() || offHand.m_41614_();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startEatingWithKeyboardTrick(Minecraft mc, LocalPlayer player) {
        InteractionHand hand;
        ItemStack mainHand = player.m_21205_();
        ItemStack offHand = player.m_21206_();
        if (mainHand.m_41614_()) {
            hand = InteractionHand.MAIN_HAND;
        } else if (offHand.m_41614_()) {
            hand = InteractionHand.OFF_HAND;
        } else {
            return;
        }
        KeyMapping keyUp = mc.f_91066_.f_92085_;
        KeyMapping keyDown = mc.f_91066_.f_92087_;
        KeyMapping keyLeft = mc.f_91066_.f_92086_;
        KeyMapping keyRight = mc.f_91066_.f_92088_;
        boolean originalUp = keyUp.m_90857_();
        boolean originalDown = keyDown.m_90857_();
        boolean originalLeft = keyLeft.m_90857_();
        boolean originalRight = keyRight.m_90857_();
        try {
            this.setKeyState(keyUp, false);
            this.setKeyState(keyDown, false);
            this.setKeyState(keyLeft, false);
            this.setKeyState(keyRight, false);
            player.m_6672_(hand);
            this.isEatingInBoat = true;
        }
        finally {
            this.setKeyState(keyUp, originalUp);
            this.setKeyState(keyDown, originalDown);
            this.setKeyState(keyLeft, originalLeft);
            this.setKeyState(keyRight, originalRight);
        }
    }

    private void continueEatingWithKeyboardTrick(Minecraft mc, LocalPlayer player) {
        this.startEatingWithKeyboardTrick(mc, player);
    }

    private void setKeyState(KeyMapping key, boolean pressed) {
        try {
            Field isDownField = KeyMapping.class.getDeclaredField("isDown");
            isDownField.setAccessible(true);
            isDownField.setBoolean(key, pressed);
        }
        catch (Exception e) {
            try {
                Field clickCountField = KeyMapping.class.getDeclaredField("clickCount");
                clickCountField.setAccessible(true);
                clickCountField.setInt(key, pressed ? 1 : 0);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

