/*
 * Decompiled with CFR 0.152.
 */
package com.whyvo.chatscreen;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.logging.LogUtils;
import com.whyvo.chatscreen.chat.ChatManager;
import com.whyvo.chatscreen.chat.Person;
import com.whyvo.chatscreen.screen.ChatScreen;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.scores.Team;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;

@Mod(value="chatscreen")
public class ChatScreenMain {
    public static final String MOD_ID = "chatscreen";
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final Lazy<KeyMapping> OPEN_CHAT_SCREEN = Lazy.of(() -> new KeyMapping("key.chatscreen.open_chat_screen", InputConstants.Type.KEYSYM, 67, "key.categories.multiplayer"));
    private static final Component CHAT_SCREEN_NOT_AVAILABLE = Component.m_237115_((String)"multiplayer.chatscreen.not_available");
    private static ChatManager currentManager;
    private static Team lastTeam;
    private static boolean lastConnected;

    public static ResourceLocation modIdentifier(String path) {
        return ResourceLocation.m_214293_((String)MOD_ID, (String)path);
    }

    public ChatScreenMain(FMLJavaModLoadingContext context) {
        IEventBus modEventBus = context.getModEventBus();
        modEventBus.addListener(this::onRegisterKeyMappings);
        MinecraftForge.EVENT_BUS.addListener(this::onTick);
    }

    public ChatScreenMain(IEventBus modEventBus) {
        modEventBus.addListener(this::onRegisterKeyMappings);
        MinecraftForge.EVENT_BUS.addListener(this::onTick);
    }

    private void onRegisterKeyMappings(RegisterKeyMappingsEvent event) {
        event.register((KeyMapping)OPEN_CHAT_SCREEN.get());
    }

    private void onTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            Team team;
            Minecraft client = Minecraft.m_91087_();
            boolean connected = ChatScreenMain.canUseChatScreen(client);
            if (connected != lastConnected) {
                if (connected) {
                    ChatScreenMain.loadChatManager(client);
                } else {
                    ChatScreenMain.unloadChatManager();
                }
                lastConnected = connected;
            }
            LocalPlayer player = client.f_91074_;
            if (((KeyMapping)OPEN_CHAT_SCREEN.get()).m_90859_() && client.f_91080_ == null) {
                if (!connected) {
                    player.m_5661_(CHAT_SCREEN_NOT_AVAILABLE, true);
                } else {
                    client.m_91152_((Screen)new ChatScreen());
                }
            }
            if (connected && player != null && (team = player.m_5647_()) != lastTeam) {
                if (team == null) {
                    currentManager.removeTeamChat();
                } else {
                    currentManager.addTeamChat();
                }
                lastTeam = team;
            }
        }
    }

    private static boolean canUseChatScreen(Minecraft client) {
        return client.f_91074_ != null && (!client.m_91091_() || client.m_91092_() != null && client.m_91092_().m_6992_());
    }

    public static void loadChatManager(Minecraft client) {
        currentManager = new ChatManager();
        if (client.f_91074_ != null) {
            ChatManager.loadAllMessageType(client.f_91074_);
        }
    }

    public static void unloadChatManager() {
        currentManager = null;
        Person.clearCached();
    }

    public static ChatManager getCurrentManager() {
        return currentManager;
    }

    @Mod.EventBusSubscriber(modid="chatscreen", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            LOGGER.info("Chat Screen Initialized!");
        }
    }
}

