/*
 * Decompiled with CFR 0.152.
 */
package com.whyvo.chatscreen.chat;

import com.whyvo.chatscreen.chat.Message;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;

public abstract class Chat {
    public Component name;
    private final Deque<Message> messages;
    private final Deque<Message> newMessages;
    private boolean scrolled = false;
    public long lastMessageTime;
    private String tempMessage = null;
    public int unreadMessages = 0;
    private double scrollAmount = 0.0;
    private boolean lastScrollDown = false;

    public Chat(Component name) {
        this.name = name;
        this.messages = new ArrayDeque<Message>();
        this.newMessages = new ArrayDeque<Message>();
    }

    public void newMessage(Message message) {
        this.lastMessageTime = message.time;
        if (this.scrolled) {
            this.newMessages.addLast(message);
        } else {
            this.messages.addFirst(message);
        }
        this.tempMessage = message.getTempMessage();
    }

    public abstract boolean isGroup();

    public boolean isScrolled() {
        return this.scrolled;
    }

    public void scroll(double scrollAmount) {
        if (!this.scrolled && scrollAmount < 0.0) {
            this.lastScrollDown = false;
            return;
        }
        this.scrollAmount += scrollAmount;
        if (scrollAmount < 0.0) {
            this.lastScrollDown = true;
        } else if (scrollAmount > 0.0) {
            this.lastScrollDown = false;
        }
    }

    public boolean isLastScrollDown() {
        return this.lastScrollDown;
    }

    public int newMessagesCount() {
        return this.newMessages.size();
    }

    protected int getNameColor() {
        return -1;
    }

    public void render(GuiGraphics context, int x, int y, Font font) {
        context.m_280614_(font, this.name, x + 24, y + 5, this.getNameColor(), false);
        String tempMessage = this.tempMessage;
        if (tempMessage != null) {
            MutableComponent temp = Component.m_237113_((String)font.m_92834_(tempMessage, 66));
            context.m_280614_(font, (Component)temp, x + 24, y + 17, -1846063, false);
        }
        this.renderAvatar(context, x + 4, y + 8);
        if (this.unreadMessages > 0) {
            String unread = this.unreadMessages < 100 ? String.valueOf(this.unreadMessages) : "99+";
            int width = font.m_92895_(unread);
            context.m_280056_(font, unread, x + 20 - width, y + 3, -65536, true);
        }
    }

    public void scrollToBottom() {
        Message message;
        this.scrolled = false;
        while ((message = this.newMessages.poll()) != null) {
            this.messages.addFirst(message);
        }
        this.scrollAmount = 0.0;
        this.lastScrollDown = false;
    }

    public Message renderMessages(GuiGraphics context, int left, int top, int right, int bottom, Font font, boolean mouseIn, int mouseY) {
        int width = right - left;
        if (this.scrollAmount < 0.0) {
            if (!this.scrolled) {
                this.scrollAmount = 0.0;
            } else {
                Message message;
                while ((message = this.newMessages.poll()) != null) {
                    int h = this.estimateMessageHeight(message, font, width);
                    this.scrollAmount += (double)h;
                    this.messages.addFirst(message);
                    if (!(this.scrollAmount >= 0.0)) continue;
                    break;
                }
                if (this.scrollAmount < 0.0) {
                    this.scrollAmount = 0.0;
                }
            }
        }
        boolean bl = this.scrolled = !this.newMessages.isEmpty() || this.scrollAmount != 0.0;
        if (!this.scrolled) {
            this.lastScrollDown = false;
        }
        Message hoveredMessage = null;
        int msa = (int)this.scrollAmount;
        int yb = bottom + msa;
        for (Message message : this.messages) {
            int h = message.render(context, left, yb, bottom, right, font, this.isGroup());
            if (mouseIn && mouseY >= (yb -= h) && mouseY < yb + h) {
                hoveredMessage = message;
            }
            if (yb >= top) continue;
            break;
        }
        if ((yb -= 2) > top) {
            this.scrollAmount -= (double)(yb - top);
        }
        return hoveredMessage;
    }

    public int estimateMessageHeight(Message message, Font font, int width) {
        int contentMaxWidth = width - 28;
        List lines = font.m_92923_((FormattedText)message.content, contentMaxWidth);
        int contentHeight = lines.size() * 10;
        return contentHeight + (this.isGroup() ? 17 : 5);
    }

    public abstract void renderAvatar(GuiGraphics var1, int var2, int var3);
}

