/*
 * Decompiled with CFR 0.152.
 */
package com.whyvo.chatscreen.chat;

import com.whyvo.chatscreen.chat.Chat;
import com.whyvo.chatscreen.chat.GroupChat;
import com.whyvo.chatscreen.chat.Message;
import com.whyvo.chatscreen.chat.Person;
import com.whyvo.chatscreen.chat.PersonChat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.ToLongFunction;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.ChatType;

public class ChatManager {
    public static ChatType CHAT_TYPE;
    public static ChatType INCOMING_TYPE;
    public static ChatType OUTGOING_TYPE;
    public static ChatType TEAM_INCOMING_TYPE;
    public static ChatType TEAM_OUTGOING_TYPE;
    private static final ToLongFunction<? super PersonChat> LONG_EXTRACT;
    public final GroupChat serverChat = GroupChat.server();
    public GroupChat teamChat = null;
    public final List<PersonChat> personChats = new ArrayList<PersonChat>();
    private final Map<Person, PersonChat> personChatMap = new HashMap<Person, PersonChat>();
    private Chat selectedChat = null;

    public static void loadAllMessageType(LocalPlayer player) {
        Registry registry = player.f_108617_.m_105152_().m_175515_(Registries.f_256873_);
        CHAT_TYPE = (ChatType)registry.m_123013_(ChatType.f_130598_);
        INCOMING_TYPE = (ChatType)registry.m_123013_(ChatType.f_240674_);
        OUTGOING_TYPE = (ChatType)registry.m_123013_(ChatType.f_240668_);
        TEAM_INCOMING_TYPE = (ChatType)registry.m_123013_(ChatType.f_241694_);
        TEAM_OUTGOING_TYPE = (ChatType)registry.m_123013_(ChatType.f_241626_);
    }

    public GroupChat addTeamChat() {
        this.teamChat = GroupChat.team();
        this.selectChat(this.teamChat);
        return this.teamChat;
    }

    public void removeTeamChat() {
        if (this.selectedChat == this.teamChat) {
            this.selectedChat = null;
        }
        this.teamChat = null;
    }

    public PersonChat addPersonChat(Person person, boolean select) {
        PersonChat chat = this.personChatMap.get(person);
        if (chat == null) {
            chat = new PersonChat(person);
            chat.lastMessageTime = Instant.now().getEpochSecond();
            this.personChatMap.put(person, chat);
            this.personChats.add(chat);
            this.sortPersonChats();
        }
        if (select) {
            this.selectChat(chat);
        }
        return chat;
    }

    public void removePersonChat(PersonChat chat) {
        if (chat == this.selectedChat) {
            this.selectChat(null);
        }
        this.personChats.remove(chat);
        this.personChatMap.remove(chat.person);
    }

    public void selectChat(Chat chat) {
        this.selectedChat = chat;
        if (this.selectedChat != null) {
            this.selectedChat.unreadMessages = 0;
        }
    }

    public Chat getSelectedChat() {
        return this.selectedChat;
    }

    public void newServerMessage(Message message) {
        this.serverChat.newMessage(message);
        if (this.selectedChat != this.serverChat) {
            ++this.serverChat.unreadMessages;
        }
    }

    public void newTeamMessage(Message message) {
        if (this.teamChat == null) {
            return;
        }
        this.teamChat.newMessage(message);
        if (this.selectedChat != this.teamChat) {
            ++this.teamChat.unreadMessages;
        }
    }

    public void newPersonMessage(Person person, Message message) {
        PersonChat chat = this.personChatMap.get(person);
        if (chat == null) {
            chat = this.addPersonChat(person, false);
        }
        chat.newMessage(message);
        if (this.selectedChat != chat) {
            ++chat.unreadMessages;
        }
        this.sortPersonChats();
    }

    private void sortPersonChats() {
        this.personChats.sort((c1, c2) -> Long.compare(LONG_EXTRACT.applyAsLong((PersonChat)c2), LONG_EXTRACT.applyAsLong((PersonChat)c1)));
    }

    public boolean submitMessage(String content) {
        Minecraft client = Minecraft.m_91087_();
        Chat chat = this.selectedChat;
        if (chat == null) {
            return false;
        }
        if (!content.isEmpty()) {
            client.f_91065_.m_93076_().m_93783_(content);
            if (chat == this.serverChat) {
                client.f_91074_.f_108617_.m_246175_(content);
            } else if (chat == this.teamChat) {
                client.f_91074_.f_108617_.m_246623_("teammsg " + content);
            } else if (chat instanceof PersonChat) {
                PersonChat personChat = (PersonChat)chat;
                client.f_91074_.f_108617_.m_246623_("msg " + personChat.person.getCachedName().getString() + " " + content);
            } else {
                return false;
            }
            return true;
        }
        return false;
    }

    public List<Chat> getAllChats() {
        ArrayList<Chat> chats = new ArrayList<Chat>();
        chats.add(this.serverChat);
        if (this.teamChat != null) {
            chats.add(this.teamChat);
        }
        chats.addAll(this.personChats);
        return chats;
    }

    static {
        LONG_EXTRACT = personChat -> personChat.lastMessageTime;
    }
}

