/*
 * Decompiled with CFR 0.152.
 */
package com.whyvo.chatscreen.chat;

import com.whyvo.chatscreen.chat.Person;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;

public class Message {
    public final long time;
    public final Person sender;
    public final boolean outgoing;
    public final Component content;

    public Message(long time, Person sender, Component content) {
        this.time = time;
        this.sender = sender;
        this.outgoing = sender.isMe();
        this.content = content;
    }

    public String getTempMessage() {
        return this.content.getString();
    }

    public int render(GuiGraphics context, int left, int bottom, int screenBottom, int right, Font font, boolean group) {
        int contentMaxWidth = right - left - 40;
        List lines = font.m_92923_((FormattedText)this.content, contentMaxWidth);
        int contentHeight = lines.size() * 10;
        int fullHeight = Math.max(contentHeight + (group ? 18 : 4), 20);
        int top = bottom - fullHeight;
        if (top > screenBottom) {
            return fullHeight;
        }
        this.sender.drawAvatar(context, this.outgoing ? right - 17 : left + 1, top += 3);
        if (group) {
            Component name = this.sender.getCachedName();
            int x1 = this.outgoing ? right - 20 - font.m_92852_((FormattedText)name) : left + 20;
            context.m_280614_(font, name, x1, top, -16777216, false);
        }
        if (group) {
            top += 11;
        }
        for (FormattedCharSequence line : lines) {
            int x0 = this.outgoing ? right - 20 - font.m_92724_(line) : left + 20;
            context.m_280649_(font, line, x0, top, -1, true);
            top += 10;
        }
        return fullHeight;
    }
}

