/*
 * Decompiled with CFR 0.152.
 */
package com.whyvo.chatscreen.chat;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.PlayerFaceRenderer;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class Person {
    private static final Map<UUID, Person> cached = new HashMap<UUID, Person>();
    public final UUID uuid;
    private Component cachedName;
    private final boolean me;
    private final Supplier<ResourceLocation> skinSupplier;
    public boolean offline = false;

    public static Person of(UUID uuid) {
        Person person = cached.get(uuid);
        if (person == null) {
            person = new Person(uuid);
            cached.put(uuid, person);
        }
        return person;
    }

    public static Person tryFind(String name) {
        PlayerInfo player = Minecraft.m_91087_().f_91074_.f_108617_.m_104938_(name);
        if (player != null) {
            return Person.of(player.m_105312_().getId());
        }
        return null;
    }

    public static Person getKnownOrNull(UUID uuid) {
        return cached.get(uuid);
    }

    public static void clearCached() {
        cached.clear();
    }

    private Person(UUID uuid) {
        LocalPlayer myself = Minecraft.m_91087_().f_91074_;
        PlayerInfo playerListEntry = myself.f_108617_.m_104949_(uuid);
        if (playerListEntry == null) {
            throw new RuntimeException("No such player!");
        }
        this.uuid = uuid;
        this.me = myself.m_20148_().equals(uuid);
        this.cachedName = this.me ? myself.m_5446_() : Component.m_237113_((String)playerListEntry.m_105312_().getName());
        this.skinSupplier = () -> ((PlayerInfo)playerListEntry).m_105337_();
    }

    public Component getCachedName() {
        return this.cachedName;
    }

    public void updateName(Component name) {
        this.cachedName = name;
    }

    public boolean isMe() {
        return this.me;
    }

    public ResourceLocation getSkinTexture() {
        return this.skinSupplier.get();
    }

    public void drawAvatar(GuiGraphics context, int x, int y) {
        PlayerFaceRenderer.m_280354_((GuiGraphics)context, (ResourceLocation)this.getSkinTexture(), (int)x, (int)y, (int)16);
    }

    public int hashCode() {
        return this.uuid.hashCode();
    }
}

