/*
 * Decompiled with CFR 0.152.
 */
package com.whyvo.chatscreen.mixin;

import com.mojang.authlib.GameProfile;
import com.whyvo.chatscreen.ChatScreenMain;
import com.whyvo.chatscreen.chat.ChatManager;
import com.whyvo.chatscreen.chat.Message;
import com.whyvo.chatscreen.chat.Person;
import java.time.Instant;
import net.minecraft.client.multiplayer.chat.ChatListener;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FilterMask;
import net.minecraft.network.chat.PlayerChatMessage;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ChatListener.class})
public class MessageHandlerMixin {
    @Inject(method={"showMessageToPlayer"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/components/ChatComponent;addMessage(Lnet/minecraft/network/chat/Component;Lnet/minecraft/network/chat/MessageSignature;Lnet/minecraft/client/GuiMessageTag;)V")})
    private void injectProcessChatMessageInternal(ChatType.Bound params, PlayerChatMessage message, Component decorated, GameProfile sender, boolean onlyShowSecureChat, Instant receptionTimestamp, CallbackInfoReturnable<Boolean> cir) {
        ChatManager manager = ChatScreenMain.getCurrentManager();
        if (manager != null) {
            Component content;
            FilterMask filterMask = message.f_242992_();
            Component component = content = filterMask.m_243095_() ? message.m_245692_() : filterMask.m_246134_(message.m_245728_());
            if (content == null) {
                return;
            }
            long time = receptionTimestamp.toEpochMilli();
            ChatType type = params.f_240859_();
            Person person = Person.of(sender.getId());
            Message chatMessage = new Message(time, person, content);
            if (type == ChatManager.CHAT_TYPE) {
                manager.newServerMessage(chatMessage);
            } else if (type == ChatManager.INCOMING_TYPE) {
                manager.newPersonMessage(person, chatMessage);
            } else if (type == ChatManager.OUTGOING_TYPE) {
                String name;
                Person target;
                Component targetName = params.f_240896_();
                if (targetName != null && (target = Person.tryFind(name = targetName.getString())) != null) {
                    manager.newPersonMessage(target, chatMessage);
                }
            } else if (type == ChatManager.TEAM_INCOMING_TYPE || type == ChatManager.TEAM_OUTGOING_TYPE) {
                manager.newTeamMessage(chatMessage);
            }
        }
    }
}

