/*
 * Decompiled with CFR 0.152.
 */
package com.whyvo.chatscreen.screen;

import com.whyvo.chatscreen.ChatScreenMain;
import com.whyvo.chatscreen.chat.Chat;
import com.whyvo.chatscreen.chat.ChatManager;
import com.whyvo.chatscreen.chat.Message;
import com.whyvo.chatscreen.chat.Person;
import com.whyvo.chatscreen.chat.PersonChat;
import com.whyvo.chatscreen.screen.MyEditBoxWidget;
import com.whyvo.chatscreen.screen.rc.RCContext;
import com.whyvo.chatscreen.screen.social.MySocialInteractionsScreen;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringUtil;
import org.apache.commons.lang3.StringUtils;

public class ChatScreen
extends Screen {
    private static final ResourceLocation GUI_TEXTURE = ChatScreenMain.modIdentifier("textures/gui/chat_screen.png");
    private static final Component NO_CHAT = Component.m_237115_((String)"chat_screen.no_chat");
    private static final Component INPUT_EMPTY = Component.m_237115_((String)"chat_screen.input_empty").m_130940_(ChatFormatting.GRAY);
    private static final Component DELETE_PERSON = Component.m_237115_((String)"rc.delete_person");
    private static final Component ADD_PERSON = Component.m_237115_((String)"chat_screen.add_person");
    private static final Component SCROLL_TO_BOTTOM = Component.m_237115_((String)"chat_screen.scroll_to_bottom");
    private static final Component OFFLINE = Component.m_237115_((String)"chat_screen.offline");
    private static final Component COPY_AS_TEXT = Component.m_237115_((String)"rc.copy_as_text");
    private final int screenWidth = 322;
    private final int screenHeight = 202;
    private int bx;
    private int by;
    public final ChatManager chatManager = ChatScreenMain.getCurrentManager();
    private double contactsScrollAmount = 0.0;
    private MyEditBoxWidget inputBox;
    private Chat hoveredChat = null;
    private Message hoveredMessage = null;
    private RCContext rcContext;
    private boolean addPersonHovered = false;
    private boolean toBottomHovered = false;

    public ChatScreen() {
        super((Component)Component.m_237119_());
    }

    public void m_280273_(GuiGraphics context) {
        context.m_280024_(0, 0, this.f_96543_, this.f_96544_, -1072689136, -804253680);
        context.m_280163_(GUI_TEXTURE, this.bx, this.by, 0.0f, 0.0f, 322, 202, 512, 512);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean checkCanChat() {
        Chat selectedChat = this.chatManager.getSelectedChat();
        if (selectedChat == null) return false;
        if (!(selectedChat instanceof PersonChat)) return true;
        PersonChat personChat = (PersonChat)selectedChat;
        if (personChat.person.offline) return false;
        return true;
    }

    protected void m_7856_() {
        boolean canChat;
        super.m_7856_();
        this.bx = (this.f_96543_ - 322) / 2;
        this.by = (this.f_96544_ - 202) / 2;
        this.inputBox = new MyEditBoxWidget(this.f_96541_.f_91062_, this.bx + 108, this.by + 161, 205, 32, INPUT_EMPTY, (Component)Component.m_237119_());
        this.inputBox.m_239313_(256);
        this.m_142416_((GuiEventListener)this.inputBox);
        this.inputBox.f_93623_ = canChat = this.checkCanChat();
        this.inputBox.f_93624_ = canChat;
        if (!canChat) {
            this.inputBox.m_93692_(false);
        }
        this.rcContext = null;
    }

    public void m_88315_(GuiGraphics context, int mouseX, int mouseY, float delta) {
        boolean canChat;
        super.m_88315_(context, mouseX, mouseY, delta);
        this.m_280273_(context);
        Font font = this.f_96541_.f_91062_;
        List<Chat> chats = this.chatManager.getAllChats();
        Chat selectedChat = this.chatManager.getSelectedChat();
        this.fixScrollAmount(chats.size());
        int csa = this.getCSA();
        int x0 = this.bx + 7;
        int x1 = this.bx + 100;
        int y0 = this.by + 9;
        this.hoveredChat = null;
        for (int i = 0; i < 6 && i + csa < chats.size(); ++i) {
            Chat chat = chats.get(i + csa);
            if (this.rcContext == null && mouseX >= x0 && mouseX < x1 && mouseY >= y0 && mouseY < y0 + 30) {
                context.m_280509_(x0, y0, x1, y0 + 30, 0x6BFFFFFF);
                this.hoveredChat = chat;
            }
            if (selectedChat == chat) {
                context.m_280509_(x0, y0, x1, y0 + 30, 0x44FFFFFF);
            }
            chat.render(context, x0, y0, font);
            y0 += 30;
        }
        boolean offlineHovered = false;
        if (selectedChat == null) {
            context.m_280614_(font, NO_CHAT, this.bx + 112, this.by + 10, -12566464, false);
        } else {
            selectedChat.renderAvatar(context, this.bx + 107, this.by + 6);
            Component text = selectedChat.name;
            int tx = this.bx + 128;
            int ty = this.by + 10;
            context.m_280614_(font, text, tx, ty, -12566464, false);
            if (selectedChat instanceof PersonChat) {
                PersonChat personChat = (PersonChat)selectedChat;
                if (personChat.person.offline) {
                    int width = font.m_92852_((FormattedText)text);
                    int tox = tx + width + 5;
                    int toy = ty + 2;
                    context.m_280509_(tox, toy, tox + 5, toy + 5, -11184811);
                    if (mouseX >= tox && mouseX < tox + 5 && mouseY >= ty && mouseY < ty + 5) {
                        offlineHovered = true;
                    }
                }
            }
        }
        this.addPersonHovered = false;
        int bux = this.bx + 299;
        int buy = this.by + 7;
        if (this.rcContext == null && mouseX >= bux && mouseX < bux + 12 && mouseY >= buy && mouseY < buy + 12) {
            this.addPersonHovered = true;
            context.m_280509_(bux, buy, bux + 12, buy + 12, 0x44FFFFFF);
        }
        this.hoveredMessage = null;
        if (selectedChat != null) {
            int left = this.bx + 106;
            int right = this.bx + 315;
            int top = this.by + 26;
            int bottom = this.by + 158;
            context.m_280588_(left, top, right, bottom);
            boolean mouseIn = this.rcContext == null && mouseX >= left && mouseX < right;
            this.hoveredMessage = selectedChat.renderMessages(context, left, top, right, bottom, font, mouseIn, mouseY);
            context.m_280618_();
        }
        this.inputBox.f_93623_ = canChat = this.checkCanChat();
        this.inputBox.f_93624_ = canChat;
        if (!canChat) {
            this.inputBox.m_93692_(false);
        }
        this.toBottomHovered = false;
        if (selectedChat != null && (selectedChat.newMessagesCount() > 0 || selectedChat.isLastScrollDown())) {
            int tx = this.bx + 202;
            int ty = this.by + 148;
            context.m_280168_().m_252880_(0.0f, 0.0f, 0.06f);
            int nmc = selectedChat.newMessagesCount();
            if (nmc > 0) {
                context.m_280163_(GUI_TEXTURE, tx, ty, 349.0f, 5.0f, 17, 9, 512, 512);
                String count = nmc < 100 ? String.valueOf(nmc) : "99+";
                int width = font.m_92895_(count);
                context.m_280056_(font, count, tx + 9 - width / 2, ty + 1, -1, false);
            } else {
                context.m_280163_(GUI_TEXTURE, tx, ty, 327.0f, 5.0f, 17, 9, 512, 512);
            }
            if (this.rcContext == null && mouseX >= tx && mouseX < tx + 17 && mouseY >= ty && mouseY < ty + 9) {
                this.toBottomHovered = true;
                context.m_280509_(tx, ty, tx + 17, ty + 9, 0x44FFFFFF);
            }
            context.m_280262_();
        }
        if (this.addPersonHovered) {
            context.m_280557_(font, ADD_PERSON, mouseX, mouseY);
        }
        if (this.toBottomHovered) {
            context.m_280557_(font, SCROLL_TO_BOTTOM, mouseX, mouseY);
        }
        if (offlineHovered) {
            context.m_280557_(font, OFFLINE, mouseX, mouseY);
        }
        if (this.rcContext != null) {
            context.m_280168_().m_252880_(0.0f, 0.0f, 0.09f);
            this.rcContext.render(context, mouseX, mouseY, font);
            context.m_280262_();
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.rcContext != null) {
            if (this.rcContext.onMouseClicked((int)mouseX, (int)mouseY)) {
                this.rcContext = null;
            }
            return true;
        }
        if (button == 0) {
            Chat selectedChat = this.chatManager.getSelectedChat();
            if (this.toBottomHovered && selectedChat != null) {
                selectedChat.scrollToBottom();
                return true;
            }
            if (this.addPersonHovered) {
                this.f_96541_.m_91152_((Screen)new MySocialInteractionsScreen(this));
                return true;
            }
            if (this.hoveredChat != null) {
                if (this.hoveredChat != selectedChat) {
                    this.chatManager.selectChat(this.hoveredChat);
                }
                return true;
            }
        } else if (button == 1) {
            Chat chat = this.hoveredChat;
            if (chat instanceof PersonChat) {
                PersonChat personChat = (PersonChat)chat;
                this.rcContext = RCContext.builder((int)mouseX, (int)mouseY).addButton(DELETE_PERSON, () -> this.chatManager.removePersonChat(personChat)).build();
                return true;
            }
            if (this.hoveredMessage != null) {
                Message hoveredMessage = this.hoveredMessage;
                RCContext.Builder builder = RCContext.builder((int)mouseX, (int)mouseY);
                Person person = hoveredMessage.sender;
                if (!person.isMe()) {
                    builder.addButton((Component)Component.m_237110_((String)"rc.chat_with", (Object[])new Object[]{person.getCachedName()}), () -> this.chatManager.addPersonChat(person, true));
                }
                builder.addButton(COPY_AS_TEXT, () -> this.copyToClipboard(hoveredMessage.content));
                this.rcContext = builder.build();
                return true;
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    private void fixScrollAmount(int size) {
        if (this.contactsScrollAmount + 6.0 > (double)size) {
            this.contactsScrollAmount = size - 6;
        }
        if (this.contactsScrollAmount < 0.0) {
            this.contactsScrollAmount = 0.0;
        }
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        if (this.rcContext != null) {
            return true;
        }
        if (mouseX >= (double)(this.bx + 7) && mouseX < (double)(this.bx + 100) && mouseY >= (double)(this.by + 7) && mouseY < (double)(this.by + 195)) {
            this.contactsScrollAmount -= amount;
            return true;
        }
        Chat selectedChat = this.chatManager.getSelectedChat();
        if (selectedChat != null && mouseX >= (double)(this.bx + 106) && mouseX < (double)(this.bx + 315) && mouseY >= (double)(this.by + 26) && mouseY < (double)(this.by + 158)) {
            selectedChat.scroll(amount * 8.0);
            return true;
        }
        return super.m_6050_(mouseX, mouseY, amount);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        String content;
        Chat selectedChat;
        if (this.inputBox.m_93696_() && (keyCode == 257 || keyCode == 335) && (selectedChat = this.chatManager.getSelectedChat()) != null && this.chatManager.submitMessage(content = ChatScreen.normalize(this.inputBox.m_239249_()))) {
            this.inputBox.m_240159_("");
            selectedChat.scrollToBottom();
            return true;
        }
        if (!this.inputBox.m_93696_() && ((KeyMapping)ChatScreenMain.OPEN_CHAT_SCREEN.get()).m_90832_(keyCode, scanCode)) {
            this.f_96541_.m_91152_(null);
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    private static String normalize(String chatText) {
        return StringUtil.m_216469_((String)StringUtils.normalizeSpace((String)chatText.trim()));
    }

    private void copyToClipboard(Component text) {
        String s = text.getString();
        this.f_96541_.f_91068_.m_90911_(s);
    }

    public boolean m_7043_() {
        return false;
    }

    private int getCSA() {
        return (int)this.contactsScrollAmount;
    }
}

