/*
 * Decompiled with CFR 0.152.
 */
package com.whyvo.chatscreen;

import com.whyvo.chatscreen.chat.ChatManager;
import com.whyvo.chatscreen.chat.Person;
import com.whyvo.chatscreen.screen.ChatScreen;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.minecraft.class_2561;
import net.minecraft.class_270;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_746;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChatScreenMain
implements ClientModInitializer {
    public static final String MOD_ID = "chatscreen";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"chatscreen");
    public static final class_304 OPEN_CHAT_SCREEN = new class_304("key.chatscreen.open_chat_screen", class_3675.class_307.field_1668, 67, "key.categories.multiplayer");
    private static final class_2561 CHAT_SCREEN_NOT_AVAILABLE = class_2561.method_43471((String)"multiplayer.chatscreen.not_available");
    private static ChatManager currentManager;
    private static class_270 lastTeam;
    private static boolean lastConnected;

    public static class_2960 modIdentifier(String path) {
        return class_2960.method_43902((String)MOD_ID, (String)path);
    }

    public void onInitializeClient() {
        KeyBindingHelper.registerKeyBinding((class_304)OPEN_CHAT_SCREEN);
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            class_270 team;
            boolean connected = ChatScreenMain.canUseChatScreen(client);
            if (connected != lastConnected) {
                if (connected) {
                    ChatScreenMain.loadChatManager();
                    ChatManager.loadAllMessageTypes(client.field_1724);
                } else {
                    ChatScreenMain.unloadChatManager();
                }
                lastConnected = connected;
            }
            class_746 player = client.field_1724;
            if (OPEN_CHAT_SCREEN.method_1436() && client.field_1755 == null) {
                if (!connected) {
                    player.method_7353(CHAT_SCREEN_NOT_AVAILABLE, true);
                } else {
                    client.method_1507((class_437)new ChatScreen());
                }
            }
            if (connected && player != null && (team = player.method_5781()) != lastTeam) {
                if (team == null) {
                    currentManager.removeTeamChat();
                } else {
                    currentManager.addTeamChat();
                }
                lastTeam = team;
            }
        });
        LOGGER.info("Chat Screen Initialized!");
    }

    private static boolean canUseChatScreen(class_310 client) {
        return client.field_1724 != null && (!client.method_1496() || client.method_1576() != null && client.method_1576().method_3860());
    }

    public static void loadChatManager() {
        currentManager = new ChatManager();
    }

    public static void unloadChatManager() {
        currentManager = null;
        Person.clearCached();
    }

    public static ChatManager getCurrentManager() {
        return currentManager;
    }
}

