/*
 * Decompiled with CFR 0.152.
 */
package com.whyvo.chatscreen.chat;

import com.whyvo.chatscreen.chat.Chat;
import com.whyvo.chatscreen.chat.GroupChat;
import com.whyvo.chatscreen.chat.Message;
import com.whyvo.chatscreen.chat.Person;
import com.whyvo.chatscreen.chat.PersonChat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.ToLongFunction;
import net.minecraft.class_2378;
import net.minecraft.class_2556;
import net.minecraft.class_310;
import net.minecraft.class_746;
import net.minecraft.class_7924;

public class ChatManager {
    public static class_2556 CHAT_TYPE;
    public static class_2556 INCOMING_TYPE;
    public static class_2556 OUTGOING_TYPE;
    public static class_2556 TEAM_INCOMING_TYPE;
    public static class_2556 TEAM_OUTGOING_TYPE;
    private static final ToLongFunction<? super PersonChat> LONG_EXTRACT;
    public final GroupChat serverChat = GroupChat.server();
    public GroupChat teamChat = null;
    public final List<PersonChat> personChats = new ArrayList<PersonChat>();
    private final Map<Person, PersonChat> personChatMap = new HashMap<Person, PersonChat>();
    private Chat selectedChat = null;

    public static void loadAllMessageTypes(class_746 player) {
        class_2378 registry = player.field_3944.method_29091().method_30530(class_7924.field_41237);
        CHAT_TYPE = (class_2556)registry.method_31140(class_2556.field_11737);
        INCOMING_TYPE = (class_2556)registry.method_31140(class_2556.field_39799);
        OUTGOING_TYPE = (class_2556)registry.method_31140(class_2556.field_39800);
        TEAM_INCOMING_TYPE = (class_2556)registry.method_31140(class_2556.field_39881);
        TEAM_OUTGOING_TYPE = (class_2556)registry.method_31140(class_2556.field_39882);
    }

    public GroupChat addTeamChat() {
        this.teamChat = GroupChat.team();
        this.selectChat(this.teamChat);
        return this.teamChat;
    }

    public void removeTeamChat() {
        if (this.selectedChat == this.teamChat) {
            this.selectedChat = null;
        }
        this.teamChat = null;
    }

    public PersonChat addPersonChat(Person person, boolean select) {
        PersonChat chat = this.personChatMap.get(person);
        if (chat == null) {
            chat = new PersonChat(person);
            chat.lastMessageTime = Instant.now().getEpochSecond();
            this.personChatMap.put(person, chat);
            this.personChats.add(chat);
            this.sortPersonChats();
        }
        if (select) {
            this.selectChat(chat);
        }
        return chat;
    }

    public void removePersonChat(PersonChat chat) {
        if (chat == this.selectedChat) {
            this.selectChat(null);
        }
        this.personChats.remove(chat);
        this.personChatMap.remove(chat.person);
    }

    public void selectChat(Chat chat) {
        this.selectedChat = chat;
        if (this.selectedChat != null) {
            this.selectedChat.unreadMessages = 0;
        }
    }

    public Chat getSelectedChat() {
        return this.selectedChat;
    }

    public void newServerMessage(Message message) {
        this.serverChat.newMessage(message);
        if (this.selectedChat != this.serverChat) {
            ++this.serverChat.unreadMessages;
        }
    }

    public void newTeamMessage(Message message) {
        if (this.teamChat == null) {
            return;
        }
        this.teamChat.newMessage(message);
        if (this.selectedChat != this.teamChat) {
            ++this.teamChat.unreadMessages;
        }
    }

    public void newPersonMessage(Person person, Message message) {
        PersonChat chat = this.personChatMap.get(person);
        if (chat == null) {
            chat = this.addPersonChat(person, false);
        }
        chat.newMessage(message);
        if (this.selectedChat != chat) {
            ++chat.unreadMessages;
        }
        this.sortPersonChats();
    }

    private void sortPersonChats() {
        this.personChats.sort((c1, c2) -> Long.compare(LONG_EXTRACT.applyAsLong((PersonChat)c2), LONG_EXTRACT.applyAsLong((PersonChat)c1)));
    }

    public boolean submitMessage(String content) {
        class_310 client = class_310.method_1551();
        Chat chat = this.selectedChat;
        if (chat == null) {
            return false;
        }
        if (!content.isEmpty()) {
            client.field_1705.method_1743().method_1803(content);
            if (chat == this.serverChat) {
                client.field_1724.field_3944.method_45729(content);
            } else if (chat == this.teamChat) {
                client.field_1724.field_3944.method_45730("teammsg " + content);
            } else if (chat instanceof PersonChat) {
                PersonChat personChat = (PersonChat)chat;
                client.field_1724.field_3944.method_45730("msg " + personChat.person.getCachedName().getString() + " " + content);
            } else {
                return false;
            }
            return true;
        }
        return false;
    }

    public List<Chat> getAllChats() {
        ArrayList<Chat> chats = new ArrayList<Chat>();
        chats.add(this.serverChat);
        if (this.teamChat != null) {
            chats.add(this.teamChat);
        }
        chats.addAll(this.personChats);
        return chats;
    }

    static {
        LONG_EXTRACT = personChat -> personChat.lastMessageTime;
    }
}

