/*
 * Decompiled with CFR 0.152.
 */
package com.whyvo.chatscreen.mixin;

import com.mojang.authlib.GameProfile;
import com.whyvo.chatscreen.ChatScreenMain;
import com.whyvo.chatscreen.chat.ChatManager;
import com.whyvo.chatscreen.chat.Message;
import com.whyvo.chatscreen.chat.Person;
import java.time.Instant;
import net.minecraft.class_2556;
import net.minecraft.class_2561;
import net.minecraft.class_7471;
import net.minecraft.class_7594;
import net.minecraft.class_7649;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_7594.class})
public class MessageHandlerMixin {
    @Inject(method={"processChatMessageInternal"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/hud/ChatHud;addMessage(Lnet/minecraft/text/Text;Lnet/minecraft/network/message/MessageSignatureData;Lnet/minecraft/client/gui/hud/MessageIndicator;)V")})
    private void injectProcessChatMessageInternal(class_2556.class_7602 params, class_7471 message, class_2561 decorated, GameProfile sender, boolean onlyShowSecureChat, Instant receptionTimestamp, CallbackInfoReturnable<Boolean> cir) {
        ChatManager manager = ChatScreenMain.getCurrentManager();
        if (manager != null) {
            class_2561 content;
            class_7649 filterMask = message.comp_981();
            class_2561 class_25612 = content = filterMask.method_45087() ? message.method_46291() : filterMask.method_46256(message.method_44862());
            if (content == null) {
                return;
            }
            long time = receptionTimestamp.toEpochMilli();
            class_2556 type = params.comp_919();
            Person person = Person.of(sender.getId());
            Message chatMessage = new Message(time, person, content);
            if (type == ChatManager.CHAT_TYPE) {
                manager.newServerMessage(chatMessage);
            } else if (type == ChatManager.INCOMING_TYPE) {
                manager.newPersonMessage(person, chatMessage);
            } else if (type == ChatManager.OUTGOING_TYPE) {
                String name;
                Person target;
                class_2561 targetName = params.comp_921();
                if (targetName != null && (target = Person.tryFind(name = targetName.getString())) != null) {
                    manager.newPersonMessage(target, chatMessage);
                }
            } else if (type == ChatManager.TEAM_INCOMING_TYPE || type == ChatManager.TEAM_OUTGOING_TYPE) {
                manager.newTeamMessage(chatMessage);
            }
        }
    }
}

