/*
 * Decompiled with CFR 0.152.
 */
package com.whyvo.chatscreen.chat;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_640;
import net.minecraft.class_746;
import net.minecraft.class_7532;
import net.minecraft.class_8685;

public class Person {
    private static final Map<UUID, Person> cached = new HashMap<UUID, Person>();
    public final UUID uuid;
    private class_2561 cachedName;
    private final boolean me;
    private final Supplier<class_8685> skinSupplier;
    public boolean offline = false;

    public static Person of(UUID uuid) {
        Person person = cached.get(uuid);
        if (person == null) {
            person = new Person(uuid);
            cached.put(uuid, person);
        }
        return person;
    }

    public static Person tryFind(String name) {
        class_640 player = class_310.method_1551().field_1724.field_3944.method_2874(name);
        if (player != null) {
            return Person.of(player.method_2966().id());
        }
        return null;
    }

    public static Person getKnownOrNull(UUID uuid) {
        return cached.get(uuid);
    }

    public static void clearCached() {
        cached.clear();
    }

    private Person(UUID uuid) {
        class_746 myself = class_310.method_1551().field_1724;
        class_640 playerListEntry = myself.field_3944.method_2871(uuid);
        if (playerListEntry == null) {
            throw new RuntimeException("No such player!");
        }
        this.uuid = uuid;
        this.me = myself.method_5667().equals(uuid);
        this.cachedName = this.me ? myself.method_5476() : class_2561.method_43470((String)playerListEntry.method_2966().name());
        this.skinSupplier = () -> ((class_640)playerListEntry).method_52810();
    }

    public class_2561 getCachedName() {
        return this.cachedName;
    }

    public void updateName(class_2561 name) {
        this.cachedName = name;
    }

    public boolean isMe() {
        return this.me;
    }

    public class_8685 getSkinTexture() {
        return this.skinSupplier.get();
    }

    public void drawAvatar(class_332 context, int x, int y) {
        class_7532.method_52722((class_332)context, (class_8685)this.getSkinTexture(), (int)x, (int)y, (int)16);
    }

    public int hashCode() {
        return this.uuid.hashCode();
    }
}

