/*
 * Decompiled with CFR 0.152.
 */
package com.whyvo.chatscreen.screen;

import com.whyvo.chatscreen.ChatScreenMain;
import com.whyvo.chatscreen.chat.Chat;
import com.whyvo.chatscreen.chat.ChatManager;
import com.whyvo.chatscreen.chat.Message;
import com.whyvo.chatscreen.chat.Person;
import com.whyvo.chatscreen.chat.PersonChat;
import com.whyvo.chatscreen.screen.MyEditBoxWidget;
import com.whyvo.chatscreen.screen.rc.RCContext;
import com.whyvo.chatscreen.screen.social.MySocialInteractionsScreen;
import java.util.List;
import net.minecraft.class_10799;
import net.minecraft.class_11876;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3544;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import org.apache.commons.lang3.StringUtils;

public class ChatScreen
extends class_437 {
    private static final class_2960 GUI_TEXTURE = ChatScreenMain.modIdentifier("textures/gui/chat_screen.png");
    private static final class_2561 NO_CHAT = class_2561.method_43471((String)"chat_screen.no_chat");
    private static final class_2561 INPUT_EMPTY = class_2561.method_43471((String)"chat_screen.input_empty").method_27692(class_124.field_1080);
    private static final class_2561 DELETE_PERSON = class_2561.method_43471((String)"rc.delete_person");
    private static final class_2561 ADD_PERSON = class_2561.method_43471((String)"chat_screen.add_person");
    private static final class_2561 SCROLL_TO_BOTTOM = class_2561.method_43471((String)"chat_screen.scroll_to_bottom");
    private static final class_2561 OFFLINE = class_2561.method_43471((String)"chat_screen.offline");
    private static final class_2561 COPY_AS_TEXT = class_2561.method_43471((String)"rc.copy_as_text");
    private final int screenWidth = 322;
    private final int screenHeight = 202;
    private int bx;
    private int by;
    public final ChatManager chatManager = ChatScreenMain.getCurrentManager();
    private double contactsScrollAmount = 0.0;
    private MyEditBoxWidget inputBox;
    private Chat hoveredChat = null;
    private Message hoveredMessage = null;
    private RCContext rcContext;
    private boolean addPersonHovered = false;
    private boolean toBottomHovered = false;

    public ChatScreen() {
        super((class_2561)class_2561.method_43473());
    }

    public void method_25420(class_332 context, int mouseX, int mouseY, float delta) {
        this.method_57735(context);
        context.method_25290(class_10799.field_56883, GUI_TEXTURE, this.bx, this.by, 0.0f, 0.0f, 322, 202, 512, 512);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean checkCanChat() {
        Chat selectedChat = this.chatManager.getSelectedChat();
        if (selectedChat == null) return false;
        if (!(selectedChat instanceof PersonChat)) return true;
        PersonChat personChat = (PersonChat)selectedChat;
        if (personChat.person.offline) return false;
        return true;
    }

    protected void method_25426() {
        boolean canChat;
        super.method_25426();
        this.bx = (this.field_22789 - 322) / 2;
        this.by = (this.field_22790 - 202) / 2;
        this.inputBox = new MyEditBoxWidget(this.field_22787.field_1772, this.bx + 108, this.by + 161, 205, 32, INPUT_EMPTY, (class_2561)class_2561.method_43473());
        this.inputBox.method_44402(256);
        this.method_37063((class_364)this.inputBox);
        this.inputBox.field_22763 = canChat = this.checkCanChat();
        this.inputBox.field_22764 = canChat;
        if (!canChat) {
            this.inputBox.method_25365(false);
        }
        this.rcContext = null;
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        boolean canChat;
        super.method_25394(context, mouseX, mouseY, delta);
        class_327 font = this.field_22787.field_1772;
        List<Chat> chats = this.chatManager.getAllChats();
        Chat selectedChat = this.chatManager.getSelectedChat();
        this.fixScrollAmount(chats.size());
        int csa = this.getCSA();
        int x0 = this.bx + 7;
        int x1 = this.bx + 100;
        int y0 = this.by + 9;
        this.hoveredChat = null;
        for (int i = 0; i < 6 && i + csa < chats.size(); ++i) {
            Chat chat = chats.get(i + csa);
            if (this.rcContext == null && mouseX >= x0 && mouseX < x1 && mouseY >= y0 && mouseY < y0 + 30) {
                context.method_25294(x0, y0, x1, y0 + 30, 0x6BFFFFFF);
                this.hoveredChat = chat;
                context.method_74037(class_11876.field_62455);
            }
            if (selectedChat == chat) {
                context.method_25294(x0, y0, x1, y0 + 30, 0x44FFFFFF);
            }
            chat.render(context, x0, y0, font);
            y0 += 30;
        }
        boolean offlineHovered = false;
        if (selectedChat == null) {
            context.method_51439(font, NO_CHAT, this.bx + 112, this.by + 10, -12566464, false);
        } else {
            selectedChat.renderAvatar(context, this.bx + 107, this.by + 6);
            class_2561 text = selectedChat.name;
            int tx = this.bx + 128;
            int ty = this.by + 10;
            context.method_51439(font, text, tx, ty, -12566464, false);
            if (selectedChat instanceof PersonChat) {
                PersonChat personChat = (PersonChat)selectedChat;
                if (personChat.person.offline) {
                    int width = font.method_27525((class_5348)text);
                    int tox = tx + width + 5;
                    int toy = ty + 2;
                    context.method_25294(tox, toy, tox + 5, toy + 5, -11184811);
                    if (mouseX >= tox && mouseX < tox + 5 && mouseY >= ty && mouseY < ty + 5) {
                        offlineHovered = true;
                    }
                }
            }
        }
        this.addPersonHovered = false;
        int bux = this.bx + 299;
        int buy = this.by + 7;
        if (this.rcContext == null && mouseX >= bux && mouseX < bux + 12 && mouseY >= buy && mouseY < buy + 12) {
            this.addPersonHovered = true;
            context.method_25294(bux, buy, bux + 12, buy + 12, 0x44FFFFFF);
            context.method_74037(class_11876.field_62455);
        }
        this.hoveredMessage = null;
        if (selectedChat != null) {
            int left = this.bx + 106;
            int right = this.bx + 315;
            int top = this.by + 26;
            int bottom = this.by + 158;
            context.method_44379(left, top, right, bottom);
            boolean mouseIn = this.rcContext == null && mouseX >= left && mouseX < right;
            this.hoveredMessage = selectedChat.renderMessages(context, left, top, right, bottom, font, mouseIn, mouseY);
            context.method_44380();
        }
        this.inputBox.field_22763 = canChat = this.checkCanChat();
        this.inputBox.field_22764 = canChat;
        if (!canChat) {
            this.inputBox.method_25365(false);
        }
        this.toBottomHovered = false;
        if (selectedChat != null && (selectedChat.newMessagesCount() > 0 || selectedChat.isLastScrollDown())) {
            int tx = this.bx + 202;
            int ty = this.by + 148;
            int nmc = selectedChat.newMessagesCount();
            if (nmc > 0) {
                context.method_25290(class_10799.field_56883, GUI_TEXTURE, tx, ty, 349.0f, 5.0f, 17, 9, 512, 512);
                String count = nmc < 100 ? String.valueOf(nmc) : "99+";
                int width = font.method_1727(count);
                context.method_51433(font, count, tx + 9 - width / 2, ty + 1, -1, false);
            } else {
                context.method_25290(class_10799.field_56883, GUI_TEXTURE, tx, ty, 327.0f, 5.0f, 17, 9, 512, 512);
            }
            if (this.rcContext == null && mouseX >= tx && mouseX < tx + 17 && mouseY >= ty && mouseY < ty + 9) {
                this.toBottomHovered = true;
                context.method_25294(tx, ty, tx + 17, ty + 9, 0x44FFFFFF);
                context.method_74037(class_11876.field_62455);
            }
        }
        if (this.addPersonHovered) {
            context.method_51438(font, ADD_PERSON, mouseX, mouseY);
        }
        if (this.toBottomHovered) {
            context.method_51438(font, SCROLL_TO_BOTTOM, mouseX, mouseY);
        }
        if (offlineHovered) {
            context.method_51438(font, OFFLINE, mouseX, mouseY);
        }
        if (this.rcContext != null) {
            this.rcContext.render(context, mouseX, mouseY, font);
        }
    }

    public boolean method_25402(class_11909 click, boolean doubled) {
        if (doubled) {
            return super.method_25402(click, true);
        }
        double mouseX = click.comp_4798();
        double mouseY = click.comp_4799();
        int button = click.method_74245();
        if (this.rcContext != null) {
            if (this.rcContext.onMouseClicked((int)mouseX, (int)mouseY)) {
                this.rcContext = null;
            }
            return true;
        }
        if (button == 0) {
            Chat selectedChat = this.chatManager.getSelectedChat();
            if (this.toBottomHovered && selectedChat != null) {
                selectedChat.scrollToBottom();
                return true;
            }
            if (this.addPersonHovered) {
                this.field_22787.method_1507((class_437)new MySocialInteractionsScreen(this));
                return true;
            }
            if (this.hoveredChat != null) {
                if (this.hoveredChat != selectedChat) {
                    this.chatManager.selectChat(this.hoveredChat);
                }
                return true;
            }
        } else if (button == 1) {
            Chat chat = this.hoveredChat;
            if (chat instanceof PersonChat) {
                PersonChat personChat = (PersonChat)chat;
                this.rcContext = RCContext.builder((int)mouseX, (int)mouseY).addButton(DELETE_PERSON, () -> this.chatManager.removePersonChat(personChat)).build();
                return true;
            }
            if (this.hoveredMessage != null) {
                Message hoveredMessage = this.hoveredMessage;
                RCContext.Builder builder = RCContext.builder((int)mouseX, (int)mouseY);
                Person person = hoveredMessage.sender;
                if (!person.isMe()) {
                    builder.addButton((class_2561)class_2561.method_43469((String)"rc.chat_with", (Object[])new Object[]{person.getCachedName()}), () -> this.chatManager.addPersonChat(person, true));
                }
                builder.addButton(COPY_AS_TEXT, () -> this.copyToClipboard(hoveredMessage.content));
                this.rcContext = builder.build();
                return true;
            }
        }
        return super.method_25402(click, false);
    }

    private void fixScrollAmount(int size) {
        if (this.contactsScrollAmount + 6.0 > (double)size) {
            this.contactsScrollAmount = size - 6;
        }
        if (this.contactsScrollAmount < 0.0) {
            this.contactsScrollAmount = 0.0;
        }
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (this.rcContext != null) {
            return true;
        }
        if (mouseX >= (double)(this.bx + 7) && mouseX < (double)(this.bx + 100) && mouseY >= (double)(this.by + 7) && mouseY < (double)(this.by + 195)) {
            this.contactsScrollAmount -= verticalAmount;
            return true;
        }
        Chat selectedChat = this.chatManager.getSelectedChat();
        if (selectedChat != null && mouseX >= (double)(this.bx + 106) && mouseX < (double)(this.bx + 315) && mouseY >= (double)(this.by + 26) && mouseY < (double)(this.by + 158)) {
            selectedChat.scroll(verticalAmount * 8.0);
            return true;
        }
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    public boolean method_25404(class_11908 input) {
        String content;
        Chat selectedChat;
        if (this.inputBox.method_25370() && input.method_74230() && (selectedChat = this.chatManager.getSelectedChat()) != null && this.chatManager.submitMessage(content = ChatScreen.normalize(this.inputBox.method_44405()))) {
            this.inputBox.method_44400("");
            selectedChat.scrollToBottom();
            return true;
        }
        if (!this.inputBox.method_25370() && ChatScreenMain.OPEN_CHAT_SCREEN.method_1417(input)) {
            this.field_22787.method_1507(null);
            return true;
        }
        return super.method_25404(input);
    }

    public static String normalize(String chatText) {
        return class_3544.method_43681((String)StringUtils.normalizeSpace((String)chatText.trim()));
    }

    private void copyToClipboard(class_2561 text) {
        String s = text.getString();
        this.field_22787.field_1774.method_1455(s);
    }

    public boolean method_25421() {
        return false;
    }

    private int getCSA() {
        return (int)this.contactsScrollAmount;
    }
}

